/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.wizards;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Widget;
import org.xmind.ui.internal.wizards.WizardMessages;
import org.xmind.ui.wizards.AbstractExportWizard;

public abstract class AbstractExportPage
extends WizardPage {
    protected static final String FILTER_ALL_FILES = "*.*";
    private Combo pathInput;
    private Button browseButton;
    private Button overwriteCheckButton;
    private boolean modifyingPathInput = false;
    private boolean settingTargetPath = false;
    private Listener widgetListener = null;

    protected AbstractExportPage(String pageName) {
        super(pageName);
    }

    protected AbstractExportPage(String pageName, String title, ImageDescriptor titleImage) {
        super(pageName, title, titleImage);
    }

    protected AbstractExportWizard getCastedWizard() {
        return (AbstractExportWizard)super.getWizard();
    }

    protected String getTargetPath() {
        return this.getCastedWizard().getTargetPath();
    }

    protected List<String> getPathHistory() {
        return this.getCastedWizard().getPathHistory();
    }

    protected boolean hasTargetPath() {
        return this.getCastedWizard().hasTargetPath();
    }

    protected Control createFileControls(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        gridLayout.verticalSpacing = 10;
        gridLayout.horizontalSpacing = 0;
        composite.setLayout((Layout)gridLayout);
        Composite group = new Composite(composite, 0);
        GridLayout layout = new GridLayout(3, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        group.setLayout((Layout)layout);
        group.setLayoutData((Object)new GridData(4, 4, true, false));
        Label toFileLabel = new Label(group, 64);
        toFileLabel.setLayoutData((Object)new GridData(1, 2, false, true));
        toFileLabel.setText(WizardMessages.ExportPage_ToFile_text);
        this.pathInput = new Combo(group, 2116);
        Point preferredSize = this.pathInput.computeSize(-1, -1);
        GridData comboLayoutData = new GridData(768);
        comboLayoutData.widthHint = preferredSize.x;
        this.pathInput.setLayoutData((Object)comboLayoutData);
        for (String path : this.getCastedWizard().getPathHistory()) {
            this.pathInput.add(path, 0);
        }
        String targetPath = this.getTargetPath();
        if (targetPath != null) {
            this.pathInput.setText(targetPath);
        }
        this.hookWidget((Widget)this.pathInput, 24);
        this.hookWidget((Widget)this.pathInput, 15);
        this.browseButton = new Button(group, 8);
        this.browseButton.setText(WizardMessages.ExportPage_Browse_text);
        int width = this.browseButton.computeSize((int)-1, (int)-1).x;
        GridData layoutData = new GridData(3, 2, false, true);
        layoutData.widthHint = Math.max(93, width);
        this.browseButton.setLayoutData((Object)layoutData);
        this.hookWidget((Widget)this.browseButton, 13);
        this.overwriteCheckButton = new Button(composite, 32);
        this.overwriteCheckButton.setLayoutData((Object)new GridData(4, 2, true, false));
        this.overwriteCheckButton.setText(WizardMessages.ExportPage_OverwriteWithoutWarning_text);
        this.overwriteCheckButton.setSelection(this.getCastedWizard().isOverwriteWithoutPrompt());
        this.hookWidget((Widget)this.overwriteCheckButton, 13);
        this.updateStatus();
        return composite;
    }

    public void dispose() {
        super.dispose();
        this.pathInput = null;
        this.browseButton = null;
        this.overwriteCheckButton = null;
    }

    protected void hookWidget(Widget widget, int eventType) {
        if (this.widgetListener == null) {
            this.widgetListener = new WidgetListener();
        }
        widget.addListener(eventType, this.widgetListener);
    }

    protected void handleWidgetEvent(Event event) {
        if (event.widget == this.pathInput) {
            if (event.type == 24) {
                if (!this.settingTargetPath) {
                    this.modifyingPathInput = true;
                    this.setTargetPath(this.pathInput.getText());
                    this.modifyingPathInput = false;
                }
                this.updateStatus();
            } else if (event.type == 15) {
                this.pathInput.setSelection(new Point(0, this.pathInput.getText().length()));
            }
        } else if (event.widget == this.browseButton) {
            this.openBrowseDialog();
            this.pathInput.setFocus();
        } else if (event.widget == this.overwriteCheckButton) {
            this.setOverwriteWithoutPrompt(this.overwriteCheckButton.getSelection());
            this.updateStatus();
        }
    }

    protected void setOverwriteWithoutPrompt(boolean selection) {
        this.getCastedWizard().setOverwriteWithoutPrompt(selection);
    }

    protected void openBrowseDialog() {
        FileDialog dialog = this.createBrowseDialog();
        String path = dialog.open();
        if (path != null) {
            this.setTargetPath(path);
        }
    }

    protected FileDialog createBrowseDialog() {
        FileDialog dialog = new FileDialog(this.getShell(), 8192);
        dialog.setText(WizardMessages.ExportPage_FileDialog_title);
        ArrayList<String> filterNames = new ArrayList<String>(4);
        ArrayList<String> filterExtensions = new ArrayList<String>(4);
        filterNames.add(WizardMessages.ExportPage_FileDialog_AllFiles);
        filterExtensions.add(FILTER_ALL_FILES);
        this.setDialogFilters(dialog, filterNames, filterExtensions);
        if (this.getTargetPath() != null) {
            File file = new File(this.getTargetPath());
            dialog.setFilterPath(file.getParent());
            dialog.setFileName(file.getName());
        } else {
            dialog.setFileName(this.getCastedWizard().getSuggestedFileName());
        }
        return dialog;
    }

    protected void setDialogFilters(FileDialog dialog, List<String> filterNames, List<String> filterExtensions) {
        dialog.setFilterNames(filterNames.toArray(new String[filterNames.size()]));
        dialog.setFilterExtensions(filterExtensions.toArray(new String[filterExtensions.size()]));
    }

    protected void updateStatus() {
        this.setPageComplete(this.isPageCompletable());
        String warningMessage = this.generateWarningMessage();
        if (warningMessage != null) {
            this.setMessage(warningMessage, 2);
        } else {
            this.setMessage(null);
        }
        this.setErrorMessage(this.generateErrorMessage());
    }

    protected String generateWarningMessage() {
        if (this.hasTargetPath() && !this.getCastedWizard().isOverwriteWithoutPrompt() && new File(this.getTargetPath()).exists()) {
            return WizardMessages.ExportPage_FileExists_message;
        }
        return null;
    }

    protected String generateErrorMessage() {
        return null;
    }

    protected boolean isPageCompletable() {
        return this.hasTargetPath();
    }

    protected void setTargetPath(String path) {
        this.getCastedWizard().setTargetPath(path);
        if (!this.modifyingPathInput) {
            this.settingTargetPath = true;
            this.pathInput.setText(path);
            this.settingTargetPath = false;
        }
    }

    private class WidgetListener
    implements Listener {
        private WidgetListener() {
        }

        public void handleEvent(Event event) {
            AbstractExportPage.this.handleWidgetEvent(event);
        }
    }
}

