/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.comments;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.actions.ActionFactory;
import org.xmind.gef.ui.editor.IGraphicalEditor;
import org.xmind.ui.internal.MindMapMessages;
import org.xmind.ui.internal.comments.CommentAction;
import org.xmind.ui.internal.comments.CommentsActionBarContributor;
import org.xmind.ui.internal.comments.CommentsPopup;
import org.xmind.ui.internal.comments.ShowNextTopicCommentsAction;
import org.xmind.ui.internal.comments.ShowPreTopicCommentsAction;
import org.xmind.ui.mindmap.MindMapUI;

public class CommentsPopupActionBarContributor
extends CommentsActionBarContributor {
    private CommentsPopup commentsPopup;
    private CommentAction showPreTopicCommentsAction;
    private CommentAction showNextTopicCommentsAction;
    private CommentAction gotoCommentsViewAction;
    private Map<String, TextAction> textActions = new HashMap<String, TextAction>(10);
    private Map<String, IAction> actionHandlers = new HashMap<String, IAction>(10);
    private Collection<String> textCommandIds = new HashSet<String>(10);

    public CommentsPopupActionBarContributor(CommentsPopup commentsPopup, IGraphicalEditor targetEditor) {
        super(targetEditor);
        this.commentsPopup = commentsPopup;
        this.makeActions();
    }

    @Override
    protected void makeActions() {
        if (this.commentsPopup.isShowExtraActions()) {
            this.showPreTopicCommentsAction = new ShowPreTopicCommentsAction(this.targetEditor, this.commentsPopup);
            this.addAction(this.showPreTopicCommentsAction);
            this.showNextTopicCommentsAction = new ShowNextTopicCommentsAction(this.targetEditor, this.commentsPopup);
            this.addAction(this.showNextTopicCommentsAction);
            this.gotoCommentsViewAction = new GotoCommentsPartAction(this.targetEditor);
            this.addAction(this.gotoCommentsViewAction);
        }
        this.addWorkbenchAction(ActionFactory.UNDO, 1);
        this.addWorkbenchAction(ActionFactory.REDO, 2);
        this.addWorkbenchAction(ActionFactory.CUT, 3);
        this.addWorkbenchAction(ActionFactory.COPY, 4);
        this.addWorkbenchAction(ActionFactory.PASTE, 5);
        this.addWorkbenchAction(ActionFactory.SELECT_ALL, 7);
    }

    @Override
    public void fillToolBar(IToolBarManager toolbar) {
        if (this.commentsPopup.isShowExtraActions()) {
            toolbar.add((IAction)this.showPreTopicCommentsAction);
            toolbar.add((IAction)this.showNextTopicCommentsAction);
            toolbar.add((IAction)this.gotoCommentsViewAction);
        }
    }

    private void addWorkbenchAction(ActionFactory factory, int textOp) {
        ActionFactory.IWorkbenchAction action = factory.create(this.commentsPopup.getWorkbenchWindow());
        TextAction textAction = new TextAction(textOp);
        textAction.setId(action.getId());
        textAction.setActionDefinitionId(action.getActionDefinitionId());
        textAction.setText(action.getText());
        textAction.setToolTipText(action.getToolTipText());
        textAction.setDescription(action.getDescription());
        textAction.setImageDescriptor(action.getImageDescriptor());
        textAction.setDisabledImageDescriptor(action.getDisabledImageDescriptor());
        textAction.setHoverImageDescriptor(action.getHoverImageDescriptor());
        action.dispose();
        this.actionHandlers.put(action.getActionDefinitionId(), (IAction)textAction);
        this.textActions.put(textAction.getId(), textAction);
    }

    public IAction getActionHandler(String commandId) {
        return this.actionHandlers.get(commandId);
    }

    @Override
    public void update(TextViewer textViewer) {
        for (TextAction action : this.textActions.values()) {
            action.update(textViewer);
        }
    }

    public IAction getTextAction(String actionId) {
        return (IAction)this.textActions.get(actionId);
    }

    public Collection<String> getTextCommandIds() {
        return this.textCommandIds;
    }

    @Override
    protected IAction getContextAction(String actionId) {
        return this.getTextAction(actionId);
    }

    private class GotoCommentsPartAction
    extends CommentAction {
        public GotoCommentsPartAction(IGraphicalEditor editor) {
            super(editor);
            this.setId("org.xmind.ui.action.gotoCommentsView");
            this.setText(MindMapMessages.EditInCommentsView_text);
            this.setToolTipText(MindMapMessages.EditInCommentsView_tooltip);
            this.setImageDescriptor(MindMapUI.getImages().get("comments-view-edit.png", true));
        }

        @Override
        public void run() {
            this.control = CommentsPopupActionBarContributor.this.commentsPopup.getContentComposite();
            super.run();
            Display.getCurrent().timerExec(50, new Runnable(){

                @Override
                public void run() {
                    Display.getCurrent().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            CommentsPopupActionBarContributor.this.commentsPopup.gotoCommentsView();
                        }
                    });
                }
            });
        }
    }

    private class TextAction
    extends Action {
        private int op;
        private TextViewer textViewer;

        public TextAction(int op) {
            this.op = op;
        }

        public void run() {
            if (this.textViewer != null && this.textViewer.canDoOperation(this.op)) {
                this.textViewer.doOperation(this.op);
                Composite contentComposite = CommentsPopupActionBarContributor.this.commentsPopup.getContentComposite();
                contentComposite.pack();
            }
        }

        public void update(TextViewer textViewer) {
            this.textViewer = textViewer;
            this.setEnabled(textViewer != null && textViewer.canDoOperation(this.op));
        }
    }
}

