# platform_vxworks5.5.x.GNU,v 1.11 2005/02/01 19:43:13 jwillemsen Exp
# VxWorks 5.5.x (x > 0).

#### Notes:
#### 1) This file requires that the WIND_BASE and WIND_HOST_TYPE environment
####    variables be set.  If the target CPU is not a PPC604, then your CPU
####    environment variable must be set.
#### 2) If you have problems with munch output not being compilable
####    because it contains identifiers with ".", e.g., ".cpp", in them:
####    add a global variable or function to that .cpp file.  See
####    ace/IOStream_T.cpp for an explanation and example.
#### 3) The TOOL environment variable may be set to "gnu" (default is "diab").
#### 4) If perl is not on your path, you'll also need to set your PERL_PATH
####    environment variable to the full path to perl.

VXWORKS = 1
CROSS-COMPILE = 1

ifeq ("$(OS)", "Windows_NT")
vxworks_ntbuild = 1
endif

debug ?= 1
optimize ?= 1
rtti ?= 1
threads ?= 1
exceptions ?= 0

shared_libs =
static_libs = 1
versioned_so ?= 0

# VxWorks doesn't have rwho
rwho = 0

ifeq (,$(WIND_BASE))
  default:
	@ERROR: you must set your WIND_BASE environment variable
endif # WIND_BASE

ifeq (,$(WIND_HOST_TYPE))
  default:
	@ERROR: you must set your WIND_HOST_TYPE environment variable
endif # WIND_HOST_TYPE

ifeq ($(DIAB_HOST_TYPE),)
ifeq ("$(OS)", "Windows_NT")
  DIAB_HOST_TYPE = WIN32
else
  DIAB_HOST_TYPE = UNIX
endif
endif

HOST_DIR = $(WIND_BASE)/host/$(WIND_HOST_TYPE)

ifeq (,$(PERL_PATH))
  PERL_PATH = perl
endif # ! PERL_PATH

ifeq ($(VXWORKS_VERSION_FLAG),)
  VXWORKS_VERSION_FLAG = -DACE_VXWORKS=0x551
endif # VXWORKS_VERSION_FLAG

ifeq ($(TOOL),)
  override TOOL = diab
else
  override TOOL := $(TOOL)
endif
override TOOL_FAMILY := $(TOOL)

ifeq ("$(TOOL)","gnu")
  templates ?= automatic
endif

PRJ_TYPE = vxApp
TGT_DIR = $(WIND_BASE)/target

ifeq ($(CPU),)
  # default CPU
  CPU = SIMNT
else
  override CPU := $(CPU)
endif

ifeq ($(shared_libs),1)
  SHARED_LIBS = 1
endif
ifeq ($(shared_libs_only),1)
  SHARED_LIBS = 1
endif

ifeq ($(SHARED_LIBS),1)
  ACELIB = -L./
  #### There's no difference between non-shared and shared object code.
  VSHDIR = $(VDIR)
endif # shared_libs

BIN_UNCHECKED ?=

ifneq ("$(BIN_UNCHECKED)","")
  ## set variables for VxWorks linktarget identification
  PRJ_FILE = $(basename $(notdir $(BIN_UNCHECKED))).vxworks
  EXEEXT = .out
  PRJ_DIR = .
  VXWORKSLINK = true
  GENERATED_DIRTY += $(PRJ_DIR)/$(PRJ_FILE)
endif

include $(TGT_DIR)/h/make/defs.default
##include $(TGT_DIR)/h/make/defs.link
include $(TGT_DIR)/h/make/defs.$(WIND_HOST_TYPE)
include $(TGT_DIR)/h/make/defs.$(PRJ_TYPE)
include $(TGT_DIR)/h/tool/$(TOOL_FAMILY)/make.$(CPU)$(TOOL)

ifeq ("$(VXWORKSLINK)","true")
  override LARGE_PROJECT =
  PRJ_OBJS = $(addprefix $(VDIR), $(OBJS))
  LD_PARTIAL += -L$(ACE_ROOT)/ace -L./ $(LDLIBPATH) $(LD_LINK_PATH)
  PRJ_OBJS_FOR_LD_PARTIAL=$(addprefix $(VDIR), $(OBJS)) $(VLDLIBS)
  PRJ_OBJS_FOR_LD=$(addprefix $(VDIR), $(OBJS))
  PRJ_OBJS_FOR_NM=$(addprefix $(VDIR), $(OBJS))
  PRJ_OBJS_FOR_AR=$(addprefix $(VDIR), $(OBJS))
  POST_BUILD_RULE = $(POSTLINK)
  COMPILE_TRADITIONAL = $(CC) $(OPTION_OBJECT_ONLY) $(OPTION_DOLLAR_SYMBOLS)\
			  $(filter-out -ansi, $(CFLAGS))

  ## make sure default target stays the ACE/TAO default target
  ##
default: all

  ## dummy target to satify VxWorks dependencies
$(PRJ_DIR)/$(PRJ_FILE):
	@echo 1>$@
endif

ifneq ($(static_libs),1)
  AR             := echo
  ARFLAGS        := "build static lib only"
endif # ! static_libs

CPPFLAGS += $(VXWORKS_VERSION_FLAG)

ifeq ($(debug),1)
  DCFLAGS += -g
  DCCFLAGS += -g
  CPPFLAGS +=
endif

ifeq ("$(TOOL)","gnu")
# Test for template instantiation, add to SOFLAGS if SONAME set,
# add -E to LDFLAGS if using GNU ld
include $(ACE_ROOT)/include/makeinclude/platform_g++_common.GNU

ifeq ("$(templates)","automatic")
  C++FLAGS += -fmerge-templates
endif

# TEMPLATES_FLAG is set by platform_g++_common.GNU
ifneq ($(TEMPLATES_FLAG),) # If specified, add it to the CCFLAGS
  CPPFLAGS += $(TEMPLATES_FLAG)
endif
endif  # TOOL == gnu

ifeq ("$(TOOL)","diab")
ifeq ($(exceptions),1)
  C++FLAGS += -Xexceptions
else
  C++FLAGS += -Xexceptions-off
endif
else
ifeq ("$(TOOL)","gnu")
ifeq ($(exceptions),1)
  C++FLAGS += -fexceptions
else
  C++FLAGS += -fno-exceptions
endif
endif
endif

ifeq (0,$(rtti))
C++FLAGS += -DACE_LACKS_RTTI
ifeq ("$(TOOL)","gnu")
  C++FLAGS += -fno-rtti
else
  C++FLAGS += -Xrtti-off
endif
endif # rtti

ifneq ($(findstring $(VX_CPU_FAMILY),ppc arm),)
ifeq ("$(TOOL)","diab")
  C++FLAGS += -Xchar-signed
else
ifeq ("$(TOOL)","gnu")
  C++FLAGS += -fsigned-char
endif
endif
endif

ifneq ($(optimize),1)
  CC_OPTIM_NORMAL =
endif

CCFLAGS         += $(C++FLAGS)

PIC              =
