/* Module:          SQLSetStmtOption.c
 *
 * Description:     Has been replaced by SQLSetStmtAttr. 
 *
 * Classes:         
 *
 * API functions:   SQLSetStmtOption
 *
 * Comments:        See "notice.txt" for copyright and license information.
 *
 */

#include "driver.h"

RETCODE set_statement_option(ConnectionClass *conn, 
							 StatementClass *stmt, 
							 UWORD   fOption,
							 UDWORD  vParam);


SQLRETURN SQL_API SQLSetStmtOption(
        SQLHSTMT   hDrvStmt,
        SQLUSMALLINT   fOption,
        SQLUINTEGER  vParam)
{
	static char *func="SQLSetStmtOption";
	StatementClass *stmt = (StatementClass *) hDrvStmt;

	mylog("%s: entering...\n", func);

	/* thought we could fake Access out by just returning SQL_SUCCESS */
	/* all the time, but it tries to set a huge value for SQL_MAX_LENGTH */
	/* and expects the driver to reduce it to the real value */

	if( ! stmt)
	{
		SC_log_error(func, "", NULL);
		return SQL_INVALID_HANDLE;
	}

	return set_statement_option(NULL, stmt, fOption, vParam);
}

