/* Module:          SQLAllocStmt.c
 *
 * Description:     Has been replaced by SQLAllocHandle.
 *
 * Classes:         
 *
 * API functions:   SQLAllocStmt
 *
 * Comments:        See "notice.txt" for copyright and license information.
 *
 */

#include "driver.h"

SQLRETURN SQL_API SQLAllocStmt(
							   SQLHDBC		hDrvDbc,
							   SQLHSTMT		*phDrvStmt
							   )
{
	static char *func="SQLAllocStmt";
	ConnectionClass *conn = (ConnectionClass *) hDrvDbc;
	StatementClass *stmt;

	mylog("%s: entering...\n", func);

	if( ! conn)
	{
		CC_log_error(func, "", NULL);
		return SQL_INVALID_HANDLE;
	}

	stmt = SC_Constructor();

	mylog("**** SQLAllocStmt: hDrvDbc = %u, stmt = %u\n", hDrvDbc, stmt);

	if ( ! stmt)
	{
		conn->errornumber = CONN_STMT_ALLOC_ERROR;
		conn->errormsg = "No more memory to allocate a further SQL-statement";
		*phDrvStmt = SQL_NULL_HSTMT;
		CC_log_error(func, "", conn);
		return SQL_ERROR;
	}

    if ( ! CC_add_statement(conn, stmt))
	{
	conn->errormsg = "Maximum number of connections exceeded.";
	conn->errornumber = CONN_STMT_ALLOC_ERROR;
		CC_log_error(func, "", conn);
	SC_Destructor(stmt);
		*phDrvStmt = SQL_NULL_HSTMT;
	return SQL_ERROR;
    }

	*phDrvStmt = (HSTMT) stmt;

	/*	Copy default statement options based from Connection options
	*/
	stmt->options = conn->stmtOptions;


	/*	Save the handle for later */
	stmt->phstmt = phDrvStmt;

    return SQL_SUCCESS;
}
