/*
 * Decompiled with CFR 0.152.
 */
package freemind.controller;

import freemind.controller.Controller;
import freemind.main.Tools;
import freemind.modes.MindMap;
import freemind.modes.Mode;
import freemind.modes.ModeController;
import freemind.view.MapModule;
import freemind.view.mindmapview.MapView;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Vector;

public class MapModuleManager {
    MapModuleChangeObserverCompound listener = new MapModuleChangeObserverCompound();
    private Vector mapModuleVector = new Vector();
    private MapModule mapModule;
    private Mode mCurrentMode = null;
    private Controller mController;

    public void addListener(MapModuleChangeObserver pListener) {
        this.listener.addListener(pListener);
    }

    public void removeListener(MapModuleChangeObserver pListener) {
        this.listener.removeListener(pListener);
    }

    MapModuleManager(Controller c) {
        this.mController = c;
    }

    public Map getMapModules() {
        HashMap<String, MapModule> returnValue = new HashMap<String, MapModule>();
        Iterator iterator = this.mapModuleVector.iterator();
        while (iterator.hasNext()) {
            MapModule module = (MapModule)iterator.next();
            returnValue.put(module.getDisplayName(), module);
        }
        return Collections.unmodifiableMap(returnValue);
    }

    public List getMapModuleVector() {
        return Collections.unmodifiableList(this.mapModuleVector);
    }

    public List getMapKeys() {
        LinkedList<String> returnValue = new LinkedList<String>();
        Iterator iterator = this.mapModuleVector.iterator();
        while (iterator.hasNext()) {
            MapModule module = (MapModule)iterator.next();
            returnValue.add(module.getDisplayName());
        }
        return Collections.unmodifiableList(returnValue);
    }

    public MapModule getMapModule() {
        return this.mapModule;
    }

    public void newMapModule(MindMap map, ModeController modeController) {
        MapModule mapModule = new MapModule(map, new MapView(map, this.mController), modeController.getMode(), modeController);
        this.addToOrChangeInMapModules(mapModule.toString(), mapModule);
        this.setMapModule(mapModule, modeController.getMode());
    }

    public void updateMapModuleName() {
        this.getMapModule().rename();
        this.addToOrChangeInMapModules(this.getMapModule().toString(), this.getMapModule());
        this.setMapModule(this.getMapModule(), this.getMapModule().getMode());
    }

    void nextMapModule() {
        int size = this.mapModuleVector.size();
        int index = this.getMapModule() != null ? this.mapModuleVector.indexOf(this.getMapModule()) : size - 1;
        if (index + 1 < size && index >= 0) {
            this.changeToMapModule((MapModule)this.mapModuleVector.get(index + 1));
        } else if (size > 0) {
            this.changeToMapModule((MapModule)this.mapModuleVector.get(0));
        }
    }

    void previousMapModule() {
        int size = this.mapModuleVector.size();
        int index = this.getMapModule() != null ? this.mapModuleVector.indexOf(this.getMapModule()) : 0;
        if (index > 0) {
            this.changeToMapModule((MapModule)this.mapModuleVector.get(index - 1));
        } else if (size > 0) {
            this.changeToMapModule((MapModule)this.mapModuleVector.get(size - 1));
        }
    }

    public boolean tryToChangeToMapModule(String mapModule) {
        if (mapModule != null && this.getMapKeys().contains(mapModule)) {
            this.changeToMapModule(mapModule);
            return true;
        }
        return false;
    }

    public String checkIfFileIsAlreadyOpened(URL urlToCheck) throws MalformedURLException {
        Iterator iter = this.mapModuleVector.iterator();
        while (iter.hasNext()) {
            URL moduleUrl;
            MapModule module = (MapModule)iter.next();
            if (module.getModel() == null || !this.sameFile(urlToCheck, moduleUrl = module.getModel().getURL())) continue;
            return module.getDisplayName();
        }
        return null;
    }

    private boolean sameFile(URL urlToCheck, URL moduleUrl) {
        if (moduleUrl == null) {
            return false;
        }
        if (urlToCheck.getProtocol().equals("file") && moduleUrl.getProtocol().equals("file")) {
            return new File(urlToCheck.getFile()).equals(new File(moduleUrl.getFile()));
        }
        return urlToCheck.sameFile(moduleUrl);
    }

    public boolean changeToMapModule(String mapModuleDisplayName) {
        MapModule mapModuleCandidate = null;
        Iterator iterator = this.mapModuleVector.iterator();
        while (iterator.hasNext()) {
            MapModule mapMod = (MapModule)iterator.next();
            if (!Tools.safeEquals(mapModuleDisplayName, mapMod.getDisplayName())) continue;
            mapModuleCandidate = mapMod;
            break;
        }
        if (mapModuleCandidate == null) {
            throw new IllegalArgumentException("Map module " + mapModuleDisplayName + " not found.");
        }
        return this.changeToMapModule(mapModuleCandidate);
    }

    private boolean changeToMapModule(MapModule mapModuleCandidate) {
        return this.setMapModule(mapModuleCandidate, mapModuleCandidate.getMode());
    }

    public void changeToMapOfMode(Mode mode) {
        Iterator iterator = this.mapModuleVector.iterator();
        while (iterator.hasNext()) {
            MapModule mapMod = (MapModule)iterator.next();
            if (mapMod.getMode() != mode) continue;
            this.changeToMapModule(mapMod);
            return;
        }
        this.setMapModule(null, mode);
    }

    boolean setMapModule(MapModule newMapModule, Mode newMode) {
        MapModule oldMapModule = this.mapModule;
        Mode oldMode = this.mCurrentMode;
        if (!this.listener.isMapModuleChangeAllowed(oldMapModule, oldMode, newMapModule, newMode)) {
            return false;
        }
        this.listener.beforeMapModuleChange(oldMapModule, oldMode, newMapModule, newMode);
        this.mapModule = newMapModule;
        this.mCurrentMode = newMode;
        this.listener.afterMapModuleChange(oldMapModule, oldMode, newMapModule, newMode);
        this.listener.numberOfOpenMapInformation(this.mapModuleVector.size());
        return true;
    }

    private void addToOrChangeInMapModules(String key, MapModule newOrChangedMapModule) {
        String extension = "";
        int count = 1;
        List mapKeys = this.getMapKeys();
        while (mapKeys.contains(key + extension)) {
            extension = "<" + ++count + ">";
        }
        newOrChangedMapModule.setName(key + extension);
        newOrChangedMapModule.setDisplayName(key + extension);
        if (!this.mapModuleVector.contains(newOrChangedMapModule)) {
            this.mapModuleVector.add(newOrChangedMapModule);
        }
    }

    public boolean close(boolean force) {
        MapModule module = this.getMapModule();
        boolean closingNotCancelled = module.getModeController().close(force, this);
        if (!closingNotCancelled) {
            return false;
        }
        int index = this.mapModuleVector.indexOf(module);
        this.mapModuleVector.remove(module);
        if (this.mapModuleVector.isEmpty()) {
            this.setMapModule(null, module.getMode());
        } else {
            if (index >= this.mapModuleVector.size() || index < 0) {
                index = this.mapModuleVector.size() - 1;
            }
            this.changeToMapModule((MapModule)this.mapModuleVector.get(index));
        }
        this.listener.afterMapClose(module, module.getMode());
        return true;
    }

    public static interface MapTitleChangeListener {
        public void setMapTitle(String var1, MapModule var2, MindMap var3);
    }

    public static class MapModuleChangeObserverCompound
    implements MapModuleChangeObserver {
        private HashSet listeners = new HashSet();

        public void addListener(MapModuleChangeObserver listener) {
            this.listeners.add(listener);
        }

        public void removeListener(MapModuleChangeObserver listener) {
            this.listeners.remove(listener);
        }

        public boolean isMapModuleChangeAllowed(MapModule oldMapModule, Mode oldMode, MapModule newMapModule, Mode newMode) {
            MapModuleChangeObserver observer;
            boolean returnValue = true;
            Iterator iter = new Vector(this.listeners).iterator();
            while (iter.hasNext() && (returnValue = (observer = (MapModuleChangeObserver)iter.next()).isMapModuleChangeAllowed(oldMapModule, oldMode, newMapModule, newMode))) {
            }
            return returnValue;
        }

        public void beforeMapModuleChange(MapModule oldMapModule, Mode oldMode, MapModule newMapModule, Mode newMode) {
            Iterator iter = new Vector(this.listeners).iterator();
            while (iter.hasNext()) {
                MapModuleChangeObserver observer = (MapModuleChangeObserver)iter.next();
                observer.beforeMapModuleChange(oldMapModule, oldMode, newMapModule, newMode);
            }
        }

        public void afterMapModuleChange(MapModule oldMapModule, Mode oldMode, MapModule newMapModule, Mode newMode) {
            Iterator iter = new Vector(this.listeners).iterator();
            while (iter.hasNext()) {
                MapModuleChangeObserver observer = (MapModuleChangeObserver)iter.next();
                observer.afterMapModuleChange(oldMapModule, oldMode, newMapModule, newMode);
            }
        }

        public void numberOfOpenMapInformation(int number) {
            Iterator iter = new Vector(this.listeners).iterator();
            while (iter.hasNext()) {
                MapModuleChangeObserver observer = (MapModuleChangeObserver)iter.next();
                observer.numberOfOpenMapInformation(number);
            }
        }

        public void afterMapClose(MapModule pOldMapModule, Mode pOldMode) {
            Iterator iter = new Vector(this.listeners).iterator();
            while (iter.hasNext()) {
                MapModuleChangeObserver observer = (MapModuleChangeObserver)iter.next();
                observer.afterMapClose(pOldMapModule, pOldMode);
            }
        }
    }

    public static interface MapModuleChangeObserver {
        public boolean isMapModuleChangeAllowed(MapModule var1, Mode var2, MapModule var3, Mode var4);

        public void beforeMapModuleChange(MapModule var1, Mode var2, MapModule var3, Mode var4);

        public void afterMapClose(MapModule var1, Mode var2);

        public void afterMapModuleChange(MapModule var1, Mode var2, MapModule var3, Mode var4);

        public void numberOfOpenMapInformation(int var1);
    }
}

