/*
 * Decompiled with CFR 0.152.
 */
package freemind.modes.mindmapmode.attributeactors;

import freemind.controller.filter.util.SortedComboBoxModel;
import freemind.modes.MindMapNode;
import freemind.modes.attributes.Attribute;
import freemind.modes.attributes.AttributeController;
import freemind.modes.attributes.AttributeRegistry;
import freemind.modes.attributes.AttributeRegistryElement;
import freemind.modes.attributes.NodeAttributeTableModel;
import freemind.modes.mindmapmode.MindMapController;
import freemind.modes.mindmapmode.MindMapNodeModel;
import freemind.modes.mindmapmode.actions.xml.ActionPair;
import freemind.modes.mindmapmode.attributeactors.InsertAttributeActor;
import freemind.modes.mindmapmode.attributeactors.RegistryAttributeActor;
import freemind.modes.mindmapmode.attributeactors.RegistryAttributeValueActor;
import freemind.modes.mindmapmode.attributeactors.RemoveAttributeActor;
import freemind.modes.mindmapmode.attributeactors.ReplaceAttributeValueActor;
import freemind.modes.mindmapmode.attributeactors.SetAttributeColumnWidthActor;
import freemind.modes.mindmapmode.attributeactors.SetAttributeFontSizeActor;
import freemind.modes.mindmapmode.attributeactors.SetAttributeNameActor;
import freemind.modes.mindmapmode.attributeactors.SetAttributeRestrictedActor;
import freemind.modes.mindmapmode.attributeactors.SetAttributeValueActor;
import freemind.modes.mindmapmode.attributeactors.SetAttributeVisibleActor;
import freemind.modes.mindmapmode.attributeactors.UnregistryAttributeActor;
import freemind.modes.mindmapmode.attributeactors.UnregistryAttributeValueActor;
import java.util.ListIterator;
import java.util.NoSuchElementException;

public class MindMapModeAttributeController
implements AttributeController {
    SetAttributeNameActor setAttributeNameActor;
    SetAttributeValueActor setAttributeValueActor;
    RemoveAttributeActor removeAttributeActor;
    InsertAttributeActor insertAttributeActor;
    SetAttributeColumnWidthActor setAttributeColumnWidthActor;
    RegistryAttributeActor registryAttributeActor;
    UnregistryAttributeActor unregistryAttributeActor;
    RegistryAttributeValueActor registryAttributeValueActor;
    UnregistryAttributeValueActor unregistryAttributeValueActor;
    ReplaceAttributeValueActor replaceAttributeValueActor;
    SetAttributeFontSizeActor setAttributeFontSizeActor;
    SetAttributeVisibleActor setAttributeVisibleActor;
    SetAttributeRestrictedActor setAttributeRestrictedActor;
    private MindMapController controller;

    public MindMapModeAttributeController(MindMapController controller) {
        this.controller = controller;
        this.setAttributeNameActor = new SetAttributeNameActor(controller);
        this.setAttributeValueActor = new SetAttributeValueActor(controller);
        this.removeAttributeActor = new RemoveAttributeActor(controller);
        this.insertAttributeActor = new InsertAttributeActor(controller);
        this.setAttributeColumnWidthActor = new SetAttributeColumnWidthActor(controller);
        this.registryAttributeActor = new RegistryAttributeActor(controller);
        this.unregistryAttributeActor = new UnregistryAttributeActor(controller);
        this.registryAttributeValueActor = new RegistryAttributeValueActor(controller);
        this.replaceAttributeValueActor = new ReplaceAttributeValueActor(controller);
        this.unregistryAttributeValueActor = new UnregistryAttributeValueActor(controller);
        this.setAttributeFontSizeActor = new SetAttributeFontSizeActor(controller);
        this.setAttributeVisibleActor = new SetAttributeVisibleActor(controller);
        this.setAttributeRestrictedActor = new SetAttributeRestrictedActor(controller);
    }

    public void performSetValueAt(NodeAttributeTableModel model, Object o, int row, int col) {
        this.startTransaction("performSetValueAt");
        Attribute attribute = model.getAttribute(row);
        AttributeRegistry attributes = this.getAttributeRegistry();
        switch (col) {
            case 0: {
                String name = o.toString().trim();
                if (attribute.getName().equals(name)) {
                    return;
                }
                ActionPair setAttributeNameActionPair = this.setAttributeNameActor.createActionPair(model, row, name);
                this.controller.getActionFactory().executeAction(setAttributeNameActionPair);
                try {
                    AttributeRegistryElement element = attributes.getElement((Comparable)((Object)name));
                    String value = model.getValueAt(row, 1).toString();
                    int index = element.getValues().getIndexOf(value);
                    if (index != -1) break;
                    ActionPair setAttributeValueActionPair = this.setAttributeValueActor.createActionPair(model, row, element.getValues().firstElement().toString());
                    this.controller.getActionFactory().executeAction(setAttributeValueActionPair);
                }
                catch (NoSuchElementException ex) {
                    ActionPair registryAttributeActionPair = this.registryAttributeActor.createActionPair(name);
                    this.controller.getActionFactory().executeAction(registryAttributeActionPair);
                    ActionPair setAttributeValueActionPair = this.setAttributeValueActor.createActionPair(model, row, "");
                    this.controller.getActionFactory().executeAction(setAttributeValueActionPair);
                }
                break;
            }
            case 1: {
                String value = o.toString().trim();
                if (attribute.getValue().equals(value)) {
                    return;
                }
                ActionPair setValueActionPair = this.setAttributeValueActor.createActionPair(model, row, value);
                this.controller.getActionFactory().executeAction(setValueActionPair);
                String name = model.getValueAt(row, 0).toString();
                AttributeRegistryElement element = attributes.getElement((Comparable)((Object)name));
                int index = element.getValues().getIndexOf(value);
                if (index != -1) break;
                ActionPair registryAttributeValueActionPair = this.registryAttributeValueActor.createActionPair(name, value);
                this.controller.getActionFactory().executeAction(registryAttributeValueActionPair);
                break;
            }
        }
        this.endTransaction("performSetValueAt");
    }

    private void endTransaction(String name) {
        this.controller.getActionFactory().endTransaction(this.getClass().getName() + "." + name);
    }

    private void startTransaction(String name) {
        this.controller.getActionFactory().startTransaction(this.getClass().getName() + "." + name);
    }

    public void performInsertRow(NodeAttributeTableModel model, int row, String name, String value) {
        this.startTransaction("performInsertRow");
        AttributeRegistry attributes = this.getAttributeRegistry();
        if (name.equals("")) {
            return;
        }
        try {
            AttributeRegistryElement element = attributes.getElement((Comparable)((Object)name));
            int index = element.getValues().getIndexOf(value);
            if (index == -1) {
                if (element.isRestricted()) {
                    value = element.getValues().firstElement().toString();
                } else {
                    ActionPair registryNewAttributeActionPair = this.registryAttributeValueActor.createActionPair(name, value);
                    this.controller.getActionFactory().executeAction(registryNewAttributeActionPair);
                }
            }
        }
        catch (NoSuchElementException ex) {
            ActionPair registryAttributeActionPair = this.registryAttributeActor.createActionPair(name);
            this.controller.getActionFactory().executeAction(registryAttributeActionPair);
            ActionPair registryAttributeValueActionPair = this.registryAttributeValueActor.createActionPair(name, value);
            this.controller.getActionFactory().executeAction(registryAttributeValueActionPair);
        }
        ActionPair insertAttributeActionPair = this.insertAttributeActor.createActionPair(model, row, name, value);
        this.controller.getActionFactory().executeAction(insertAttributeActionPair);
        this.endTransaction("performInsertRow");
    }

    public void performRemoveRow(NodeAttributeTableModel model, int row) {
        this.startTransaction("performRemoveRow");
        ActionPair removeAttributeActionPair = this.removeAttributeActor.createActionPair(model, row);
        this.controller.getActionFactory().executeAction(removeAttributeActionPair);
        this.endTransaction("performRemoveRow");
    }

    public void performSetColumnWidth(NodeAttributeTableModel model, int col, int width) {
        if (width == model.getLayout().getColumnWidth(col)) {
            return;
        }
        this.startTransaction("performSetColumnWidth");
        ActionPair setAttributeColumnWidthActionPair = this.setAttributeColumnWidthActor.createActionPair(model, col, width);
        this.controller.getActionFactory().executeAction(setAttributeColumnWidthActionPair);
        this.endTransaction("performSetColumnWidth");
    }

    public void performRemoveAttributeValue(String name, String value) {
        this.startTransaction("performRemoveAttributeValue");
        ActionPair removeAttributeActionPair = this.unregistryAttributeValueActor.createActionPair(name, value);
        this.controller.getActionFactory().executeAction(removeAttributeActionPair);
        AttributeValueRemover remover = new AttributeValueRemover(name, value);
        Iterator iterator = new Iterator(remover);
        MindMapNode root = this.controller.getRootNode();
        iterator.iterate(root);
        this.endTransaction("performRemoveAttributeValue");
    }

    public void performReplaceAttributeValue(String name, String oldValue, String newValue) {
        this.startTransaction("performReplaceAttributeValue");
        ActionPair replaceAttributeActionPair = this.replaceAttributeValueActor.createActionPair(name, oldValue, newValue);
        this.controller.getActionFactory().executeAction(replaceAttributeActionPair);
        AttributeChanger replacer = new AttributeChanger(name, oldValue, newValue);
        Iterator iterator = new Iterator(replacer);
        MindMapNode root = this.controller.getRootNode();
        iterator.iterate(root);
        this.endTransaction("performReplaceAttributeValue");
    }

    public void performSetFontSize(AttributeRegistry registry, int size) {
        if (size == registry.getFontSize()) {
            return;
        }
        this.startTransaction("performSetFontSize");
        ActionPair setFontSizeActionPair = this.setAttributeFontSizeActor.createActionPair(size);
        this.controller.getActionFactory().executeAction(setFontSizeActionPair);
        this.endTransaction("performSetFontSize");
    }

    public void performSetVisibility(int index, boolean isVisible) {
        if (this.getAttributeRegistry().getElement(index).isVisible() == isVisible) {
            return;
        }
        this.startTransaction("performSetVisibility");
        ActionPair setVisibilityActionPair = this.setAttributeVisibleActor.createActionPair(index, isVisible);
        this.controller.getActionFactory().executeAction(setVisibilityActionPair);
        this.endTransaction("performSetVisibility");
    }

    public void performSetRestriction(int index, boolean isRestricted) {
        boolean currentValue = index == -1 ? this.getAttributeRegistry().isRestricted() : this.getAttributeRegistry().getElement(index).isRestricted();
        if (currentValue == isRestricted) {
            return;
        }
        this.startTransaction("performSetRestriction");
        ActionPair setRestrictionActionPair = this.setAttributeRestrictedActor.createActionPair(index, isRestricted);
        this.controller.getActionFactory().executeAction(setRestrictionActionPair);
        this.endTransaction("performSetRestriction");
    }

    public void performReplaceAtributeName(String oldName, String newName) {
        if (oldName.equals("") || newName.equals("") || oldName.equals(newName)) {
            return;
        }
        this.startTransaction("performReplaceAtributeName");
        AttributeRegistry registry = this.getAttributeRegistry();
        int iOld = registry.getElements().indexOf((Comparable)((Object)oldName));
        AttributeRegistryElement oldElement = registry.getElement(iOld);
        SortedComboBoxModel values = oldElement.getValues();
        ActionPair registryNewAttributeActionPair = this.registryAttributeActor.createActionPair(newName);
        this.controller.getActionFactory().executeAction(registryNewAttributeActionPair);
        for (int i = 0; i < values.getSize(); ++i) {
            ActionPair registryNewAttributeValueActionPair = this.registryAttributeValueActor.createActionPair(newName, values.getElementAt(i).toString());
            this.controller.getActionFactory().executeAction(registryNewAttributeValueActionPair);
        }
        AttributeRenamer replacer = new AttributeRenamer(oldName, newName);
        Iterator iterator = new Iterator(replacer);
        MindMapNode root = this.controller.getRootNode();
        iterator.iterate(root);
        ActionPair unregistryOldAttributeActionPair = this.unregistryAttributeActor.createActionPair(oldName);
        this.controller.getActionFactory().executeAction(unregistryOldAttributeActionPair);
        this.endTransaction("performReplaceAtributeName");
    }

    public void performRemoveAttribute(String name) {
        this.startTransaction("performReplaceAtributeName");
        ActionPair unregistryOldAttributeActionPair = this.unregistryAttributeActor.createActionPair(name);
        this.controller.getActionFactory().executeAction(unregistryOldAttributeActionPair);
        AttributeRemover remover = new AttributeRemover(name);
        Iterator iterator = new Iterator(remover);
        MindMapNode root = this.controller.getRootNode();
        iterator.iterate(root);
        this.endTransaction("performReplaceAtributeName");
    }

    public void performRegistryAttribute(String name) {
        if (name.equals("")) {
            return;
        }
        try {
            AttributeRegistryElement element = this.getAttributeRegistry().getElement((Comparable)((Object)name));
        }
        catch (NoSuchElementException ex) {
            this.startTransaction("performRegistryAttribute");
            ActionPair registryNewAttributeActionPair = this.registryAttributeActor.createActionPair(name);
            this.controller.getActionFactory().executeAction(registryNewAttributeActionPair);
            this.endTransaction("performRegistryAttribute");
            return;
        }
    }

    public void performRegistryAttributeValue(String name, String value) {
        if (name.equals("")) {
            return;
        }
        try {
            AttributeRegistryElement element = this.getAttributeRegistry().getElement((Comparable)((Object)name));
            if (element.getValues().contains(value)) {
                return;
            }
            this.startTransaction("performRegistryAttributeValue");
            ActionPair registryNewAttributeActionPair = this.registryAttributeValueActor.createActionPair(name, value);
            this.controller.getActionFactory().executeAction(registryNewAttributeActionPair);
            this.endTransaction("performRegistryAttributeValue");
            return;
        }
        catch (NoSuchElementException ex) {
            this.startTransaction("performRegistryAttributeValue");
            ActionPair registryAttributeActionPair = this.registryAttributeActor.createActionPair(name);
            this.controller.getActionFactory().executeAction(registryAttributeActionPair);
            ActionPair registryAttributeValueActionPair = this.registryAttributeValueActor.createActionPair(name, value);
            this.controller.getActionFactory().executeAction(registryAttributeValueActionPair);
            this.endTransaction("performRegistryAttributeValue");
            return;
        }
    }

    private AttributeRegistry getAttributeRegistry() {
        return this.controller.getMap().getRegistry().getAttributes();
    }

    public void performRegistrySubtreeAttributes(MindMapNodeModel node) {
        for (int i = 0; i < node.getAttributes().getRowCount(); ++i) {
            String name = node.getAttributes().getValueAt(i, 0).toString();
            String value = node.getAttributes().getValueAt(i, 1).toString();
            this.performRegistryAttributeValue(name, value);
        }
        ListIterator e = node.childrenUnfolded();
        while (e.hasNext()) {
            MindMapNodeModel child = (MindMapNodeModel)e.next();
            this.performRegistrySubtreeAttributes(child);
        }
    }

    private static class Iterator {
        private Visitor visitor;

        Iterator(Visitor v) {
            this.visitor = v;
        }

        void iterate(MindMapNode node) {
            this.visitor.visit(node.getAttributes());
            ListIterator iterator = node.childrenUnfolded();
            while (iterator.hasNext()) {
                MindMapNode child = (MindMapNode)iterator.next();
                this.iterate(child);
            }
        }
    }

    private class AttributeValueRemover
    implements Visitor {
        private Object name;
        private Object value;

        public AttributeValueRemover(Object name, Object value) {
            this.name = name;
            this.value = value;
        }

        public void visit(NodeAttributeTableModel model) {
            for (int i = 0; i < model.getRowCount(); ++i) {
                if (!model.getName(i).equals(this.name) || !model.getValue(i).equals(this.value)) continue;
                ActionPair removeAttributeActionPair = MindMapModeAttributeController.this.removeAttributeActor.createActionPair(model, i);
                MindMapModeAttributeController.this.controller.getActionFactory().executeAction(removeAttributeActionPair);
            }
        }
    }

    private class AttributeRemover
    implements Visitor {
        private Object name;

        public AttributeRemover(Object name) {
            this.name = name;
        }

        public void visit(NodeAttributeTableModel model) {
            for (int i = 0; i < model.getRowCount(); ++i) {
                if (!model.getName(i).equals(this.name)) continue;
                ActionPair removeAttributeActionPair = MindMapModeAttributeController.this.removeAttributeActor.createActionPair(model, i);
                MindMapModeAttributeController.this.controller.getActionFactory().executeAction(removeAttributeActionPair);
            }
        }
    }

    private class AttributeChanger
    implements Visitor {
        private Object name;
        private Object oldValue;
        private Object newValue;

        public AttributeChanger(Object name, Object oldValue, Object newValue) {
            this.name = name;
            this.oldValue = oldValue;
            this.newValue = newValue;
        }

        public void visit(NodeAttributeTableModel model) {
            for (int i = 0; i < model.getRowCount(); ++i) {
                if (!model.getName(i).equals(this.name) || !model.getValue(i).equals(this.oldValue)) continue;
                ActionPair setAttributeValueActionPair = MindMapModeAttributeController.this.setAttributeValueActor.createActionPair(model, i, this.newValue.toString());
                MindMapModeAttributeController.this.controller.getActionFactory().executeAction(setAttributeValueActionPair);
            }
        }
    }

    private class AttributeRenamer
    implements Visitor {
        private Object oldName;
        private Object newName;

        public AttributeRenamer(Object oldName, Object newName) {
            this.newName = newName;
            this.oldName = oldName;
        }

        public void visit(NodeAttributeTableModel model) {
            for (int i = 0; i < model.getRowCount(); ++i) {
                if (!model.getName(i).equals(this.oldName)) continue;
                ActionPair setAttributeNameActionPair = MindMapModeAttributeController.this.setAttributeNameActor.createActionPair(model, i, this.newName.toString());
                MindMapModeAttributeController.this.controller.getActionFactory().executeAction(setAttributeNameActionPair);
            }
        }
    }

    private static interface Visitor {
        public void visit(NodeAttributeTableModel var1);
    }
}

