/*
 * Decompiled with CFR 0.152.
 */
package freemind.modes.mindmapmode.actions;

import freemind.controller.MenuItemSelectedListener;
import freemind.controller.actions.generated.instance.ItalicNodeAction;
import freemind.controller.actions.generated.instance.XmlAction;
import freemind.modes.MindMap;
import freemind.modes.MindMapNode;
import freemind.modes.NodeAdapter;
import freemind.modes.mindmapmode.MindMapController;
import freemind.modes.mindmapmode.actions.NodeActorXml;
import freemind.modes.mindmapmode.actions.NodeGeneralAction;
import freemind.modes.mindmapmode.actions.xml.ActionPair;
import javax.swing.Action;
import javax.swing.JMenuItem;

public class ItalicAction
extends NodeGeneralAction
implements NodeActorXml,
MenuItemSelectedListener {
    private final MindMapController modeController;

    public ItalicAction(MindMapController modeController) {
        super(modeController, "italic", "images/Italic16.gif");
        this.modeController = modeController;
        this.addActor(this);
    }

    public void act(XmlAction action) {
        ItalicNodeAction italicact = (ItalicNodeAction)action;
        NodeAdapter node = this.getNodeFromID(italicact.getNode());
        if (node.isItalic() != italicact.getItalic()) {
            node.setItalic(italicact.getItalic());
            this.modeController.nodeChanged(node);
        }
    }

    public Class getDoActionClass() {
        return ItalicNodeAction.class;
    }

    public ActionPair apply(MindMap model, MindMapNode selected) {
        boolean italic = this.modeController.getSelected().isItalic();
        return this.getActionPair(selected, !italic);
    }

    private ActionPair getActionPair(MindMapNode selected, boolean italic) {
        ItalicNodeAction italicAction = this.toggleItalic(selected, italic);
        ItalicNodeAction undoItalicAction = this.toggleItalic(selected, selected.isItalic());
        return new ActionPair((XmlAction)italicAction, (XmlAction)undoItalicAction);
    }

    private ItalicNodeAction toggleItalic(MindMapNode selected, boolean italic) {
        ItalicNodeAction italicAction = new ItalicNodeAction();
        italicAction.setNode(this.getNodeID(selected));
        italicAction.setItalic(italic);
        return italicAction;
    }

    public void setItalic(MindMapNode node, boolean italic) {
        this.execute(this.getActionPair(node, italic));
    }

    public boolean isSelected(JMenuItem item, Action action) {
        return this.modeController.getSelected().isItalic();
    }
}

