/*
 * Decompiled with CFR 0.152.
 */
package freemind.modes.mindmapmode.actions;

import freemind.controller.actions.generated.instance.Pattern;
import freemind.controller.actions.generated.instance.PatternEdgeWidth;
import freemind.main.Tools;
import freemind.modes.MindIcon;
import freemind.modes.MindMapNode;
import freemind.modes.NodeAdapter;
import freemind.modes.mindmapmode.MindMapController;
import freemind.modes.mindmapmode.MindMapMapModel;
import freemind.modes.mindmapmode.MindMapNodeModel;
import freemind.modes.mindmapmode.actions.NodeGeneralAction;
import freemind.modes.mindmapmode.actions.SingleNodeOperation;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

public class ApplyPatternAction
extends NodeGeneralAction
implements SingleNodeOperation {
    private Pattern mpattern;

    public ApplyPatternAction(MindMapController controller, Pattern pattern) {
        super(controller, null, null);
        this.setName(pattern.getName());
        this.mpattern = pattern;
        this.setSingleNodeOperation(this);
    }

    public void apply(MindMapMapModel map, MindMapNodeModel node) {
        this.applyPattern(node, this.mpattern);
    }

    public void applyPattern(MindMapNode node, Pattern pattern) {
        PatternEdgeWidth patternEdgeWidth;
        if (pattern.getPatternNodeText() != null) {
            if (pattern.getPatternNodeText().getValue() != null) {
                this.getMindMapController().setNodeText(node, pattern.getPatternNodeText().getValue());
            } else {
                this.getMindMapController().setNodeText(node, "");
            }
        }
        if (pattern.getPatternNodeColor() != null) {
            this.getMindMapController().setNodeColor(node, Tools.xmlToColor(pattern.getPatternNodeColor().getValue()));
        }
        if (pattern.getPatternNodeBackgroundColor() != null) {
            this.getMindMapController().setNodeBackgroundColor(node, Tools.xmlToColor(pattern.getPatternNodeBackgroundColor().getValue()));
        }
        if (pattern.getPatternNodeStyle() != null) {
            this.getMindMapController().setNodeStyle(node, pattern.getPatternNodeStyle().getValue());
        }
        if (pattern.getPatternIcon() != null) {
            String iconName = pattern.getPatternIcon().getValue();
            if (iconName == null) {
                while (this.getMindMapController().removeLastIcon(node) > 0) {
                }
            } else {
                List icons = node.getIcons();
                boolean found = false;
                Iterator iterator = icons.iterator();
                while (iterator.hasNext()) {
                    MindIcon icon = (MindIcon)iterator.next();
                    if (icon.getName() == null || !icon.getName().equals(iconName)) continue;
                    found = true;
                    break;
                }
                if (!found) {
                    this.getMindMapController().addIcon(node, MindIcon.factory(iconName));
                }
            }
        }
        if (pattern.getPatternNodeFontName() != null) {
            String nodeFontFamily = pattern.getPatternNodeFontName().getValue();
            if (nodeFontFamily == null) {
                nodeFontFamily = this.getMindMapController().getController().getDefaultFontFamilyName();
            }
            this.getMindMapController().setFontFamily(node, nodeFontFamily);
        }
        if (pattern.getPatternNodeFontSize() != null) {
            String nodeFontSize = pattern.getPatternNodeFontSize().getValue();
            if (nodeFontSize == null) {
                nodeFontSize = "" + this.getMindMapController().getController().getDefaultFontSize();
            }
            this.getMindMapController().setFontSize(node, String.valueOf(nodeFontSize));
        }
        if (pattern.getPatternNodeFontItalic() != null) {
            this.getMindMapController().setItalic(node, "true".equals(pattern.getPatternNodeFontItalic().getValue()));
        }
        if (pattern.getPatternNodeFontBold() != null) {
            this.getMindMapController().setBold(node, "true".equals(pattern.getPatternNodeFontBold().getValue()));
        }
        if (pattern.getPatternEdgeColor() != null) {
            this.getMindMapController().setEdgeColor(node, Tools.xmlToColor(pattern.getPatternEdgeColor().getValue()));
        }
        if (pattern.getPatternEdgeStyle() != null) {
            this.getMindMapController().setEdgeStyle(node, pattern.getPatternEdgeStyle().getValue());
        }
        if ((patternEdgeWidth = pattern.getPatternEdgeWidth()) != null) {
            if (patternEdgeWidth.getValue() != null) {
                this.getMindMapController().setEdgeWidth(node, ApplyPatternAction.edgeWidthStringToInt(patternEdgeWidth.getValue()));
            } else {
                this.getMindMapController().setEdgeWidth(node, -1);
            }
        }
        if (pattern.getPatternChild() != null && pattern.getPatternChild().getValue() != null) {
            String searchedPatternName = pattern.getPatternChild().getValue();
            ApplyPatternAction[] patterns = this.getMindMapController().patterns;
            for (int i = 0; i < patterns.length; ++i) {
                ApplyPatternAction action = patterns[i];
                if (!action.getPattern().getName().equals(searchedPatternName)) continue;
                ListIterator j = node.childrenUnfolded();
                while (j.hasNext()) {
                    NodeAdapter child = (NodeAdapter)j.next();
                    this.applyPattern(child, action.getPattern());
                }
                break;
            }
        }
        Iterator i = this.getMindMapController().getPlugins().iterator();
        while (i.hasNext()) {
            MindMapController.MindMapControllerPlugin action = (MindMapController.MindMapControllerPlugin)i.next();
            if (!(action instanceof ExternalPatternAction)) continue;
            ExternalPatternAction externalAction = (ExternalPatternAction)action;
            externalAction.act(node, pattern);
        }
    }

    public static int edgeWidthStringToInt(String value) {
        if (value == null) {
            return -1;
        }
        if (value.equals("thin")) {
            return 0;
        }
        return Integer.valueOf(value);
    }

    public static String edgeWidthIntToString(int value) {
        if (value == -1) {
            return null;
        }
        if (value == 0) {
            return "thin";
        }
        return Integer.toString(value);
    }

    public Pattern getPattern() {
        return this.mpattern;
    }

    public static interface ExternalPatternAction
    extends MindMapController.MindMapControllerPlugin {
        public void act(MindMapNode var1, Pattern var2);
    }
}

