/*
 * Decompiled with CFR 0.152.
 */
package freemind.modes.mindmapmode.actions;

import freemind.controller.actions.generated.instance.AddArrowLinkXmlAction;
import freemind.controller.actions.generated.instance.RemoveArrowLinkXmlAction;
import freemind.controller.actions.generated.instance.XmlAction;
import freemind.main.Tools;
import freemind.modes.MindMapLinkRegistry;
import freemind.modes.MindMapNode;
import freemind.modes.NodeAdapter;
import freemind.modes.mindmapmode.MindMapArrowLinkModel;
import freemind.modes.mindmapmode.MindMapController;
import freemind.modes.mindmapmode.actions.FreemindAction;
import freemind.modes.mindmapmode.actions.RemoveArrowLinkAction;
import freemind.modes.mindmapmode.actions.xml.ActionPair;
import freemind.modes.mindmapmode.actions.xml.ActorXml;
import java.awt.event.ActionEvent;
import java.util.List;

public class AddArrowLinkAction
extends FreemindAction
implements ActorXml {
    private final MindMapController modeController;
    private RemoveArrowLinkAction removeAction;

    public void setRemoveAction(RemoveArrowLinkAction removeAction) {
        this.removeAction = removeAction;
    }

    public AddArrowLinkAction(MindMapController modeController) {
        super("add_link", "images/designer.png", modeController);
        this.modeController = modeController;
        this.addActor(this);
    }

    public void actionPerformed(ActionEvent e) {
        List selecteds = this.modeController.getSelecteds();
        if (selecteds.size() < 2) {
            this.modeController.getController().errorMessage(this.modeController.getText("less_than_two_selected_nodes"));
            return;
        }
        for (int i = 1; i < selecteds.size(); ++i) {
            this.addLink((MindMapNode)selecteds.get(i), (MindMapNode)selecteds.get(0));
        }
    }

    public void act(XmlAction action) {
        if (action instanceof AddArrowLinkXmlAction) {
            AddArrowLinkXmlAction arrowAction = (AddArrowLinkXmlAction)action;
            NodeAdapter source = this.modeController.getNodeFromID(arrowAction.getNode());
            NodeAdapter target = this.modeController.getNodeFromID(arrowAction.getDestination());
            String proposedId = arrowAction.getNewId();
            if (this.getLinkRegistry().getLabel(target) == null) {
                this.getLinkRegistry().registerLinkTarget(target);
            }
            MindMapArrowLinkModel linkModel = new MindMapArrowLinkModel(source, target, this.modeController.getFrame());
            linkModel.setDestinationLabel(this.getLinkRegistry().getLabel(target));
            linkModel.setUniqueID(this.getLinkRegistry().generateUniqueLinkID(proposedId));
            if (arrowAction.getColor() != null) {
                linkModel.setColor(Tools.xmlToColor(arrowAction.getColor()));
            }
            if (arrowAction.getEndArrow() != null) {
                linkModel.setEndArrow(arrowAction.getEndArrow());
            }
            if (arrowAction.getEndInclination() != null) {
                linkModel.setEndInclination(Tools.xmlToPoint(arrowAction.getEndInclination()));
            }
            if (arrowAction.getStartArrow() != null) {
                linkModel.setStartArrow(arrowAction.getStartArrow());
            }
            if (arrowAction.getStartInclination() != null) {
                linkModel.setStartInclination(Tools.xmlToPoint(arrowAction.getStartInclination()));
            }
            this.getLinkRegistry().registerLink(linkModel);
            this.modeController.nodeChanged(target);
            this.modeController.nodeChanged(source);
        }
    }

    public Class getDoActionClass() {
        return AddArrowLinkXmlAction.class;
    }

    private ActionPair getActionPair(MindMapNode source, MindMapNode target) {
        AddArrowLinkXmlAction doAction = this.createAddArrowLinkXmlAction(source, target, this.getLinkRegistry().generateUniqueLinkID(null));
        RemoveArrowLinkXmlAction undoAction = this.removeAction.createRemoveArrowLinkXmlAction(doAction.getNewId());
        return new ActionPair((XmlAction)doAction, (XmlAction)undoAction);
    }

    public AddArrowLinkXmlAction createAddArrowLinkXmlAction(MindMapNode source, MindMapNode target, String proposedID) {
        AddArrowLinkXmlAction action = new AddArrowLinkXmlAction();
        action.setNode(source.getObjectId(this.modeController));
        action.setDestination(target.getObjectId(this.modeController));
        action.setNewId(proposedID);
        return action;
    }

    public void addLink(MindMapNode source, MindMapNode target) {
        this.modeController.getActionFactory().startTransaction((String)this.getValue("Name"));
        this.modeController.getActionFactory().executeAction(this.getActionPair(source, target));
        this.modeController.getActionFactory().endTransaction((String)this.getValue("Name"));
    }

    private MindMapLinkRegistry getLinkRegistry() {
        return this.modeController.getMap().getLinkRegistry();
    }
}

