/*
 * Decompiled with CFR 0.152.
 */
package freemind.modes;

import freemind.controller.Controller;
import freemind.controller.MapModuleManager;
import freemind.controller.MindMapNodesSelection;
import freemind.controller.StructuredMenuHolder;
import freemind.extensions.PermanentNodeHook;
import freemind.main.FreeMindMain;
import freemind.main.Resources;
import freemind.main.Tools;
import freemind.main.XMLElement;
import freemind.main.XMLParseException;
import freemind.modes.MapAdapter;
import freemind.modes.MindMap;
import freemind.modes.MindMapNode;
import freemind.modes.Mode;
import freemind.modes.ModeController;
import freemind.modes.NodeAdapter;
import freemind.modes.XMLElementAdapter;
import freemind.modes.attributes.AttributeController;
import freemind.modes.common.listeners.MindMapMouseWheelEventHandler;
import freemind.view.mindmapview.MapView;
import freemind.view.mindmapview.NodeView;
import freemind.view.mindmapview.attributeview.AttributeView;
import java.awt.Color;
import java.awt.Component;
import java.awt.KeyboardFocusManager;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFileChooser;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.tree.TreeNode;

public abstract class ControllerAdapter
implements ModeController {
    private static Logger logger;
    private Mode mode;
    private Color selectionColor = new Color(200, 220, 200);
    private MapAdapter mModel;
    private HashSet mNodeSelectionListeners = new HashSet();
    private HashSet mNodeLifetimeListeners = new HashSet();
    private static File lastCurrentDir;
    private JPopupMenu popupmenu;
    protected final ControllerPopupMenuListener popupListenerSingleton = new ControllerPopupMenuListener();
    private boolean isBlocked = false;
    static /* synthetic */ Class class$freemind$view$mindmapview$attributeview$AttributeTable;

    public ControllerAdapter(Mode mode) {
        this.setMode(mode);
        if (logger == null) {
            logger = this.getFrame().getLogger(this.getClass().getName());
        }
    }

    public void setModel(MapAdapter model) {
        this.mModel = model;
    }

    public abstract MindMapNode newNode(Object var1, MindMap var2);

    public abstract XMLElement createXMLElement();

    public MapAdapter newModel(ModeController modeController) {
        throw new UnsupportedOperationException();
    }

    protected FileFilter getFileFilter() {
        return null;
    }

    public void nodeChanged(MindMapNode node) {
        this.getMap().setSaved(false);
        this.nodeRefresh(node, true);
    }

    public void nodeRefresh(MindMapNode node) {
        this.nodeRefresh(node, false);
    }

    private void nodeRefresh(MindMapNode node, boolean isUpdate) {
        logger.finest("nodeChanged called for node " + node + " parent=" + node.getParentNode());
        if (isUpdate) {
            if (node.getHistoryInformation() != null) {
                node.getHistoryInformation().setLastModifiedAt(new Date());
            }
            this.updateNode(node);
        }
        ((MapAdapter)this.getMap()).nodeChangedInternal(node);
    }

    public void refreshMap() {
        MindMapNode root = this.getMap().getRootNode();
        this.refreshMapFrom(root);
    }

    public void refreshMapFrom(MindMapNode node) {
        Iterator iterator = node.getChildren().iterator();
        while (iterator.hasNext()) {
            MindMapNode child = (MindMapNode)iterator.next();
            this.refreshMapFrom(child);
        }
        ((MapAdapter)this.getMap()).nodeChangedInternal(node);
    }

    public void nodeStructureChanged(MindMapNode node) {
        this.getMap().nodeStructureChanged(node);
    }

    protected void updateNode(MindMapNode node) {
        Iterator iter = this.mNodeSelectionListeners.iterator();
        while (iter.hasNext()) {
            ModeController.NodeSelectionListener listener = (ModeController.NodeSelectionListener)iter.next();
            listener.onUpdateNodeHook(node);
        }
    }

    public void onSelectHook(NodeView node) {
        Iterator iter = this.mNodeSelectionListeners.iterator();
        while (iter.hasNext()) {
            ModeController.NodeSelectionListener listener = (ModeController.NodeSelectionListener)iter.next();
            listener.onSelectHook(node);
        }
        Iterator i = node.getModel().getActivatedHooks().iterator();
        while (i.hasNext()) {
            PermanentNodeHook hook = (PermanentNodeHook)i.next();
            hook.onSelectHook(node);
        }
    }

    public void onDeselectHook(NodeView node) {
        try {
            HashSet copy = new HashSet(this.mNodeSelectionListeners);
            Iterator iter = copy.iterator();
            while (iter.hasNext()) {
                ModeController.NodeSelectionListener listener = (ModeController.NodeSelectionListener)iter.next();
                listener.onDeselectHook(node);
            }
            Iterator i = node.getModel().getActivatedHooks().iterator();
            while (i.hasNext()) {
                PermanentNodeHook hook = (PermanentNodeHook)i.next();
                hook.onDeselectHook(node);
            }
        }
        catch (RuntimeException e) {
            logger.log(Level.SEVERE, "Error in node selection listeners", e);
        }
    }

    public void onViewCreatedHook(NodeView node) {
        Iterator i = node.getModel().getActivatedHooks().iterator();
        while (i.hasNext()) {
            PermanentNodeHook hook = (PermanentNodeHook)i.next();
            hook.onViewCreatedHook(node);
        }
    }

    public void onViewRemovedHook(NodeView node) {
        Iterator i = node.getModel().getActivatedHooks().iterator();
        while (i.hasNext()) {
            PermanentNodeHook hook = (PermanentNodeHook)i.next();
            hook.onViewRemovedHook(node);
        }
    }

    public void registerNodeSelectionListener(ModeController.NodeSelectionListener listener) {
        this.mNodeSelectionListeners.add(listener);
    }

    public void deregisterNodeSelectionListener(ModeController.NodeSelectionListener listener) {
        this.mNodeSelectionListeners.remove(listener);
    }

    public void registerNodeLifetimeListener(ModeController.NodeLifetimeListener listener) {
        this.mNodeLifetimeListeners.add(listener);
        this.fireRecursiveNodeCreateEvent(this.getRootNode());
    }

    public void deregisterNodeLifetimeListener(ModeController.NodeLifetimeListener listener) {
        this.mNodeLifetimeListeners.remove(listener);
    }

    public HashSet getNodeLifetimeListeners() {
        return this.mNodeLifetimeListeners;
    }

    public void fireNodePreDeleteEvent(MindMapNode node) {
        Iterator iter = this.mNodeLifetimeListeners.iterator();
        while (iter.hasNext()) {
            ModeController.NodeLifetimeListener listener = (ModeController.NodeLifetimeListener)iter.next();
            listener.onPreDeleteNode(node);
        }
    }

    public void fireNodePostDeleteEvent(MindMapNode node, MindMapNode parent) {
        Iterator iter = this.mNodeLifetimeListeners.iterator();
        while (iter.hasNext()) {
            ModeController.NodeLifetimeListener listener = (ModeController.NodeLifetimeListener)iter.next();
            listener.onPostDeleteNode(node, parent);
        }
    }

    public void fireRecursiveNodeCreateEvent(MindMapNode node) {
        ListIterator i = node.childrenUnfolded();
        while (i.hasNext()) {
            NodeAdapter child = (NodeAdapter)i.next();
            this.fireRecursiveNodeCreateEvent(child);
        }
        Iterator iter = this.mNodeLifetimeListeners.iterator();
        while (iter.hasNext()) {
            ModeController.NodeLifetimeListener listener = (ModeController.NodeLifetimeListener)iter.next();
            listener.onCreateNodeHook(node);
        }
    }

    public void firePreSaveEvent(MindMapNode node) {
        HashSet listenerCopy = new HashSet(this.mNodeSelectionListeners);
        Iterator iter = listenerCopy.iterator();
        while (iter.hasNext()) {
            ModeController.NodeSelectionListener listener = (ModeController.NodeSelectionListener)iter.next();
            listener.onSaveNode(node);
        }
    }

    public String getText(String textId) {
        return this.getController().getResourceString(textId);
    }

    public MindMap newMap() {
        ModeController newModeController = this.getMode().createModeController();
        MapAdapter newModel = this.newModel(newModeController);
        this.newMap(newModel);
        return newModel;
    }

    public void newMap(MindMap mapModel) {
        this.getController().getMapModuleManager().newMapModule(mapModel, mapModel.getModeController());
        mapModel.setSaved(false);
    }

    public ModeController load(URL file) throws FileNotFoundException, IOException, XMLParseException, URISyntaxException {
        ModeController newModeController = this.getMode().createModeController();
        MapAdapter model = this.newModel(newModeController);
        model.load(file);
        this.newMap(model);
        model.setSaved(true);
        return newModeController;
    }

    public ModeController load(File file) throws FileNotFoundException, IOException {
        ModeController newModeController = this.getMode().createModeController();
        MapAdapter model = this.newModel(newModeController);
        model.load(file);
        logger.info("Start loading " + file);
        this.newMap(model);
        model.setSaved(true);
        logger.info("Finished loading " + file);
        return newModeController;
    }

    public boolean save() {
        if (this.getModel().isSaved()) {
            return true;
        }
        if (this.getModel().getFile() == null || this.getModel().isReadOnly()) {
            return this.saveAs();
        }
        return this.save(this.getModel().getFile());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void loadURL(String relative) {
        block21: {
            try {
                String extension;
                logger.info("Trying to open " + relative);
                URL absolute = null;
                if (Tools.isAbsolutePath(relative)) {
                    absolute = Tools.fileToUrl(new File(relative));
                } else {
                    if (relative.startsWith("#")) {
                        logger.finest("found relative link to " + relative);
                        String target = relative.substring(1);
                        try {
                            this.centerNode(this.getNodeFromID(target));
                            return;
                        }
                        catch (Exception e) {
                            Resources.getInstance().logException(e);
                            this.getFrame().out(Tools.expandPlaceholders(this.getText("link_not_found"), target));
                            this.getFrame().setWaitingCursor(false);
                            return;
                        }
                    }
                    absolute = new URL(this.getMap().getURL(), relative);
                }
                URL originalURL = absolute;
                String ref = absolute.getRef();
                if (ref != null) {
                    absolute = Tools.getURLWithoutReference(absolute);
                }
                if ((extension = Tools.getExtension(absolute.toString())) != null && extension.equals("mm")) {
                    logger.info("Trying to open mind map " + absolute);
                    MapModuleManager mapModuleManager = this.getController().getMapModuleManager();
                    String mapExtensionKey = mapModuleManager.checkIfFileIsAlreadyOpened(absolute);
                    if (mapExtensionKey == null) {
                        this.getFrame().setWaitingCursor(true);
                        this.load(absolute);
                    } else {
                        mapModuleManager.tryToChangeToMapModule(mapExtensionKey);
                    }
                    if (ref == null) break block21;
                    try {
                        ModeController newModeController = this.getController().getModeController();
                        newModeController.centerNode(newModeController.getNodeFromID(ref));
                        break block21;
                    }
                    catch (Exception e) {
                        Resources.getInstance().logException(e);
                        this.getFrame().out(Tools.expandPlaceholders(this.getText("link_not_found"), ref));
                        this.getFrame().setWaitingCursor(false);
                        return;
                    }
                }
                this.getFrame().openDocument(originalURL);
                break block21;
                {
                    catch (MalformedURLException ex) {
                        Resources.getInstance().logException(ex);
                        this.getController().errorMessage(this.getText("url_error") + "\n" + ex);
                        return;
                    }
                    catch (Exception e) {
                        Resources.getInstance().logException(e);
                        break block21;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                this.getFrame().setWaitingCursor(false);
            }
        }
    }

    public MindMapNode createNodeTreeFromXml(Reader pReader, HashMap pIDToTarget) throws XMLParseException, IOException {
        XMLElementAdapter element = (XMLElementAdapter)this.createXMLElement();
        element.setIDToTarget(pIDToTarget);
        element.parseFromReader(pReader);
        element.processUnfinishedLinks(this.getModel().getLinkRegistry());
        NodeAdapter node = element.getMapChild();
        return node;
    }

    public void invokeHooksRecursively(NodeAdapter node, MindMap map) {
        Iterator i = node.childrenUnfolded();
        while (i.hasNext()) {
            NodeAdapter child = (NodeAdapter)i.next();
            this.invokeHooksRecursively(child, map);
        }
        i = node.getHooks().iterator();
        while (i.hasNext()) {
            PermanentNodeHook hook = (PermanentNodeHook)i.next();
            hook.setController(this);
            hook.setMap(map);
            node.invokeHook(hook);
        }
    }

    public List getSelecteds() {
        LinkedList<MindMapNode> selecteds = new LinkedList<MindMapNode>();
        ListIterator it = this.getView().getSelecteds().listIterator();
        if (it != null) {
            while (it.hasNext()) {
                NodeView selected = (NodeView)it.next();
                selecteds.add(selected.getModel());
            }
        }
        return selecteds;
    }

    public void select(NodeView node) {
        this.getView().scrollNodeToVisible(node);
        this.getView().selectAsTheOnlyOneSelected(node);
        this.getView().setSiblingMaxLevel(node.getModel().getNodeLevel());
    }

    public List getSelectedsByDepth() {
        List result = this.getSelecteds();
        this.sortNodesByDepth(result);
        return result;
    }

    public void sortNodesByDepth(List inPlaceList) {
        Collections.sort(inPlaceList, new nodesDepthComparator());
        logger.finest("Sort result: " + inPlaceList);
    }

    public boolean save(File file) {
        return this.getModel().save(file);
    }

    protected JMenuItem add(JMenu menu, Action action, String keystroke) {
        JMenuItem item = menu.add(action);
        item.setAccelerator(KeyStroke.getKeyStroke(this.getFrame().getAdjustableProperty(keystroke)));
        return item;
    }

    protected JMenuItem add(StructuredMenuHolder holder, String category, Action action, String keystroke) {
        JMenuItem item = holder.addAction(action, category);
        if (keystroke != null) {
            String keyProperty = this.getFrame().getAdjustableProperty(keystroke);
            logger.finest("Found key stroke: " + keyProperty);
            item.setAccelerator(KeyStroke.getKeyStroke(keyProperty));
        }
        return item;
    }

    protected JMenuItem addCheckBox(StructuredMenuHolder holder, String category, Action action, String keystroke) {
        JCheckBoxMenuItem item = (JCheckBoxMenuItem)holder.addMenuItem(new JCheckBoxMenuItem(action), category);
        if (keystroke != null) {
            item.setAccelerator(KeyStroke.getKeyStroke(this.getFrame().getAdjustableProperty(keystroke)));
        }
        return item;
    }

    protected JMenuItem addRadioItem(StructuredMenuHolder holder, String category, Action action, String keystroke, boolean isSelected) {
        JRadioButtonMenuItem item = (JRadioButtonMenuItem)holder.addMenuItem(new JRadioButtonMenuItem(action), category);
        if (keystroke != null) {
            item.setAccelerator(KeyStroke.getKeyStroke(this.getFrame().getAdjustableProperty(keystroke)));
        }
        item.setSelected(isSelected);
        return item;
    }

    protected void add(JMenu menu, Action action) {
        menu.add(action);
    }

    public void open() {
        JFileChooser chooser = this.getFileChooser();
        int returnVal = chooser.showOpenDialog(this.getView());
        if (returnVal == 0) {
            File[] selectedFiles = chooser.isMultiSelectionEnabled() ? chooser.getSelectedFiles() : new File[]{chooser.getSelectedFile()};
            for (int i = 0; i < selectedFiles.length; ++i) {
                File theFile = selectedFiles[i];
                try {
                    lastCurrentDir = theFile.getParentFile();
                    this.load(theFile);
                    continue;
                }
                catch (Exception ex) {
                    this.handleLoadingException(ex);
                    break;
                }
            }
        }
        this.getController().setTitle();
    }

    public JFileChooser getFileChooser(FileFilter filter) {
        JFileChooser chooser = new JFileChooser();
        File parentFile = this.getMapsParentFile();
        if (parentFile != null && lastCurrentDir == null) {
            lastCurrentDir = parentFile;
        }
        if (lastCurrentDir != null) {
            chooser.setCurrentDirectory(lastCurrentDir);
        }
        if (filter != null) {
            chooser.addChoosableFileFilter(filter);
        }
        return chooser;
    }

    protected JFileChooser getFileChooser() {
        return this.getFileChooser(this.getFileFilter());
    }

    private File getMapsParentFile() {
        if (this.getMap() != null && this.getMap().getFile() != null && this.getMap().getFile().getParentFile() != null) {
            return this.getMap().getFile().getParentFile();
        }
        return null;
    }

    public void handleLoadingException(Exception ex) {
        String exceptionType = ex.getClass().getName();
        if (exceptionType.equals("freemind.main.XMLParseException")) {
            int showDetail = JOptionPane.showConfirmDialog(this.getView(), this.getText("map_corrupted"), "FreeMind", 0, 0);
            if (showDetail == 0) {
                this.getController().errorMessage(ex);
            }
        } else if (exceptionType.equals("java.io.FileNotFoundException")) {
            this.getController().errorMessage(ex.getMessage());
        } else {
            Resources.getInstance().logException(ex);
            this.getController().errorMessage(ex);
        }
    }

    public boolean saveAs() {
        File f;
        boolean repeatSaveAsQuestion;
        JFileChooser chooser = this.getFileChooser();
        if (this.getMapsParentFile() == null) {
            chooser.setSelectedFile(new File(this.getFileNameProposal() + ".mm"));
        }
        chooser.setDialogTitle(this.getText("save_as"));
        do {
            int overwriteMap;
            repeatSaveAsQuestion = false;
            int returnVal = chooser.showSaveDialog(this.getView());
            if (returnVal != 0) {
                return false;
            }
            f = chooser.getSelectedFile();
            lastCurrentDir = f.getParentFile();
            String ext = Tools.getExtension(f.getName());
            if (!ext.equals("mm")) {
                f = new File(f.getParent(), f.getName() + ".mm");
            }
            if (!f.exists() || (overwriteMap = JOptionPane.showConfirmDialog(this.getView(), this.getText("map_already_exists"), "FreeMind", 0)) == 0) continue;
            repeatSaveAsQuestion = true;
        } while (repeatSaveAsQuestion);
        try {
            String lockingUser = this.getModel().tryToLock(f);
            if (lockingUser != null) {
                this.getFrame().getController().informationMessage(Tools.expandPlaceholders(this.getText("map_locked_by_save_as"), f.getName(), lockingUser));
                return false;
            }
        }
        catch (Exception e) {
            this.getFrame().getController().informationMessage(Tools.expandPlaceholders(this.getText("locking_failed_by_save_as"), f.getName()));
            return false;
        }
        this.save(f);
        this.getController().getMapModuleManager().updateMapModuleName();
        return true;
    }

    private String getFileNameProposal() {
        return Tools.getFileNameProposal(this.getMap().getRootNode());
    }

    public boolean close(boolean force, MapModuleManager mapModuleManager) {
        this.getFrame().out("");
        if (!force && !this.getModel().isSaved()) {
            boolean savingNotCancelled;
            String text = this.getText("save_unsaved") + "\n" + mapModuleManager.getMapModule().toString();
            String title = Tools.removeMnemonic(this.getText("save"));
            int returnVal = JOptionPane.showOptionDialog(this.getFrame().getContentPane(), text, title, 1, 3, null, null, null);
            if (returnVal == 0 ? !(savingNotCancelled = this.save()) : returnVal == 2 || returnVal == -1) {
                return false;
            }
        }
        this.getModel().destroy();
        return true;
    }

    public void setVisible(boolean visible) {
        if (visible) {
            NodeView node = this.getSelectedView();
            this.onSelectHook(node);
        } else {
            NodeView node = this.getSelectedView();
            if (node != null) {
                this.onDeselectHook(node);
            }
        }
    }

    protected void setAllActions(boolean enabled) {
        this.getController().zoomIn.setEnabled(enabled);
        this.getController().zoomOut.setEnabled(enabled);
        this.getController().showFilterToolbarAction.setEnabled(enabled);
    }

    public void showPopupMenu(MouseEvent e) {
        JPopupMenu popupmenu;
        if (e.isPopupTrigger() && (popupmenu = this.getPopupMenu()) != null) {
            popupmenu.addPopupMenuListener(this.popupListenerSingleton);
            popupmenu.show(e.getComponent(), e.getX(), e.getY());
            e.consume();
        }
    }

    public JPopupMenu getPopupForModel(Object obj) {
        return null;
    }

    public Component getLeftToolBar() {
        return null;
    }

    public JToolBar getModeToolBar() {
        return null;
    }

    public boolean isBlocked() {
        return this.isBlocked;
    }

    public void setBlocked(boolean isBlocked) {
        this.isBlocked = isBlocked;
    }

    public Mode getMode() {
        return this.mode;
    }

    protected void setMode(Mode mode) {
        this.mode = mode;
    }

    public MindMap getMap() {
        return this.mModel;
    }

    public MindMapNode getRootNode() {
        return (MindMapNode)this.getMap().getRoot();
    }

    public URL getResource(String name) {
        return this.getFrame().getResource(name);
    }

    public Controller getController() {
        return this.getMode().getController();
    }

    public FreeMindMain getFrame() {
        return this.getController().getFrame();
    }

    public ControllerAdapter getModeController() {
        return this;
    }

    public MapAdapter getModel() {
        return this.mModel;
    }

    public MapView getView() {
        return this.getController().getView();
    }

    protected void updateMapModuleName() {
        this.getController().getMapModuleManager().updateMapModuleName();
    }

    public NodeAdapter getNodeFromID(String nodeID) {
        NodeAdapter node = (NodeAdapter)this.getMap().getLinkRegistry().getTargetForID(nodeID);
        if (node == null) {
            throw new IllegalArgumentException("Node belonging to the node id " + nodeID + " not found.");
        }
        return node;
    }

    public String getNodeID(MindMapNode selected) {
        this.getMap().getLinkRegistry().registerLinkTarget(selected);
        return this.getMap().getLinkRegistry().getLabel(selected);
    }

    public MindMapNode getSelected() {
        NodeView selectedView = this.getSelectedView();
        if (selectedView != null) {
            return selectedView.getModel();
        }
        return null;
    }

    public NodeView getSelectedView() {
        if (this.getView() != null) {
            return this.getView().getSelected();
        }
        return null;
    }

    public Transferable copy(MindMapNode node, boolean saveInvisible) {
        throw new IllegalArgumentException("No copy so far.");
    }

    public Transferable copy() {
        return this.copy(this.getView().getSelectedNodesSortedByY(), false);
    }

    public Transferable copySingle() {
        ArrayList selectedNodes = this.getView().getSingleSelectedNodes();
        return this.copy(selectedNodes, false);
    }

    public Transferable copy(List selectedNodes, boolean copyInvisible) {
        try {
            String forNodesFlavor = this.createForNodesFlavor(selectedNodes, copyInvisible);
            String plainText = this.getMap().getAsPlainText(selectedNodes);
            return new MindMapNodesSelection(forNodesFlavor, plainText, this.getMap().getAsRTF(selectedNodes), this.getMap().getAsHTML(selectedNodes), null, null);
        }
        catch (UnsupportedFlavorException ex) {
            Resources.getInstance().logException(ex);
        }
        catch (IOException ex) {
            Resources.getInstance().logException(ex);
        }
        return null;
    }

    public String createForNodesFlavor(List selectedNodes, boolean copyInvisible) throws UnsupportedFlavorException, IOException {
        String forNodesFlavor = "";
        boolean firstLoop = true;
        Iterator it = selectedNodes.iterator();
        while (it.hasNext()) {
            MindMapNode tmpNode = (MindMapNode)it.next();
            if (firstLoop) {
                firstLoop = false;
            } else {
                forNodesFlavor = forNodesFlavor + "<nodeseparator>";
            }
            forNodesFlavor = forNodesFlavor + this.copy(tmpNode, copyInvisible).getTransferData(MindMapNodesSelection.mindMapNodesFlavor);
        }
        return forNodesFlavor;
    }

    public Color getSelectionColor() {
        return this.selectionColor;
    }

    public void updatePopupMenu(StructuredMenuHolder holder) {
    }

    public void shutdownController() {
        this.setAllActions(false);
        this.getController().getMapMouseWheelListener().deregister();
    }

    public void startupController() {
        this.setAllActions(true);
        if (this.getFrame().getView() != null) {
            FileOpener fileOpener = new FileOpener();
            DropTarget dropTarget = new DropTarget(this.getFrame().getView(), fileOpener);
        }
        this.getController().getMapMouseWheelListener().register(new MindMapMouseWheelEventHandler(this));
    }

    public void _setFolded(MindMapNode node, boolean folded) {
        if (node == null) {
            throw new IllegalArgumentException("setFolded was called with a null node.");
        }
        if (node.isRoot() && folded) {
            return;
        }
        if (node.isFolded() != folded) {
            node.setFolded(folded);
            this.nodeStructureChanged(node);
        }
    }

    public String getLinkShortText(MindMapNode node) {
        String adaptedText = node.getLink();
        if (adaptedText == null) {
            return null;
        }
        if (adaptedText.startsWith("#")) {
            try {
                NodeAdapter dest = this.getNodeFromID(adaptedText.substring(1));
                return dest.getShortText(this);
            }
            catch (Exception e) {
                return this.getText("link_not_available_any_more");
            }
        }
        return adaptedText;
    }

    public void displayNode(MindMapNode node) {
        this.displayNode(node, null);
    }

    public void displayNode(MindMapNode node, ArrayList nodesUnfoldedByDisplay) {
        TreeNode[] path = this.getMap().getPathToRoot(node);
        for (int i = 0; i < path.length - 1; ++i) {
            MindMapNode nodeOnPath = (MindMapNode)path[i];
            if (!nodeOnPath.isFolded()) continue;
            if (nodesUnfoldedByDisplay != null) {
                nodesUnfoldedByDisplay.add(nodeOnPath);
            }
            this.setFolded(nodeOnPath, false);
        }
    }

    private void centerNode(NodeView node) {
        this.getView().centerNode(node);
        this.getView().selectAsTheOnlyOneSelected(node);
        this.getController().obtainFocusForSelected();
    }

    public void centerNode(MindMapNode node) {
        NodeView view = null;
        if (node != null) {
            view = this.getController().getView().getNodeView(node);
        }
        if (view == null) {
            this.displayNode(node);
            view = this.getController().getView().getNodeView(node);
        }
        this.centerNode(view);
    }

    public File getLastCurrentDir() {
        return lastCurrentDir;
    }

    public void setLastCurrentDir(File pLastCurrentDir) {
        lastCurrentDir = pLastCurrentDir;
    }

    public AttributeController getAttributeController() {
        return null;
    }

    public NodeView getNodeView(MindMapNode node) {
        return this.getView().getNodeView(node);
    }

    public void insertNodeInto(MindMapNode newNode, MindMapNode parent, int index) {
        this.getModel().insertNodeInto(newNode, parent, index);
        Iterator iterator = this.mNodeLifetimeListeners.iterator();
        while (iterator.hasNext()) {
            ModeController.NodeLifetimeListener listener = (ModeController.NodeLifetimeListener)iterator.next();
            listener.onCreateNodeHook(newNode);
        }
    }

    public void insertNodeInto(MindMapNode newChild, MindMapNode parent) {
        this.insertNodeInto(newChild, parent, parent.getChildCount());
    }

    public void loadURL() {
        String link = this.getSelected().getLink();
        if (link != null) {
            this.loadURL(link);
        }
    }

    public Set getRegisteredMouseWheelEventHandler() {
        return Collections.EMPTY_SET;
    }

    static {
        lastCurrentDir = null;
    }

    protected class FileOpener
    implements DropTargetListener {
        protected FileOpener() {
        }

        private boolean isDragAcceptable(DropTargetDragEvent event) {
            DataFlavor[] flavors = event.getCurrentDataFlavors();
            for (int i = 0; i < flavors.length; ++i) {
                if (!flavors[i].isFlavorJavaFileListType()) continue;
                return true;
            }
            return false;
        }

        private boolean isDropAcceptable(DropTargetDropEvent event) {
            DataFlavor[] flavors = event.getCurrentDataFlavors();
            for (int i = 0; i < flavors.length; ++i) {
                if (!flavors[i].isFlavorJavaFileListType()) continue;
                return true;
            }
            return false;
        }

        public void drop(DropTargetDropEvent dtde) {
            if (!this.isDropAcceptable(dtde)) {
                dtde.rejectDrop();
                return;
            }
            dtde.acceptDrop(1);
            try {
                Object data = dtde.getTransferable().getTransferData(DataFlavor.javaFileListFlavor);
                if (data == null) {
                    dtde.dropComplete(false);
                    return;
                }
                Iterator iterator = ((List)data).iterator();
                while (iterator.hasNext()) {
                    File file = (File)iterator.next();
                    ControllerAdapter.this.load(file);
                }
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(ControllerAdapter.this.getView(), "Couldn't open dropped file(s). Reason: " + e.getMessage());
                dtde.dropComplete(false);
                return;
            }
            dtde.dropComplete(true);
        }

        public void dragEnter(DropTargetDragEvent dtde) {
            if (!this.isDragAcceptable(dtde)) {
                dtde.rejectDrag();
                return;
            }
        }

        public void dragOver(DropTargetDragEvent e) {
        }

        public void dragExit(DropTargetEvent e) {
        }

        public void dragScroll(DropTargetDragEvent e) {
        }

        public void dropActionChanged(DropTargetDragEvent e) {
        }
    }

    protected class EditAttributesAction
    extends AbstractAction {
        public EditAttributesAction() {
            super(Resources.getInstance().getResourceString("attributes_edit_in_place"));
        }

        public void actionPerformed(ActionEvent e) {
            boolean attributesClosed;
            Component focusOwner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
            AttributeView attributeView = ControllerAdapter.this.getView().getSelected().getAttributeView();
            boolean bl = attributesClosed = null == SwingUtilities.getAncestorOfClass(class$freemind$view$mindmapview$attributeview$AttributeTable == null ? (class$freemind$view$mindmapview$attributeview$AttributeTable = ControllerAdapter.class$("freemind.view.mindmapview.attributeview.AttributeTable")) : class$freemind$view$mindmapview$attributeview$AttributeTable, focusOwner);
            if (attributesClosed) {
                attributeView.startEditing();
            } else {
                attributeView.stopEditing();
            }
        }
    }

    public class SaveAsAction
    extends AbstractAction {
        ControllerAdapter mc;

        public SaveAsAction(ControllerAdapter modeController) {
            super(ControllerAdapter.this.getText("save_as"), new ImageIcon(ControllerAdapter.this.getResource("images/filesaveas.png")));
            this.mc = modeController;
        }

        public void actionPerformed(ActionEvent e) {
            this.mc.saveAs();
            ControllerAdapter.this.getController().setTitle();
        }
    }

    public class SaveAction
    extends AbstractAction {
        ControllerAdapter mc;

        public SaveAction(ControllerAdapter modeController) {
            super(Tools.removeMnemonic(ControllerAdapter.this.getText("save")), new ImageIcon(ControllerAdapter.this.getResource("images/filesave.png")));
            this.mc = modeController;
        }

        public void actionPerformed(ActionEvent e) {
            boolean success = this.mc.save();
            if (success) {
                ControllerAdapter.this.getFrame().out(ControllerAdapter.this.getText("saved"));
            } else {
                String message = "Saving failed.";
                ControllerAdapter.this.getFrame().out(message);
                ControllerAdapter.this.getController().errorMessage(message);
            }
            ControllerAdapter.this.getController().setTitle();
        }
    }

    public class OpenAction
    extends AbstractAction {
        ControllerAdapter mc;

        public OpenAction(ControllerAdapter modeController) {
            super(ControllerAdapter.this.getText("open"), new ImageIcon(ControllerAdapter.this.getResource("images/fileopen.png")));
            this.mc = modeController;
        }

        public void actionPerformed(ActionEvent e) {
            this.mc.open();
            ControllerAdapter.this.getController().setTitle();
        }
    }

    private class ControllerPopupMenuListener
    implements PopupMenuListener {
        private ControllerPopupMenuListener() {
        }

        public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
            ControllerAdapter.this.setBlocked(true);
        }

        public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
            ControllerAdapter.this.setBlocked(false);
        }

        public void popupMenuCanceled(PopupMenuEvent e) {
            ControllerAdapter.this.setBlocked(false);
        }
    }

    protected class nodesDepthComparator
    implements Comparator {
        public int compare(Object p1, Object p2) {
            TreeNode[] path2;
            MindMapNode n1 = (MindMapNode)p1;
            MindMapNode n2 = (MindMapNode)p2;
            TreeNode[] path1 = ControllerAdapter.this.getModel().getPathToRoot(n1);
            int depth = path1.length - (path2 = ControllerAdapter.this.getModel().getPathToRoot(n2)).length;
            if (depth > 0) {
                return -1;
            }
            if (depth < 0) {
                return 1;
            }
            if (n1.isRoot()) {
                return 0;
            }
            return n1.getParentNode().getChildPosition(n1) - n2.getParentNode().getChildPosition(n2);
        }
    }
}

