/*
 * MidiDevices.java
 *
 * Created on 7 de marzo de 2005, 10:38 PM
 */

package dguitar.gui.midi;


import java.awt.BorderLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

import common.Midi;
import common.Util;
import dguitar.gui.DGuitar;

/**
 *
 * @author  Mauricio Gracia Gutirrez
 */
public class MidiDevices extends javax.swing.JDialog implements ActionListener,ListSelectionListener {
    private JButton btnSetDevice ;
    private JButton btnCancel ;
    private int currentIndex ;
    private static Midi midi ;
    private JPanel btnPanel ;
    private Frame parent ;
    private String mdc ;
    /** Creates new form MidiDevices */
    
    public MidiDevices(Frame parent, boolean modal, Midi m, String midiDeviceConfigured) {
        super(parent, modal);
        midi = m ;
        mdc = midiDeviceConfigured ;
        initComponents();
        postInit() ;
    }
    private void setMidiDevices(Object array[] ) {
        MidiDevices.midiDevices.setListData(array) ;
    }
    private void setCurrentMidiDevice(int i) {
    	currentIndex = i ;
    	MidiDevices.midiDevices.setSelectedIndex(i) ;
    	this.btnSetDevice.setEnabled(false) ;
    	this.btnSetDevice.setText(DGuitar.getLang().getString("isCurrentMidiDevice")) ;
    }
    private void postInit() {
    	this.btnPanel = new JPanel(new BorderLayout()) ;
    	
    	this.btnCancel = new JButton() ;
    	this.btnCancel.setText(DGuitar.getLang().getString("menuClose")) ;
    	this.btnCancel.addActionListener(this) ;
    	
    	this.btnSetDevice = new JButton() ;
    	//TODO...implement how to change the midi device for Java 1.4.X


    	this.btnSetDevice.setText(DGuitar.getLang().getString("setMidiDevice")) ;
    	this.btnSetDevice.addActionListener(this) ;
    	this.btnPanel.add(btnSetDevice,java.awt.BorderLayout.CENTER) ;

        
    	MidiDevices.midiDevices.addListSelectionListener(this) ;
    	
    	this.setTitle(DGuitar.getLang().getString("menuMidiDevices")) ;
    	
        this.setMidiDevices(midi.getMidiDevices()) ;
        this.setCurrentMidiDevice(midi.getCurrentDeviceIndex()) ;
        
        
        this.btnPanel.add(btnCancel,java.awt.BorderLayout.SOUTH) ;
        
        this.getContentPane().add(btnPanel,java.awt.BorderLayout.SOUTH) ;
    }
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    private void initComponents() {//GEN-BEGIN:initComponents
        midiDevices = new javax.swing.JList();

        setDefaultCloseOperation(javax.swing.WindowConstants.DISPOSE_ON_CLOSE);
        midiDevices.setSelectionMode(javax.swing.ListSelectionModel.SINGLE_SELECTION);
        getContentPane().add(midiDevices, java.awt.BorderLayout.CENTER);

        java.awt.Dimension screenSize = java.awt.Toolkit.getDefaultToolkit().getScreenSize();
        setBounds((screenSize.width-400)/2, (screenSize.height-300)/2, 400, 300);
    }//GEN-END:initComponents
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private static javax.swing.JList midiDevices;
    // End of variables declaration//GEN-END:variables

	/* (non-Javadoc)
	 * @see java.awt.event.ActionListener#actionPerformed(java.awt.event.ActionEvent)
	 */
	public void actionPerformed(ActionEvent e) {
		int aux ;
		JButton btn ;
		boolean success ;
		
		btn = (JButton) e.getSource() ;
		if(btn.equals(this.btnSetDevice)) {
			aux = MidiDevices.midiDevices.getSelectedIndex() ;
			success = midi.setCurrentDevice(aux,DGuitar.getLang().getString("doesNotHaveAnyReceivers")) ;
			if(success) {
				setCurrentMidiDevice(aux) ;
                Util.showDialogOk(this.parent,mdc,midi.deviceMessage(DGuitar.getLang().getString("MidiDevice"),DGuitar.getLang().getString("isNowPreferredDevice")) ) ;
			}
		}
		else {
			this.dispose() ;
		}
	}
	/* (non-Javadoc)
	 * @see javax.swing.event.ListSelectionListener#valueChanged(javax.swing.event.ListSelectionEvent)
	 */
	public void valueChanged(ListSelectionEvent e) {
		int aux ;
		
		aux = MidiDevices.midiDevices.getSelectedIndex() ;
		if(aux == currentIndex) {
	    	this.btnSetDevice.setEnabled(false) ;
	    	this.btnSetDevice.setText(DGuitar.getLang().getString("isCurrentMidiDevice")) ;
		}
		else
		{
			this.btnSetDevice.setText(DGuitar.getLang().getString("setMidiDevice")) ;
			this.btnSetDevice.setEnabled(true) ;
			
		}
	}
}
    

