/*
 * About.java
 *
 * Created on 18 de febrero de 2005, 03:42 PM
 */

package dguitar.gui;

/**
 * This class creates the About window
 * 
 * @author  Mauricio Gracia Gutirrez
 */
public class About extends javax.swing.JDialog {
    /**
     *  the width of the dialog
     */
    private int width ;
    
    /**
     * The height of the dialog
     */
    private int height ;

    /**
     *  the pane with the authors information
     */
    protected javax.swing.JTextPane authors;
    
    /**
     * The label were the logo is displayed
     */
    private javax.swing.JLabel logo;

    /** Creates new About Dialog 
     * @param w the desired width
     * @param h the desired height
     */
    public About(int w, int h) {
        this.width = w ;
        this.height = h ;
        initComponents();
        this.logo.setIcon(DGuitar.Logo) ;
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    private void initComponents() {//GEN-BEGIN:initComponents
        this.logo = new javax.swing.JLabel();
        this.authors = new javax.swing.JTextPane();

        setDefaultCloseOperation(javax.swing.WindowConstants.DISPOSE_ON_CLOSE);
        setModal(true);
        setResizable(false);
        getContentPane().add(this.logo, java.awt.BorderLayout.NORTH);

        this.authors.setEditable(false);
        getContentPane().add(this.authors, java.awt.BorderLayout.CENTER);

        java.awt.Dimension screenSize = java.awt.Toolkit.getDefaultToolkit().getScreenSize();
        setBounds((screenSize.width-this.width)/2, (screenSize.height-this.height)/2, this.width, this.height);
    }//GEN-END:initComponents
    
    

}
