/*
 * Decompiled with CFR 0.152.
 */
package dguitar.players.sound.midi.demo;

import dguitar.adaptors.guitarPro.GPAdaptor;
import dguitar.adaptors.song.Song;
import dguitar.codecs.guitarPro.GPFormatException;
import dguitar.codecs.guitarPro.GPInputStream;
import dguitar.codecs.guitarPro.GPSong;
import dguitar.players.sound.Arrangement;
import dguitar.players.sound.MasterPlayer;
import dguitar.players.sound.SoundPlayer;
import dguitar.players.sound.midi.MidiPlayer;
import dguitar.players.sound.midi.demo.ExampleEventListener;
import dguitar.players.sound.midi.demo.ExampleTimerListener;
import dguitar.players.sound.midi.demo.LinePrinter;
import dguitar.players.sound.midi.demo.SystemLinePrinter;
import java.io.IOException;
import java.util.logging.Logger;

public class PlayerDemo {
    private static String className;
    private static Logger logger;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("dguitar.players.sound.midi.demo.PlayerDemo");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        className = clazz.toString();
        logger = Logger.getLogger(className);
    }

    public static void main(String[] args) {
        if (args.length != 1) {
            logger.severe("Syntax is PlayerDemo fileName");
        } else {
            PlayerDemo.playerDemo(args[0], new MidiPlayer(), new SystemLinePrinter());
        }
        System.exit(0);
    }

    public static void playerDemo(String fileName, SoundPlayer sp, LinePrinter out) {
        try {
            Song song = PlayerDemo.loadGPToSong(fileName);
            MasterPlayer player = new MasterPlayer();
            player.setSoundPlayer(sp);
            player.setTimerFrequency(4);
            player.enableNoteEvents(true);
            player.addTimerListener(new ExampleTimerListener(out));
            player.addEventListener(new ExampleEventListener(out));
            Arrangement arrangement = null;
            player.arrange(song, arrangement);
            player.start();
            player.waitForCompletion();
            player.close();
        }
        catch (GPFormatException e1) {
            logger.severe("gpformatexception");
        }
        catch (IOException e1) {
            logger.severe("ioexception");
        }
    }

    public static Song loadGPToSong(String fileName) throws GPFormatException, IOException {
        GPInputStream gpis = new GPInputStream(fileName);
        GPSong piece = (GPSong)gpis.readObject();
        gpis.close();
        Song song = GPAdaptor.makeSong(piece);
        return song;
    }
}

