/*
 * Decompiled with CFR 0.152.
 */
package dguitar.codecs.guitarPro;

import dguitar.codecs.CodecFileFilter;
import dguitar.codecs.CodecInputStream;
import dguitar.codecs.guitarPro.GPFormatException;
import dguitar.codecs.guitarPro.GPSong;
import dguitar.codecs.guitarPro.version1.GP1InputStream;
import dguitar.codecs.guitarPro.version2.GP2FormatException;
import dguitar.codecs.guitarPro.version2.GP2InputStream;
import dguitar.codecs.guitarPro.version3.GP3InputStream;
import dguitar.codecs.guitarPro.version4.GP4InputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;

public class GPInputStream
implements CodecInputStream {
    protected String __fileName;
    protected String __version;
    private CodecFileFilter _codecFileFilter;
    private InputStream _in;
    private int _offset;

    public GPInputStream(String fileName) throws FileNotFoundException {
        this(fileName, new FileInputStream(fileName));
    }

    public GPInputStream(File f) throws FileNotFoundException {
        this(f.getAbsolutePath(), new FileInputStream(f));
    }

    public GPInputStream(InputStream in) {
        this("", in);
    }

    private GPInputStream(String fileName, InputStream in) {
        this.__fileName = fileName;
        this.__version = "";
        this._codecFileFilter = null;
        this._in = in;
        this._offset = 0;
    }

    protected GPInputStream(GPInputStream gpIn) {
        this.__fileName = gpIn.__fileName;
        this.__version = gpIn.__version;
        this._codecFileFilter = gpIn._codecFileFilter;
        this._in = gpIn._in;
        this._offset = gpIn._offset;
    }

    public void close() throws IOException {
        this._in.close();
    }

    public int read() throws IOException {
        ++this._offset;
        return this._in.read();
    }

    public int read(byte[] b) throws IOException {
        this._offset += b.length;
        return this._in.read(b);
    }

    public Object readObject() throws IOException, GPFormatException {
        return this.readPiece();
    }

    public long skip(long n) throws IOException {
        return this._in.skip(n);
    }

    public boolean supportedExtension(String extension) {
        String[] list;
        boolean supported = false;
        if (extension != null && (list = (String[])this._codecFileFilter.getExtensions().toArray()) != null) {
            int i = 0;
            while (!supported && i < list.length) {
                supported = list[i].equalsIgnoreCase(extension);
                ++i;
            }
        }
        return supported;
    }

    protected void assertBytesEqualTo(int n, int v) throws IOException {
        byte[] b = new byte[n];
        this.read(b);
        int i = 0;
        while (i < n) {
            ++i;
        }
    }

    protected void dumpBytes(int n) throws IOException {
        int i = 0;
        while (i < n) {
            System.out.print(String.valueOf(this.readUnsignedByte()) + " ");
            ++i;
        }
        System.out.println();
    }

    protected void dumpInts(int n) throws IOException {
        int i = 0;
        while (i < n) {
            System.out.print(String.valueOf(this.readInt()) + " ");
            ++i;
        }
        System.out.println();
    }

    protected boolean readBoolean() throws IOException {
        return this.read() == 1;
    }

    protected byte readByte() throws IOException {
        return (byte)this.read();
    }

    protected double readDouble() throws IOException {
        return Double.longBitsToDouble(this.readLong());
    }

    protected float readFloat() throws IOException {
        return Float.intBitsToFloat(this.readInt());
    }

    protected int readInt() throws IOException {
        int integer = 0;
        byte[] b = new byte[4];
        this.read(b);
        integer = (b[3] & 0xFF) << 24 | (b[2] & 0xFF) << 16 | (b[1] & 0xFF) << 8 | b[0] & 0xFF;
        return integer;
    }

    protected long readLong() throws IOException {
        long longInt = 0L;
        byte[] b = new byte[8];
        this.read(b);
        longInt = (long)(b[7] & 0xFF) << 56 | (long)(b[6] & 0xFF) << 48 | (long)(b[5] & 0xFF) << 40 | (long)(b[4] & 0xFF) << 32 | (long)(b[3] & 0xFF) << 24 | (long)(b[2] & 0xFF) << 16 | (long)(b[1] & 0xFF) << 8 | (long)(b[0] & 0xFF);
        return longInt;
    }

    protected String readStringByte(int expectedLength) throws IOException {
        int realLength = this.readUnsignedByte();
        byte[] b = expectedLength != 0 ? new byte[expectedLength] : new byte[realLength];
        this.read(b);
        String str = new String(b, 0, realLength);
        return str;
    }

    protected String readStringInteger() throws IOException {
        int length = this.readInt();
        byte[] b = new byte[length];
        this.read(b);
        String str = new String(b);
        return str;
    }

    protected String readStringIntegerPlusOne() throws IOException {
        String str;
        int lengthPlusOne = this.readInt();
        int length = lengthPlusOne - 1;
        if (lengthPlusOne > 0) {
            int r = this.read();
            if (length != r) {
                throw new IOException("Wrong string length: should have been " + length);
            }
            byte[] b = new byte[length];
            this.read(b);
            str = new String(b);
        } else {
            int r = this.read();
            str = "";
        }
        return str;
    }

    protected String readStringByteMaxLengthPlusOne() throws IOException {
        int maxLength = this.readUnsignedByte() - 1;
        int length = this.readUnsignedByte();
        byte[] b = new byte[maxLength];
        this.read(b);
        String str = new String(b, 0, length);
        return str;
    }

    protected int readUnsignedByte() throws IOException {
        return this.read();
    }

    private GPSong readPiece() throws IOException, GPFormatException {
        this.__version = this.readStringByte(30);
        if (GP4InputStream.supportedVersion(this.__version)) {
            GP4InputStream is = new GP4InputStream(this);
            return is.readPiece();
        }
        if (GP3InputStream.supportedVersion(this.__version)) {
            GP3InputStream is = new GP3InputStream(this);
            return is.readPiece();
        }
        if (GP2InputStream.supportedVersion(this.__version)) {
            GP2InputStream is = new GP2InputStream(this);
            return is.readPiece();
        }
        if (GP1InputStream.supportedVersion(this.__version)) {
            GP1InputStream is = new GP1InputStream(this);
            return is.readPiece();
        }
        throw new GP2FormatException("Oops, unrecognized version: " + this.__version);
    }
}

