/*
** makedata_signal.h - Oblique Strategies from Signal header
**
** Copyright 1998, Lonnon Foster <lonnief@pobox.com>
** All rights reserved.
**
** The original Oblique Strategies are Copyright 1975, 78, 79
** by Brian Eno and Peter Schmidt.
**
** These Oblique Strategies originally appeared in "Signal: A whole
** earth catalog - Communication Tools for the Information Age
** (ed. Kevin Kelly, fwd by Stewart Brand, 1988, Harmony Books,
** p. 17).
**
** This program is free software; you can redistribute it and/or
** modify it under the terms of the GNU General Public License as
** published by the Free Software Foundation; either version 2 of the
** License, or (at your option) any later version.
**
** This program is distributed in the hope that it will be useful, but
** WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
** General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program (see LICENSE.TXT); if not, write to the
** Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139,
** USA.
**
** Created 30 June, 1998.  Last edited 7 July, 1998.  */

/* Resource constants */
#define makedataAppID   'LFmd'
#define obstratAppID    'LFos'
#define obstratDBType   'Data'
#define obstratVersion  01

/* Application prefs structure */
typedef struct 
{
    short CurrNo;  /* The current Oblique Strategy selected */
} ObStratPrefs;


/* Maximum number of Oblique Strategies and the length of the longest */
/*  one, plus terminating null */

#define MAXNO        26
#define MAXLINE      59

/* Oblique Strategies from Signal */

static char ObStrat[MAXNO][MAXLINE] =
{
    "Use an unacceptable color",
    "Remove ambiguities and convert to specifics",
    "Fill every beat with something",
    "Don't stress one thing more than another",
    "Ask people to work against their better judgement",
    "Call your mother and ask her what to do",
    "Humanize something that is free of error",
    "Breathe more deeply",
    "Do nothing for as long as possible",
    "Use 'unqualified' people",
    "Make a blank valuable by putting it in an exquisite frame",
    "Faced with a choice, do both",
    "Use fewer notes",
    "Get your neck massaged",
    "Remove specifics; convert to ambiguities",
    "Remove the middle, extend the edges",
    "[Picture of man spotlighted]",
    "Imagine the music as a series of disconnected events",
    "Take away the elements in order of apparent non-importance",
    "Discover the recipes you are using and abandon them",
    "Disconnect from desire",
    "Mechanize something idiosyncratic",
    "Do something boring",
    "Accept advice",
    "Pay attention to distractions",
    "Look closely at the most embarrassing details and amplify"
};
