/*
** makedata_lonnie.h - Oblique Strategies, Lonnie's list header
**
** Copyright 1998, Lonnon Foster <lonnief@pobox.com>
** All rights reserved.
**
** The original Oblique Strategies are Copyright 1975, 78, 79
** by Brian Eno and Peter Schmidt.
**
** This program is free software; you can redistribute it and/or
** modify it under the terms of the GNU General Public License as
** published by the Free Software Foundation; either version 2 of the
** License, or (at your option) any later version.
**
** This program is distributed in the hope that it will be useful, but
** WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
** General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program (see LICENSE.TXT); if not, write to the
** Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139,
** USA.
**
** Created 30 June, 1998.  Last edited 14 July, 1998.
*/

/* Resource constants */
#define makedataAppID   'LFmd'
#define obstratAppID    'LFos'
#define obstratDBType   'Data'
#define obstratVersion  01

/* Application prefs structure */
typedef struct 
{
    short CurrNo;  /* The current Oblique Strategy selected */
} ObStratPrefs;


/* Maximum number of Oblique Strategies and the max line length of each */

#define MAXNO        163
#define MAXLINE      128

/* Oblique Strategies editions 1-4, Eno's diary, and Signal, Lonnie's picks */

static char ObStrat[MAXNO][MAXLINE] =
{
    "(Organic) machinery",
    "A line has two sides",
    "Abandon desire",
    "Abandon normal instructions",
    "Accept advice",
    "Adding on",
    "Always first steps",
    "Ask people to work against their better judgement",
    "Ask your body",
    "Assemble some of the elements in a group and treat the group",
    "Back up a few steps.  What else could you have done?",
    "Be dirty",
    "Be extravagant",
    "Be less critical",
    "Breathe more deeply",
    "Bridges -build -burn",
    "Cascades",
    "Change ambiguities to specifics",
    "Change nothing and continue with immaculate consistency",
    "Change specifics to ambiguities",
    "Children -speaking -singing",
    "Cluster analysis",
    "Consider transitions",
    "Consult other sources -promising -unpromising",
    "Convert a melodic element into a rhythmic element",
    "Courage!",
    "Cut a vital connection",
    "Decorate, decorate",
    "Define an area as 'safe' and use it as an anchor",
    "Describe the landscape in which this belongs",
    "Destroy -nothing -the most important thing",
    "Discard an axiom",
    "Disciplined self-indulgence",
    "Discover your formulas and abandon them",
    "Display your talent",
    "Distort time",
    "Do nothing for as long as possible",
    "Do something boring",
    "Do something sudden, destructive and unpredictable",
    "Do the last thing first",
    "Do the washing up",
    "Do we need holes?",
    "Don't be afraid of things because they're easy to do",
    "Don't break the silence",
    "Don't stress one thing more than another",
    "Emphasize differences",
    "Emphasize repetitions",
    "Emphasize the flaws",
    "Faced with a choice, do both (given by Dieter Rot)",
    "Fill every beat with something",
    "First work alone, then work in unusual pairs",
    "From nothing to more than nothing",
    "Get your neck massaged",
    "Ghost echoes",
    "Give the game away",
    "Give way to your worst impulse",
    "Go outside.  Shut the door.",
    "Go slowly all the way round the outside",
    "Go to an extreme, come part way back",
    "Go to an extreme, move back to a more comfortable place",
    "Honor thy error as a hidden intention",
    "How would someone else do it?",
    "How would you explain this to your parents?",
    "How would you have done it?",
    "Idiot glee",
    "Imagine the piece as a set of disconnected events",
    "In total darkness, or in a very large room, very quietly",
    "Infinitesimal gradations",
    "Instead of changing the thing, change the world around it",
    "Intentions -nobility of -humility of -credibility of",
    "Into the impossible",
    "Is it finished?",
    "Is something missing?",
    "Is the style right?",
    "Is there something missing?",
    "It is simply a matter of work",
    "Just carry on",
    "Left channel, right channel, centre channel",
    "List the qualities it has.  List those you'd like.",
    "Listen to the quiet voice",
    "Look at a very small object, look at its centre",
    "Look at the order in which you do things",
    "Look closely at the most embarrassing details and amplify them",
    "Lost in useless territory",
    "Lowest common denominator",
    "Magnify the most difficult details",
    "Make a blank valuable by putting it in an exquisite frame",
    "Make an exhaustive list of everything you might do and do the last thing on the list",
    "Make it more sensual",
    "Make what's perfect more human",
    "Mechanize something idiosyncratic",
    "Mute and continue",
    "Not building a wall but making a brick",
    "Once the search has begun, something will be found",
    "Only a part, not the whole",
    "Only one element of each kind",
    "Overtly resist change",
    "Pay attention to distractions",
    "Put in earplugs",
    "Question the heroic",
    "Remember quiet evenings",
    "Remove a restriction",
    "Remove the middle, extend the edges",
    "Repetition is a form of change",
    "Retrace your steps",
    "Revaluation (a warm feeling)",
    "Reverse",
    "Short circuit (example; a man eating peas with the idea that they will improve his virility shovels them straight into his lap)",
    "Simple subtraction",
    "Simply a matter of work",
    "Slow preparation, fast execution",
    "Spectrum analysis",
    "State the problem in words as simply as possible",
    "Steal a solution",
    "Take a break",
    "Take away as much mystery as possible.  What is left?",
    "Take away the elements in order of apparent non-importance",
    "Take away the important parts",
    "The most important thing is the thing most easily forgotten",
    "The tape is now the music",
    "Think -inside the work -outside the work",
    "Think of the radio",
    "Tidy up",
    "Towards the insignificant",
    "Trust in the you of now",
    "Try faking it (from Stewart Brand)",
    "Turn it upside down",
    "Twist the spine",
    "Use 'unqualified' people",
    "Use an old idea",
    "Use an unacceptable color",
    "Use clichs",
    "Use filters",
    "Use something nearby as a model",
    "Use your own ideas",
    "Voice your suspicions",
    "Water",
    "What are the sections sections of?  Imagine a caterpillar moving",
    "What are you really thinking about just now?",
    "What context would look right?",
    "What do you do?  Now, what do you do best?",
    "What else is this like?",
    "What is the reality of the situation?",
    "What is the simplest solution?",
    "What mistakes did you make last time?",
    "What most recently impressed you?  How is it similar?  What can you learn from it?  What could you take from it?",
    "What to increase?  What to reduce?  What to maintain?",
    "What were the branch points in the evolution of this entity",
    "What were you really thinking about just now?",
    "What would make this really successful?",
    "What would your closest friend do?",
    "What wouldn't you do?",
    "When is it for?  Who is it for?",
    "Where is the edge?",
    "Which parts can be grouped?",
    "Who would make this really successful?",
    "Work at a different speed",
    "Would anyone want it?",
    "You are an engineer",
    "You can only make one dot at a time",
    "You don't have to be ashamed of using your own ideas",
    "[blank white card]",
    "[Picture of man spotlighted]"
};
