/*
** makedata_4.h - Oblique Strategies fourth edition header
**
** Copyright 1998, Lonnon Foster <lonnief@pobox.com>
** All rights reserved.
**
** The original Oblique Strategies are Copyright 1975, 78, 79
** by Brian Eno and Peter Schmidt.
**
** This program is free software; you can redistribute it and/or
** modify it under the terms of the GNU General Public License as
** published by the Free Software Foundation; either version 2 of the
** License, or (at your option) any later version.
**
** This program is distributed in the hope that it will be useful, but
** WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
** General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program (see LICENSE.TXT); if not, write to the
** Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139,
** USA.
**
** Created 30 June, 1998.  Last edited 7 July, 1998.
*/

/* Resource constants */
#define makedataAppID   'LFmd'
#define obstratAppID    'LFos'
#define obstratDBType   'Data'
#define obstratVersion  01

/* Application prefs structure */
typedef struct 
{
    short CurrNo;  /* The current Oblique Strategy selected */
} ObStratPrefs;


/* Maximum number of Oblique Strategies and the length of the longest */
/*  one, plus terminating null */

#define MAXNO        100
#define MAXLINE      57

/* Fourth edition Oblique Strategies */

static char ObStrat[MAXNO][MAXLINE] =
{
    "Abandon desire",
    "Abandon normal instructions",
    "Accept advice",
    "Adding on",
    "A line has two sides",
    "Always the first steps",
    "Ask people to work against their better judgement",
    "Ask your body",
    "Be dirty",
    "Be extravagant",
    "Be less critical",
    "Breathe more deeply",
    "Bridges -build -burn",
    "Change ambiguities to specifics",
    "Change nothing and continue consistently",
    "Change specifics to ambiguities",
    "Consider transitions",
    "Courage!",
    "Cut a vital connection",
    "Decorate, decorate",
    "Destroy nothing; Destroy the most important thing",
    "Discard an axiom",
    "Disciplined self-indulgence",
    "Discover your formulas and abandon them",
    "Display your talent",
    "Distort time",
    "Do nothing for as long as possible",
    "Don't avoid what is easy",
    "Don't break the silence",
    "Don't stress one thing more than another",
    "Do something boring",
    "Do something sudden, destructive and unpredictable",
    "Do the last thing first",
    "Do the words need changing?",
    "Emphasize differences",
    "Emphasize the flaws",
    "Faced with a choice, do both (from Dieter Rot)",
    "Find a safe part and use it as an anchor",
    "Give the game away",
    "Give way to your worst impulse",
    "Go outside.  Shut the door.",
    "Go to an extreme, come part way back",
    "How would someone else do it?",
    "How would you have done it?",
    "In total darkness, or in a very large room, very quietly",
    "Is it finished?",
    "Is something missing?",
    "Is the style right?",
    "It is simply a matter of work",
    "Just carry on",
    "Listen to the quiet voice",
    "Look at the order in which you do things",
    "Magnify the most difficult details",
    "Make it more sensual",
    "Make what's perfect more human",
    "Move towards the unimportant",
    "Not building a wall; making a brick",
    "Once the search has begun, something will be found",
    "Only a part, not the whole",
    "Only one element of each kind",
    "Openly resist change",
    "Pae White's non-blank graphic metacard",
    "Question the heroic",
    "Remember quiet evenings",
    "Remove a restriction",
    "Repetition is a form of change",
    "Retrace your steps",
    "Reverse",
    "Simple Subtraction",
    "Slow preparation, fast execution",
    "State the problem as clearly as possible",
    "Take a break",
    "Take away the important parts",
    "The inconsistency principle",
    "The most easily forgotten thing is the most important",
    "Think -inside the work -outside the work",
    "Tidy up",
    "Try faking it (from Stewart Brand)",
    "Turn it upside down",
    "Use an old idea",
    "Use clichs",
    "Use filters",
    "Use something nearby as a model",
    "Use 'unqualified' people",
    "Use your own ideas",
    "Voice your suspicions",
    "Water",
    "What context would look right?",
    "What is the simplest solution?",
    "What mistakes did you make last time?",
    "What to increase?  What to reduce?  What to maintain?",
    "What were you really thinking about just now?",
    "What wouldn't you do?",
    "What would your closest friend do?",
    "When is it for?",
    "Where is the edge?",
    "Which parts can be grouped?",
    "Work at a different speed",
    "Would anyone want it?",
    "Your mistake was a hidden intention"
};
