// level.h

// def's to simplify level design

// attributes
#define ATTRIB_ST    0xff   // start for path
#define ATTRIB_RV    0x80   // revesed for path & ice
#define ATTRIB_RT    0x80   // rotating for ventilator
#define ATTRIB_PT    PATH   // BOX with PATH under it

#define RPATH   (PATH      | 0x8000) // reverse
#define RICE    (ICE       | 0x8000) // reverse
#define NPATH   (PATH      | 0x4000) // unreverse
#define NICE    (ICE       | 0x4000) // unreverse
#define SW1     (SWITCH_ON | 0x0100)
#define SW2     (SWITCH_ON | 0x0200)
#define SW3     (SWITCH_ON | 0x0300)
#define SW4     (SWITCH_ON | 0x0400)
#define SW5     (SWITCH_ON | 0x0500)
#define KH1     (KEYHOLE   | 0x0100)
#define KH2     (KEYHOLE   | 0x0200)
#define KH3     (KEYHOLE   | 0x0300)
#define KH4     (KEYHOLE   | 0x0400)
#define KH5     (KEYHOLE   | 0x0500)
#define HDOOR1  (HDOOR_1   | 0x0100)
#define HDOOR2  (HDOOR_1   | 0x0200)
#define HDOOR3  (HDOOR_1   | 0x0300)
#define HDOOR4  (HDOOR_1   | 0x0400)
#define HDOOR5  (HDOOR_1   | 0x0500)
#define VENT    (HVENT_1   | 0x8000)
#define VENT1   (HVENT_1   | 0x8100)
#define VENT2   (HVENT_1   | 0x8200)
#define VENT3   (HVENT_1   | 0x8300)
#define VENT4   (HVENT_1   | 0x8400)
#define LOCH1   (SPACE     | 0x0100)
#define RLOCH1  (PATH      | 0x0100)
#define LOCH2   (SPACE     | 0x0200)
#define RLOCH2  (PATH      | 0x0200)
#define LOCH3   (SPACE     | 0x0300)
#define RLOCH3  (PATH      | 0x0300)
#define VDOOR1  (VDOOR_1   | 0x0100)
#define VDOOR2  (VDOOR_1   | 0x0200)
#define VDOOR3  (VDOOR_1   | 0x0300)
#define VDOOR4  (VDOOR_1   | 0x0400)
#define VDOOR5  (VDOOR_1   | 0x0500)
#define START   (PATH      | 0xff00)
#define DOC0    (DOC       | 0x0000)
#define DOC1    (DOC       | 0x0100)
#define DOC2    (DOC       | 0x0200)
#define DOC3    (DOC       | 0x0300)
#define DIC1_1  (DICE1     | 0x0100)
#define DIC2_1  (DICE2     | 0x0100)
#define DIC3_1  (DICE3     | 0x0100)
#define DIC4_1  (DICE4     | 0x0100)
#define DIC5_1  (DICE5     | 0x0100)
#define DIC6_1  (DICE6     | 0x0100)
#define DIC5_5  (DICE5     | 0x0500)
#define DIC6_5  (DICE6     | 0x0500)
#define BOXPTH  (BOX       | (PATH<<8))

// short versions
#define O START
#define S STONE
#define X GOAL
#define P PATH


