#include <stdio.h>
#include <ctype.h>

main(void) {
  FILE *in,*out,*hdr;
  char str[32],grey[4];
  int tile=0,i,last_was_raw=0;
  unsigned long data;

  in=fopen("tiles.dat","r");
  out=fopen("tiles.c","w");
  hdr=fopen("tiles.h","w");

  fprintf(out, "unsigned long tile[][16]={\n");
  fprintf(hdr, "extern unsigned long tile[][16];\n\n");

  while(fgets(str,32,in)!=NULL) {
    /* comment */
//    if(str[0]=='%') 
//      printf("processing:%s",&str[1]);

    /* grey table */
    if(str[0]=='C') { 
      for(i=0;i<4;i++) 
	grey[i]=str[i+1]; 
    }

    /* name */
    if(str[0]=='N') { 
      fprintf(hdr,"#define ");
      for(i=1;isalnum(str[i])||str[i]=='_';i++) 
	fprintf(hdr,"%c",str[i]);
      fprintf(hdr," 0x%02x\n",tile);
    }

    /* raw data */
    if((str[0]==grey[0])||(str[0]==grey[1])||
       (str[0]==grey[2])||(str[0]==grey[3])) {
      if(!last_was_raw) 
	fprintf(out,"%s{\n" ,(tile==0)?"":",");
      else
	fprintf(out,",\n");

      for(data=0l,i=0;i<16;i++) {
	data<<=2;
	if(str[i]==grey[1]) data|=0x01;
	if(str[i]==grey[2]) data|=0x02;
	if(str[i]==grey[3]) data|=0x03;
      }
      fprintf(out,"0x%08x",data);

      last_was_raw=1;
    } else {
      if(last_was_raw) { 
	fprintf(out,"}\n"); 
	tile++;
      }
      last_was_raw=0;
    }
  }

  if(last_was_raw) { 
    fprintf(out,"}\n"); 
    tile++;
  }

  fprintf(out, "\n};");
  fprintf(hdr, "#define NUM_OF_TILES %d\n", tile);

  fclose(hdr);
  fclose(out);
  fclose(in);

  return 0;
}


