#pragma pack(2)


/************************/
/***** Header Files *****/
/************************/
#include <Pilot.h>
#include <System/FeatureMgr.h>
#include "prefdb.h"
#include "freekey2.h"


#define Hack1ID 1000
#define Hack2ID 1001
#define HackSerialPortID 2001
#define HackModState 2002
#define HackKeymap 2003
#define HackKCOn 2004
#define HackLastKeydown 2005
#define HackLastChar 2006
#define HackSmartArrow 2007


/***** InitPrefDB *****/
void InitPrefDB( DmOpenRef dbref )
{
	FtrSet( HackCreatorID, HackSerialPortID, 0 );
	FtrSet( HackCreatorID, HackModState, 0 );
	FtrSet( HackCreatorID, HackKeymap, HackKeymapQWERTY );
	FtrSet( HackCreatorID, HackKCOn, 0 );
	FtrSet( HackCreatorID, HackLastKeydown, 0 );
}



/***** GetSerPortID *****/
UInt GetSerPortID( void )
{
	DWord value=0;
	FtrGet( HackCreatorID, HackSerialPortID, &value );
	return value;
}



/***** SetSerPortID *****/
void SetSerPortID( UInt serPortID )
{
	FtrSet( HackCreatorID, HackSerialPortID, serPortID );
}



/***** GetModState *****/
ULong GetModState( void )
{
	DWord value=0;
	FtrGet( HackCreatorID, HackModState, &value );
	return value;
}



/***** SetModState *****/
void SetModState( ULong modState )
{
	FtrSet( HackCreatorID, HackModState, modState );
}



/***** GetKeymap *****/
char GetKeymap( void )
{
	DWord value=0;
	FtrGet( HackCreatorID, HackKeymap, &value );
	return value;
}



/***** SetKeymap *****/
void SetKeymap( char keymap )
{
	FtrSet( HackCreatorID, HackKeymap, keymap );
}



/***** GetKeyClick *****/
char GetKeyClick( void )
{
	DWord value=0;
	FtrGet( HackCreatorID, HackKCOn, &value );
	return value;
}



/***** SetKeyClick *****/
void SetKeyClick( char keyClick )
{
	FtrSet( HackCreatorID, HackKCOn, keyClick );
}



/***** GetLastKeyDown *****/
// Note: Only 24 low-order bits of theTime are returned
void GetLastKeyDown( ULong *theTime, char *theChar )
{
	DWord value=0;
	FtrGet( HackCreatorID, HackLastKeydown, &value );
	*theTime = value;
	*theTime >>= 8;
	*theChar = (signed char) value&0xFF;
}



/***** SetLastKeyDown *****/
void SetLastKeyDown( ULong theTime, char theChar )
{
	ULong value,temp;
	theTime &= 0xFFFFFF;
	value = theTime << 8;
	temp = (ULong) theChar;
	temp &= 0xFF;
	value |= temp;
	FtrSet( HackCreatorID, HackLastKeydown, value );
}



/***** GetLastChar *****/
char GetLastChar( void )
{
	DWord value=0;
	FtrGet( HackCreatorID, HackLastChar, &value );
	return value;
}



/***** SetLastChar *****/
void SetLastChar( int lastChar )
{
	FtrSet( HackCreatorID, HackLastChar, lastChar );
}



/***** GetSmartArrow *****/
char GetSmartArrow( void )
{
	DWord value=0;
	FtrGet( HackCreatorID, HackSmartArrow, &value );
	return value;
}



/***** SetSmartArrow *****/
void SetSmartArrow( char smartArrow )
{
	FtrSet( HackCreatorID, HackSmartArrow, smartArrow );
}
