/*************************************************************************
 FreeKey.c
 
 Disclaimers and other legal stuff:
   This code is provided AS-IS; there is NO WARRANTY, express or implied.
   The user assumes full responsibility and liability for any use of
   this code.
 
   Copyright (C)1998 Nick Harvey
   All Rights Reserved by Nick Harvey, except as noted below.
 
   Permission to distribute this package complete and unmodified
   for personal use via the internet for no charge (other than reasonable
   connection charges) is granted to the public.
   Distribution for commercial purposes via any other medium, including but
   not limited to CD-ROM, floppy, or printed material, in whole or in part,
   requires express permission from Nick Harvey.
 
   Modified versions may be distributed with this notice intact, provided
   that said versions are clearly marked as modified code. The above
   provisions also apply to any such modified packages.
 
   Permission is also granted to the public to use PARTS of this code in
   other projects, with no special notice required unless the source code
   is part of the distribution, in which case this notice must remain
   conspicuous in the code that was used.
**************************************************************************/
#pragma pack(2)


/************************/
/***** Header Files *****/
/************************/
#include <Pilot.h>
#include <System/FeatureMgr.h>
#include <System/SystemMgr.h>
#include <System/SerialMgr.h>
#include <System/SysEvtMgr.h>
#include "freekey.h"
#include "freekey2.h"
#include "prefdb2.h"



/*******************/
/***** Globals *****/
/*******************/
static UInt gSerialRef;
static FieldPtr gTextField;
static ControlPtr gKBOnButton;
static ControlPtr gKBOffButton;
static ControlPtr gKCOnButton;
static ControlPtr gKCOffButton;
static ControlPtr gQWERTYButton;
static ControlPtr gDvorakButton;
//static ControlPtr gStandardButton;
//static ControlPtr gSmartButton;
static MenuBarPtr gCurMenu = NULL;
static char gKeymap;
static char gOn;
static char gKCOn;
static char gSmartArrow;



/*********************/
/***** Constants *****/
/*********************/
#define kSerPortNum 0
#define kSerPortBaud 9600
#define kSerPortFlags serSettingsFlagStopBits1 | serSettingsFlagBitsPerChar8\
	| serSettingsFlagCTSAutoM | serSettingsFlagRTSAutoM


/***********************************************
            To Do List

In progress:
 - Shortcut Keys

To Do: 
 - Shortcut to turn FreeKey on/off
 - Make the hack for up/down arrow SMARTER!
 - Customizable Hot keys! (Switch between apps, etc)
 - More keyboard layouts (in DB?)

Later Todo:
 - Flashing Icon if FreeKey is On
 - Fix the MenuCommand Status in FreeKey App
 - Customizable Layouts
 - Optimize for speed
 - Selecting text with Shift-Arrow
 - Key to hit "OK" buttons?
 - Japanese Input (via JOS)
 - Support for hw keys in games?
 - Fix the Icon for fkhack
 - Fix Flashing Graffiti Symbol
 - Take over the serial device =)

Done!:
 - Do global variables in a sensible way. (Store in database).
 - Save Prefs in DB
 - Fix Dvorak Map
 - Fix CapsLock
 - Foreign Characters
 - Clear Del key after Ctrl-Alt-Del
 - Typomatic keys
 - Prevent Power from shutting off
 - Change the Error dialog to an Info one when the port opens
 - Register the 'FrKy' Creator codes
 - Pass null events correctly
 - Dvorak Remapping
 - Get Command keys to work
 - Key Click
 - Timeout on the serial port (Shuts off when Sleeping (I THINK!))
 - Turn on Graffiti Shift/Caps Lock icons
 - Get Option keys to work
 - Special Graffiti characters (ie, Bullet, etc)
 - Hot key (CtlAltDel) to turn off serial port
************************************************/



/***** Error *****/
// Call SysFatalError instead?
void Error( char* str )
{
	FrmCustomAlert( ERROR_DLG_ID, str, NULL, NULL );
	return;
}


/***** Info *****/
void Info( char* str )
{
	FrmCustomAlert( INFO_DLG_ID, str, NULL, NULL );
	return;
}


/***** SetCurrentMenu *****/
static void SetCurrentMenu( Word rscId )
{
	// Dispose of an existing current menu.
	if( gCurMenu )
		MenuDispose( gCurMenu );
	
	// Set the current menu and remember it.
	gCurMenu = MenuInit( rscId );
}


/***** MainFormInit *****/
// Called when the main form receives an frmOpenEvent
static void MainFormInit( void )
{
	FormPtr pMe;
	pMe = FrmGetActiveForm();

	// Call FrmSetFocus to set focus to the text field
	FrmSetFocus( pMe, FrmGetObjectIndex( pMe, TEXT_FIELD_ID ) );

	gKBOnButton = (ControlPtr) FrmGetObjectPtr( pMe,
		FrmGetObjectIndex( pMe, KBON_BUTTON_ID ) );
	gKBOffButton = (ControlPtr) FrmGetObjectPtr( pMe,
		FrmGetObjectIndex( pMe, KBOFF_BUTTON_ID ) );
	gKCOnButton = (ControlPtr) FrmGetObjectPtr( pMe,
		FrmGetObjectIndex( pMe, KCON_BUTTON_ID ) );
	gKCOffButton = (ControlPtr) FrmGetObjectPtr( pMe,
		FrmGetObjectIndex( pMe, KCOFF_BUTTON_ID ) );
	gQWERTYButton = (ControlPtr) FrmGetObjectPtr( pMe,
		FrmGetObjectIndex( pMe, QWERTY_BUTTON_ID ) );
	gDvorakButton = (ControlPtr) FrmGetObjectPtr( pMe,
		FrmGetObjectIndex( pMe, DVORAK_BUTTON_ID ) );
	/*
	gStandardButton = (ControlPtr) FrmGetObjectPtr( pMe,
		FrmGetObjectIndex( pMe, STANDARD_BUTTON_ID ) );
	gSmartButton = (ControlPtr) FrmGetObjectPtr( pMe,
		FrmGetObjectIndex( pMe, SMART_BUTTON_ID ) );
	*/

	if( gOn )
		CtlSetValue( gKBOnButton, true );
	else 
		CtlSetValue( gKBOffButton, true );

	if( gKCOn )
		CtlSetValue( gKCOnButton, true );
	else 
		CtlSetValue( gKCOffButton, true );

	if( gKeymap==HackKeymapDvorak )
		CtlSetValue( gDvorakButton, true );
	else if( gKeymap==HackKeymapQWERTY )
		CtlSetValue( gQWERTYButton, true );

	/*
	if( gSmartArrow )
		CtlSetValue( gSmartButton, true );
	else 
		CtlSetValue( gStandardButton, true );
	*/

	FrmDrawForm( pMe );

	gTextField = (FieldPtr) FrmGetObjectPtr( pMe, 
		FrmGetObjectIndex( pMe, TEXT_FIELD_ID ) );
	FldDrawField( gTextField );

	SetCurrentMenu( MENU_BAR_ID );
}


/***** HandleMenuEvent *****/
static void HandleMenuEvent( EventPtr event )
{

	switch( event->data.menu.itemID )
	{
		case ABOUT_ITEM_ID:
			MenuEraseStatus( gCurMenu );
			FrmPopupForm( ABOUT_ID );
			break;

		case HELP_ITEM_ID:
			FrmHelp( ABOUT_ID );
			break;

		case CUT_ITEM_ID:
			FldCut( gTextField );
			break;

		case COPY_ITEM_ID:
			FldCopy( gTextField );
			break;

		case PASTE_ITEM_ID:
			FldPaste( gTextField );
			break;
	}
}


/***** SerPortOn *****/
// Turn on the serial port, and store its id with the feature manager
// so that the hack can use it
void SerPortOn( void )
{
	int err;
	SerSettingsType serSet;


	// Read the serial ref from the database
	gSerialRef = GetSerPortID();
	if( gSerialRef )
	{
		//Error( "FreeKey is already on!" );
		return;
	}


	// Open up the serial port
	err = SysLibFind( "Serial Library", &gSerialRef );
	if( err )
	{
		Error( "SysLibFind failed for Serial Library" );
		return;
	}
	err = SerOpen( gSerialRef, kSerPortNum, kSerPortBaud );
	switch( err )
	{
		case 0:
			SndPlaySystemSound( sndStartUp );
			break;

		case serErrAlreadyOpen:
			SerClose( gSerialRef );
			/* Fall Through */

		default:
			Error( "SerOpen failed" );
			return;
	}

	
	serSet.baudRate = kSerPortBaud;
	serSet.flags = kSerPortFlags;
	serSet.ctsTimeout = serDefaultCTSTimeout;

	err = SerSetSettings( gSerialRef, &serSet );
	if( err )
	{
		SerClearErr( gSerialRef );
		Error( "SerSetSettings failed" );
		return;
	}

	// Store this in the database
	SetSerPortID( gSerialRef );

	//Info( "FreeKey is now on" );
}


/***** SerPortOff *****/
void SerPortOff( void )
{
	int err;


	// Get the serial port state
	gSerialRef = GetSerPortID();
	if( gSerialRef == 0 )
	{
		//Error( "FreeKey is already off!" );
		return;
	}


	SetSerPortID( 0 );
	err = SerClose( gSerialRef );
	if( err )
	{
		Error( "SerClose Failed! You should probably reset your Pilot" );
		return;
	}


	gSerialRef = 0;
	//Info( "FreeKey is now off" );
}


/***** HandleMainFormEvent *****/
// This is the event manager for the main form
static Boolean HandleMainFormEvent( EventPtr event )
{
    switch( event->eType )
	{
		case frmOpenEvent:
			MainFormInit();
			return true;

		case ctlSelectEvent:
			if( event->data.ctlSelect.controlID == KBON_BUTTON_ID )
			{
				SerPortOn();
				return true;
			}
			if( event->data.ctlSelect.controlID == KBOFF_BUTTON_ID )
			{
				SerPortOff();
				return true;
			}
			if( event->data.ctlSelect.controlID == KCON_BUTTON_ID )
			{
				gKCOn = 1;
				SetKeyClick( gKCOn );
				return true;
			}
			if( event->data.ctlSelect.controlID == KCOFF_BUTTON_ID )
			{
				gKCOn = 0;
				SetKeyClick( gKCOn );
				return true;
			}
			if( event->data.ctlSelect.controlID == QWERTY_BUTTON_ID )
			{
				gKeymap = HackKeymapQWERTY;
				SetKeymap( gKeymap );
				return true;
			}
			if( event->data.ctlSelect.controlID == DVORAK_BUTTON_ID )
			{
				gKeymap = HackKeymapDvorak;
				SetKeymap( gKeymap );
				return true;
			}
			if( event->data.ctlSelect.controlID == STANDARD_BUTTON_ID )
			{
				gSmartArrow = 0;
				SetSmartArrow( false );
				return true;
			}
			if( event->data.ctlSelect.controlID == SMART_BUTTON_ID )
			{
				gSmartArrow = 1;
				SetSmartArrow( true );
				return true;
			}
			break;

		case menuEvent:
			HandleMenuEvent( event );
			return true;

		default:
			break;
    }

    return false;
}


/***** AboutFormHandler *****/
Boolean AboutFormHandler( EventPtr pevt )
{
	switch( pevt->eType )
	{
		case frmOpenEvent:
			FrmDrawForm( FrmGetActiveForm() );
			return true;

		case ctlSelectEvent:
			FrmReturnToForm( 0 );
			// Fall through

		default:
			return false;
	}
}


/***** HandleAppEvent *****/
// This is called if an event is not first handled by the system
static Boolean HandleAppEvent( EventPtr event )
{
    FormPtr form;

    if( event->eType == frmLoadEvent )
	{
		form = FrmInitForm( event->data.frmLoad.formID );
		FrmSetActiveForm( form );

		switch( event->data.frmLoad.formID )
		{
			case MAIN_FORM_ID:
				FrmSetEventHandler( form, HandleMainFormEvent );
				break;

			case ABOUT_ID:
				FrmSetEventHandler( form, AboutFormHandler );
				break;
		}
		return true;
    }
    return false;
}


/***** EventLoop *****/
// This is where we loop, getting all our events
static void EventLoop( void )
{
    EventType event;
    Word error;
	//char  theStr[30];
	//RectangleType rect;

    do {
		EvtGetEvent( &event, evtWaitForever );


		/* For testing - Print Key events as they are generated 
		if( event.eType == keyDownEvent )
		{
			rect.topLeft.x = 10;
			rect.topLeft.y = 18;
			rect.extent.x = 120;
			rect.extent.y = 10;
			WinEraseRectangle( &rect, 0 );
			StrIToA( theStr, event.data.keyDown.chr );
			WinDrawChars( theStr, StrLen(theStr), 10, 18 );
			StrIToA( theStr, event.data.keyDown.keyCode );
			WinDrawChars( theStr, StrLen(theStr), 50, 18 );
			StrIToA( theStr, event.data.keyDown.modifiers );
			WinDrawChars( theStr, StrLen(theStr), 90, 18 );
		}
		*/

		if( SysHandleEvent( &event ) == false
			&& MenuHandleEvent( gCurMenu, &event, &error ) == false
			&& HandleAppEvent( &event ) == false )
		{
			FrmDispatchEvent( &event );
		}

    } while( event.eType != appStopEvent );
}


/***** StartApplication *****/
// This is called when we are launched
Word StartApplication( void )
{
	FrmGotoForm( MAIN_FORM_ID );

	// Read the volatile preferences
	gOn = GetSerPortID();
	
	// Read the nonvolatile preferences
	gKeymap = GetKeymap();
	gKCOn = GetKeyClick();
	//gSmartArrow = GetSmartArrow();

	return 0;
}


/***** StopApplication *****/
// This is called when we exit
Word StopApplication( void )
{
	FrmSaveAllForms();
	FrmCloseAllForms();

	return 0;
}


/***** PilotMain *****/
DWord PilotMain( Word cmd, Ptr cmdPBP, Word launchFlags )
{
	Word error;
	
    if( cmd == sysAppLaunchCmdNormalLaunch )
	{
		error = StartApplication();
		if( error )
			return error;

		EventLoop();

		error = StopApplication();
		if( error )
			return error;
    }
	else
	{
		// Some other launch command that we don't understand, i.e. one from
		// when the Pilot is reset, or something.
	}


    return 0;
}
