/*************************************************************************
 hack1.c
 
 Disclaimers and other legal stuff:
   This code is provided AS-IS; there is NO WARRANTY, express or implied.
   The user assumes full responsibility and liability for any use of
   this code.
 
   Copyright (C)1998 Nick Harvey
   All Rights Reserved by Nick Harvey, except as noted below.
 
   Permission to distribute this package complete and unmodified
   for personal use via the internet for no charge (other than reasonable
   connection charges) is granted to the public.
   Distribution for commercial purposes via any other medium, including but
   not limited to CD-ROM, floppy, or printed material, in whole or in part,
   requires express permission from Nick Harvey.
 
   Modified versions may be distributed with this notice intact, provided
   that said versions are clearly marked as modified code. The above
   provisions also apply to any such modified packages.
 
   Permission is also granted to the public to use PARTS of this code in
   other projects, with no special notice required unless the source code
   is part of the distribution, in which case this notice must remain
   conspicuous in the code that was used.
**************************************************************************/
#pragma pack(2)



/************************/
/***** Header Files *****/
/************************/
#include <Pilot.h>
#include <System/Graffiti.h>
#include <System/FeatureMgr.h>
#include <System/SerialMgr.h>
#include <System/SysEvtMgr.h>
#include <System/SystemMgr.h>
#include "keys.h"
#include "../freekey/freekey2.h"
#include "../freekey/prefdb2.h"



/*********************/
/***** Constants *****/
/*********************/
#define kSleepTime 10
#define kKeyRptThresh 40

// For reading the modifier state
#define LShiftMask 1
#define RShiftMask 2
#define CapsMask 4
#define CtlMask 8
#define OptMask 16
#define AppMask 32

// If you want to have the graffiti arrow show up when the shift key is held
// down, set ShowShiftSymbol to 1. If it is set to 0, only the caps
// lock indicator shows up.
#define ShowShiftSymbol 0



/***** LaunchCustom *****/
void LaunchCustom( int which )
{
	DmSearchStateType sst;
	UInt              iCardDB;
	LocalID           idDB;
	ULong idApp;

	switch( which )
	{
		case -1:
			idApp = HackCreatorID;
			break;
		default:
			return;
	}

	DmGetNextDatabaseByTypeCreator( true, &sst, (ULong)'appl',
								   idApp, true, &iCardDB, &idDB );
	SysUIAppSwitch( iCardDB, idDB, sysAppLaunchCmdNormalLaunch, 0 );
}



/***** HandleModifierKeys *****/
// Read the current modifier state from the database, update it if the
// current keystroke was a modifier key, write it back to the database, and
// return the modifier map.
DWord HandleModifierKeys( signed char keyCode )
{
	DWord mod;
	int err;


	// Get the modifier states
	mod = GetModState();
	
	switch( (int) keyCode )
	{
		case LShiftDn:
			mod |= LShiftMask;
			break;
		case LShiftUp:
			mod &= ~LShiftMask;
			break;
		case RShiftDn:
			mod |= RShiftMask;
			break;
		case RShiftUp:
			mod &= ~RShiftMask;
			break;
		case CapsDn:
			mod ^= CapsMask;
			break;
		case CtlDn:
			mod |= CtlMask;
			break;
		case CtlUp:
			mod &= ~CtlMask;
			break;
		case OptDn:
			mod |= OptMask;
			break;
		case OptUp:
			mod &= ~OptMask;
			break;
		case AppDn:
			mod |= AppMask;
			break;
		case AppUp:
			mod &= ~AppMask;
			break;
	}

	// Write the modifier state back to the database
	SetModState( mod );

	return mod;
}



/***** UpdateGraffitiStatus *****/
// Update the Graffiti Status Indicator
void UpdateGraffitiStatus( char capsDown, char shiftDown )
{
	DWord temp=0;
	if( ShowShiftSymbol ) temp = shiftDown;
	if( capsDown ) temp = 0;
	GrfSetState( capsDown, false, temp );
}



/***** ClearLastKeydown *****/
// Forget the last keystroke as stored in the database
void ClearLastKeydown( void )
{
	SetLastKeyDown( 0, 0 );
}



/***** RememberKeyAndTime *****/
// Save 24 bits of the time and the keycode in the database
void RememberKeyAndTime( signed char keycode )
{
	ULong theTime;

	theTime = TimGetTicks();
	SetLastKeyDown( theTime, keycode );
}



/***** GetCurKeymap *****/
// Read the current keymap from the database
int GetCurKeymap( void )
{
	DWord keymap;

	keymap = GetKeymap();
	return keymap;
}


#if 0

/***** UpArrowHack *****/
// This is a big hack. No explanation for now.
int UpArrowHack( void )
{
	FormPtr			curForm;
	Word			curFocus;
	FormObjectKind	kind;
	FieldPtr		curFld;
	Word			startPosn, lineOffset, newPosn, textLen, visLines;
	LineInfoPtr		lineInfo;
	CharPtr			text;
	int				i;

	if( (curForm=FrmGetActiveForm()) == NULL ) return PageUpChar;
	if( (curFocus=FrmGetFocus(curForm)) == -1 ) return PageUpChar;
	if( (kind=FrmGetObjectType(curForm,curFocus)) != frmFieldObj )
		return PageUpChar;
	if( ! (curFld=(FieldPtr)FrmGetObjectPtr(curForm,curFocus)) )
		return PageUpChar;
	if( ! (text = FldGetTextPtr(curFld)) ) return PageUpChar;
	if( ! (lineInfo = curFld->lines) ) return PageUpChar;
	startPosn = FldGetInsPtPosition( curFld );
	visLines = FldGetVisibleLines( curFld );
	textLen = curFld->textLen;

	i=0;
	while( lineInfo[i].start+lineInfo[i].length-1 < startPosn )
		i++;

	if( i == 0 ) {
		FldScrollField( curFld, visLines/2, up );
		FldSendChangeNotification( curFld );
		i=0;
		while( lineInfo[i].start+lineInfo[i].length-1 < startPosn )
			i++;
		if( i==0 )
		{
			FldSetInsPtPosition( curFld, 0 );
			return 0;
		}
	}

	lineOffset = startPosn - lineInfo[i].start;
	if( lineOffset > lineInfo[i-1].length )
		newPosn = lineInfo[i-1].start+lineInfo[i-1].length-1;
	else
		newPosn = lineInfo[i-1].start+lineOffset;
	FldSetInsPtPosition( curFld, newPosn );
	if( lineOffset==0 && i>1 && text[newPosn-1]!=10 )
		EvtEnqueueKey( RArrowChar, 0, 0 );

	return 0;
}



/***** DnArrowHack *****/
// This is a big hack. No explanation for now.
int DnArrowHack( void )
{
	FormPtr			curForm;
	Word			curFocus;
	FormObjectKind	kind;
	FieldPtr		curFld;
	Word			startPosn, lineOffset, newPosn, textLen, visLines;
	LineInfoPtr		lineInfo;
	CharPtr			text;
	int				i;

	if( (curForm=FrmGetActiveForm()) == NULL ) return PageDnChar;
	if( (curFocus=FrmGetFocus(curForm)) == -1 ) return PageDnChar;
	if( (kind=FrmGetObjectType(curForm,curFocus)) != frmFieldObj )
		return PageDnChar;
	if( ! (curFld=(FieldPtr)FrmGetObjectPtr(curForm,curFocus)) )
		return PageDnChar;
	if( ! (text = FldGetTextPtr(curFld)) ) return PageDnChar;
	if( ! (lineInfo = curFld->lines) ) return PageDnChar;
	startPosn = FldGetInsPtPosition( curFld );
	visLines = FldGetVisibleLines( curFld );
	textLen = curFld->textLen;

	i=0;
	while( lineInfo[i].start+lineInfo[i].length-1 < startPosn )
		i++;

	if( i >= visLines )
		return;
	if( i == visLines-1 ) {
		if( lineInfo[i].start+lineInfo[i].length >= textLen ) {
			FldSetInsPtPosition( curFld, textLen );
			return 0;
		}
		FldScrollField( curFld, visLines/2, down );
		FldSendChangeNotification( curFld );
		i=0;
		while( lineInfo[i].start+lineInfo[i].length-1 < startPosn )
			i++;
		if( i >= visLines )
			return 0;
		if( i == visLines-1 )
		{
			FldSetInsPtPosition( curFld, textLen );
			return 0;
		}
		if( lineInfo[i].start+lineInfo[i].length >= textLen ) {
			FldSetInsPtPosition( curFld, textLen );
			return 0;
		}
	}

	lineOffset = startPosn - lineInfo[i].start;
	if( lineOffset > lineInfo[i+1].length )
		newPosn = lineInfo[i+1].start+lineInfo[i+1].length-1;
	else
		newPosn = lineInfo[i+1].start+lineOffset;
	FldSetInsPtPosition( curFld, newPosn );
	if( lineOffset==0 && text[newPosn-1]!=10 )
		EvtEnqueueKey( RArrowChar, 0, 0 );

	return 0;
}

#endif


/***** UpArrow *****/
int UpArrow( void )
{
	FormPtr			curForm;
	Word			curFocus;
	FormObjectKind	kind;
	FieldPtr		curFld;

	if( (curForm=FrmGetActiveForm()) == NULL ) return PageUpChar;
	if( (curFocus=FrmGetFocus(curForm)) == -1 ) return PageUpChar;
	if( (kind=FrmGetObjectType(curForm,curFocus)) != frmFieldObj )
		return PageUpChar;
	if( ! (curFld=(FieldPtr)FrmGetObjectPtr(curForm,curFocus)) )
		return PageUpChar;

	//FldSendChangeNotification( curFld );
	return 30;
}


/***** DnArrow *****/
int DnArrow( void )
{
	FormPtr			curForm;
	Word			curFocus;
	FormObjectKind	kind;
	FieldPtr		curFld;

	if( (curForm=FrmGetActiveForm()) == NULL ) return PageDnChar;
	if( (curFocus=FrmGetFocus(curForm)) == -1 ) return PageDnChar;
	if( (kind=FrmGetObjectType(curForm,curFocus)) != frmFieldObj )
		return PageDnChar;
	if( ! (curFld=(FieldPtr)FrmGetObjectPtr(curForm,curFocus)) )
		return PageDnChar;

	//FldSendChangeNotification( curFld );
	return 31;
}


/***** HandleArrowKeys *****/
// If the keycode was an arrow key, convert it to the appropriate
// character, and return it. If not, return 0.
// Note: Doesn't matter if we're in QWERTY or Dvorak here.
int HandleArrowKeys( signed char keyCode, ULong mod )
{
	int theChar=0;

	switch( keyCode )
	{
		case LArrowDn:
			theChar = LArrowChar;
			break;

		case RArrowDn:
			theChar = RArrowChar;
			break;

		case UArrowDn:
			if( mod&OptMask )
			{
				if( mod&LShiftMask || mod&RShiftMask )
					theChar = PrevFieldChar;
				else
					theChar = PageUpChar;
			}
			else
				/*
				if( GetSmartArrow( rec ) )
					theChar = UpArrowHack();
				else
					*/
				theChar = UpArrow();
			break;

		case DArrowDn:
			if( mod&OptMask )
			{
				if( mod&LShiftMask || mod&RShiftMask )
					theChar = NextFieldChar;
				else
					theChar = PageDnChar;
			}
			else
				/*
				if( GetSmartArrow( rec ) )
					theChar = DnArrowHack();
				else
					*/
					theChar = DnArrow();
			break;
	};

	return theChar;
}



/***** ClearModifiers *****/
// Clear the modifiers bitmap in the database
void ClearModifiers( void )
{
	SetModState( 0 );
}



/***** HandleQWERTYControl *****/
// Handle stuff if we're in QWERTY mode and Control is down
int HandleQWERTYControl( int negKeyCode, ULong mod )
{
	int theChar=0;

	if( mod&OptMask )
		switch( negKeyCode )
		{
			case 77:
				theChar = PowerChar;
				ClearModifiers();
				ClearLastKeydown();
				mod = 0;
				break;
		}
	else
		switch( negKeyCode )
		{
			case 78:
				LaunchCustom(-1);
				break;
			case 79:
				theChar = KeyboardChar;
				break;
			case 82:
				theChar = MenuChar;
				break;
			case 99:
				LaunchCustom(5);
				break;
			case 100:
				LaunchCustom(3);
				break;
			case 102:
				LaunchCustom(2);
				break;
			case 103:
				LaunchCustom(4);
				break;
			case 105:
				LaunchCustom(0);
				break;
			case 106:
				LaunchCustom(1);
				break;
			case 107:
				theChar = HWKey4Char;
				break;
			case 108:
				theChar = HWKey3Char;
				break;
			case 109:
				theChar = HWKey2Char;
				break;
			case 110:
				theChar = HWKey1Char;
				break;
			case 120:
				theChar = CalcChar;
				break;
			case 125:
				theChar = FindChar;
				break;
			case 128:
				theChar = AppsChar;
				break;
		}

	return theChar;
}



/***** HandleDvorakControl *****/
// Handle stuff if we're in Dvorak mode and Control is down
int HandleDvorakControl( int negKeyCode, ULong mod )
{
	int theChar=0;

	if( mod&OptMask )
		switch( negKeyCode )
		{
			case 77:	// Backspace
				theChar = PowerChar;
				ClearModifiers();
				ClearLastKeydown();
				mod = 0;
				break;
		}
	else
		switch( negKeyCode )
		{
			case 78:	// ~
				LaunchCustom(-1);
				break;
			case 79:	// Space
				theChar = KeyboardChar;
				break;
			case 82:	// M
				theChar = MenuChar;
				break;
			case 99:
				LaunchCustom(5);
				break;
			case 100:
				LaunchCustom(3);
				break;
			case 102:
				LaunchCustom(2);
				break;
			case 103:
				LaunchCustom(4);
				break;
			case 105:
				LaunchCustom(0);
				break;
			case 106:
				LaunchCustom(1);
				break;
			case 107:
				theChar = HWKey4Char;
				break;
			case 108:
				theChar = HWKey3Char;
				break;
			case 109:
				theChar = HWKey2Char;
				break;
			case 110:
				theChar = HWKey1Char;
				break;
			case 94:	// c
				theChar = CalcChar;
				break;
			case 112:	// f
				theChar = FindChar;
				break;
			case 128:	// a
				theChar = AppsChar;
				break;
		}

	return theChar;
}



/***** HandleForeignShfDvorak *****/
int HandleForeignShfDvorak( int keyCode )
{
	int lastChar = GetLastChar();
	int newChar = 0;

	switch( keyCode )
	{
		// Circon
		case 106:
			switch( lastChar )
			{
				case 'A': newChar = CapitalACircon; break;
				case 'E': newChar = CapitalECircon; break;
				case 'I': newChar = CapitalICircon; break;
				case 'O': newChar = CapitalOCircon; break;
				case 'U': newChar = CapitalUCircon; break;
				case 'a': newChar = ACircon; break;
				case 'e': newChar = ECircon; break;
				case 'i': newChar = ICircon; break;
				case 'o': newChar = OCircon; break;
				case 'u': newChar = UCircon; break;
			}
			if( newChar ) EvtEnqueueKey( BackSpaceChar, 0, 0 );
			break;
			
		// Tilde
		case 78:
			switch( lastChar )
			{
				case 'A': newChar = CapitalATilde; break;
				case 'N': newChar = CapitalNTilde; break;
				case 'O': newChar = CapitalOTilde; break;
				case 'a': newChar = ATilde; break;
				case 'n': newChar = NTilde; break;
				case 'o': newChar = OTilde; break;
			}
			if( newChar ) EvtEnqueueKey( BackSpaceChar, 0, 0 );
			break;
			
		// Trema
		case 122:
			switch( lastChar )
			{
				case 'A': newChar = CapitalATrema; break;
				case 'E': newChar = CapitalETrema; break;
				case 'I': newChar = CapitalITrema; break;
				case 'O': newChar = CapitalOTrema; break;
				case 'U': newChar = CapitalUTrema; break;
				case 'a': newChar = ATrema; break;
				case 'e': newChar = ETrema; break;
				case 'i': newChar = ITrema; break;
				case 'o': newChar = OTrema; break;
				case 'u': newChar = UTrema; break;
			}
			if( newChar ) EvtEnqueueKey( BackSpaceChar, 0, 0 );
			break;

		// Upside Down !
		case 110:
			newChar = UpsideDownBang;
			break;

		// Upside Down ?
		case 95:
			newChar = UpsideDownQuestion;
			break;

		// C Cedilla
		case 94:
			newChar = CapitalCCedillaChar;
			break;

		// AE
		case 128:
			newChar = CapitalAEChar;
			break;
	}
			
	return newChar;
}



/***** HandleForeignDvorak *****/
int HandleForeignDvorak( int keyCode )
{
	int lastChar = GetLastChar();
	int newChar = 0;

	switch( keyCode )
	{
		// Grave
		case 78:
			switch( lastChar )
			{
				case 'A': newChar = CapitalAGrave; break;
				case 'E': newChar = CapitalEGrave; break;
				case 'I': newChar = CapitalIGrave; break;
				case 'O': newChar = CapitalOGrave; break;
				case 'U': newChar = CapitalUGrave; break;
				case 'a': newChar = AGrave; break;
				case 'e': newChar = EGrave; break;
				case 'i': newChar = IGrave; break;
				case 'o': newChar = OGrave; break;
				case 'u': newChar = UGrave; break;
			}
			if( newChar ) EvtEnqueueKey( BackSpaceChar, 0, 0 );
			break;

		// Aigu
		case 116:
			switch( lastChar )
			{
				case 'A': newChar = CapitalAAigu; break;
				case 'E': newChar = CapitalEAigu; break;
				case 'I': newChar = CapitalIAigu; break;
				case 'O': newChar = CapitalOAigu; break;
				case 'U': newChar = CapitalUAigu; break;
				case 'a': newChar = AAigu; break;
				case 'e': newChar = EAigu; break;
				case 'i': newChar = IAigu; break;
				case 'o': newChar = OAigu; break;
				case 'u': newChar = UAigu; break;
			}
			if( newChar ) EvtEnqueueKey( BackSpaceChar, 0, 0 );
			break;

		// Dot
		case 114:
			switch( lastChar )
			{
				case 'A': newChar = CapitalADot; break;
				case 'a': newChar = ADot; break;
			}
			if( newChar ) EvtEnqueueKey( BackSpaceChar, 0, 0 );
			break;

	}

	return newChar;
}



/***** HandleForeignShfQWERTY *****/
int HandleForeignShfQWERTY( int keyCode )
{
	int lastChar = GetLastChar();
	int newChar = 0;

	switch( keyCode )
	{
		// Circon
		case 106:
			switch( lastChar )
			{
				case 'A': newChar = CapitalACircon; break;
				case 'E': newChar = CapitalECircon; break;
				case 'I': newChar = CapitalICircon; break;
				case 'O': newChar = CapitalOCircon; break;
				case 'U': newChar = CapitalUCircon; break;
				case 'a': newChar = ACircon; break;
				case 'e': newChar = ECircon; break;
				case 'i': newChar = ICircon; break;
				case 'o': newChar = OCircon; break;
				case 'u': newChar = UCircon; break;
			}
			if( newChar ) EvtEnqueueKey( BackSpaceChar, 0, 0 );
			break;
			
		// Tilde
		case 78:
			switch( lastChar )
			{
				case 'A': newChar = CapitalATilde; break;
				case 'N': newChar = CapitalNTilde; break;
				case 'O': newChar = CapitalOTilde; break;
				case 'a': newChar = ATilde; break;
				case 'n': newChar = NTilde; break;
				case 'o': newChar = OTilde; break;
			}
			if( newChar ) EvtEnqueueKey( BackSpaceChar, 0, 0 );
			break;
			
		// Trema
		case 87:
			switch( lastChar )
			{
				case 'A': newChar = CapitalATrema; break;
				case 'E': newChar = CapitalETrema; break;
				case 'I': newChar = CapitalITrema; break;
				case 'O': newChar = CapitalOTrema; break;
				case 'U': newChar = CapitalUTrema; break;
				case 'a': newChar = ATrema; break;
				case 'e': newChar = ETrema; break;
				case 'i': newChar = ITrema; break;
				case 'o': newChar = OTrema; break;
				case 'u': newChar = UTrema; break;
			}
			if( newChar ) EvtEnqueueKey( BackSpaceChar, 0, 0 );
			break;

		// Upside Down !
		case 110:
			newChar = UpsideDownBang;
			break;

		// Upside Down ?
		case 84:
			newChar = UpsideDownQuestion;
			break;

		// C Cedilla
		case 120:
			newChar = CapitalCCedillaChar;
			break;

		// AE
		case 128:
			newChar = CapitalAEChar;
			break;
	}
			
	return newChar;
}



/***** HandleForeignQWERTY *****/
int HandleForeignQWERTY( int keyCode )
{
	int lastChar = GetLastChar();
	int newChar = 0;

	switch( keyCode )
	{
		// Grave
		case 78:
			switch( lastChar )
			{
				case 'A': newChar = CapitalAGrave; break;
				case 'E': newChar = CapitalEGrave; break;
				case 'I': newChar = CapitalIGrave; break;
				case 'O': newChar = CapitalOGrave; break;
				case 'U': newChar = CapitalUGrave; break;
				case 'a': newChar = AGrave; break;
				case 'e': newChar = EGrave; break;
				case 'i': newChar = IGrave; break;
				case 'o': newChar = OGrave; break;
				case 'u': newChar = UGrave; break;
			}
			if( newChar ) EvtEnqueueKey( BackSpaceChar, 0, 0 );
			break;

		// Aigu
		case 89:
			switch( lastChar )
			{
				case 'A': newChar = CapitalAAigu; break;
				case 'E': newChar = CapitalEAigu; break;
				case 'I': newChar = CapitalIAigu; break;
				case 'O': newChar = CapitalOAigu; break;
				case 'U': newChar = CapitalUAigu; break;
				case 'a': newChar = AAigu; break;
				case 'e': newChar = EAigu; break;
				case 'i': newChar = IAigu; break;
				case 'o': newChar = OAigu; break;
				case 'u': newChar = UAigu; break;
			}
			if( newChar ) EvtEnqueueKey( BackSpaceChar, 0, 0 );
			break;

		// Dot
		case 81:
			switch( lastChar )
			{
				case 'A': newChar = CapitalADot; break;
				case 'a': newChar = ADot; break;
			}
			if( newChar ) EvtEnqueueKey( BackSpaceChar, 0, 0 );
			break;

	}

	return newChar;
}



/***** DoKeyClick *****/
void DoKeyClick( void )
{
	DWord temp;

	temp = GetKeyClick();
	if( temp ) SndPlaySystemSound( sndClick );
}



/***** IsLower *****/
// Is the character in the range 'a'..'z'?
char IsLower( int theChar )
{
	return ( theChar>='a' && theChar<='z' );
}



/***** HandleShortcuts *****/
// Code to deal with the shortcut macros
// Shortcut Max Length: 10 chars
// Text Max Length: 1024 bytes
// Returns: true if a shortcut was activated
char HandleShortcuts( unsigned char theChar )
{
	char*		lastChars;
	char		buffer[1024];
	int			scp;
	Word		len;
	Err			err;
	int			i;
	DmOpenRef	dmref;
	PrefDBRecord rec;

	
	// Check to see if this was the shortcut charater
	if( theChar == (unsigned char) ShortcutChar )
	{
		SetShortcutPending( kLastLength );
		return false;
	}

	scp = GetShortcutPending();
	if( scp>0 )
	{
		dmref = OpenPrefDB();
		ReadPrefDB( dmref, &rec );
		lastChars = GetLastChars( &rec );
		lastChars[kLastLength-scp] = theChar;
		lastChars[kLastLength-scp+1] = 0;
		WritePrefDB( dmref, &rec );
		ClosePrefDB( dmref );

		len = 1024;
		err = GrfGetAndExpandMacro( lastChars, buffer, &len );
		if( ! err )
		{
			for( i=scp; i<=kLastLength; i++ )
				EvtEnqueueKey( BackSpaceChar, 0, 0 );
			for( i=0; i<len; i++ )
				EvtEnqueueKey( buffer[i], 0, 0 );
			SetShortcutPending( 0 );
			return true;
		}

		SetShortcutPending( scp-1 );
		return false;
	}

	return false;
}



/***** HandleKeyCode *****/
// Handle a keyCode from the keyboard. autoKey is true if this code is
// actually being generated by the auto-repeat code.
void HandleKeyCode( signed char keyCode, char autoKey )
{
	int theChar;
	DWord keymap;
	DWord mod;
	int negKeyCode;
	char shiftDown;


	mod = HandleModifierKeys( keyCode );

	shiftDown = (mod&LShiftMask || mod&RShiftMask);
	UpdateGraffitiStatus( mod&CapsMask, shiftDown );

	// If its a key-up event clear our LastKeydown buffer
	if( keyCode > 0 ) {
		ClearLastKeydown();
		return;
	}

	// Remember the key code and when it was pressed, unless it this key
	// was generated by the auto-key-repeat feature
	if( ! autoKey )
		RememberKeyAndTime( keyCode );

	// Get the current keymap
	keymap = GetCurKeymap();

	// Handle Arrow keys
	theChar = HandleArrowKeys( keyCode, mod );
	if( theChar != 0 ) goto GotChar;

	// All keydown events are negative, so convert it. If keyCodes<77 or
	// >128 are out of range.
	negKeyCode = -keyCode;
	if( negKeyCode < 77 ) return;
	if( negKeyCode > 128 ) return;

	// Do regular character decoding
	if( keymap==HackKeymapQWERTY )
	{
		// ------------------ QWERTY ----------------
		if( !(mod&CtlMask) )
		{
			if( !(mod&OptMask) )
			{
				if( shiftDown )
					theChar = DecodeTblShfQWERTY[ negKeyCode-77 ];
				else
					theChar = DecodeTblQWERTY[ negKeyCode-77 ];
			} else {
				if( shiftDown )
				{
					theChar = HandleForeignShfQWERTY( negKeyCode );
				} else {
					theChar = HandleForeignQWERTY( negKeyCode );
					if( ! theChar )
						theChar = DecodeTblOptQWERTY[ negKeyCode-77 ];
				}
			}
		} else {
			theChar = HandleQWERTYControl( negKeyCode, mod );
		}
	} else {
		// ------------------ Dvorak ----------------
		if( !(mod&CtlMask) )
		{
			if( !(mod&OptMask) )
			{
				if( shiftDown )
					theChar = DecodeTblShfDvorak[ negKeyCode-77 ];
				else
					theChar = DecodeTblDvorak[ negKeyCode-77 ];
			} else {
				if( shiftDown )
				{
					theChar = HandleForeignShfDvorak( negKeyCode );
				} else {
					theChar = HandleForeignDvorak( negKeyCode );
					if( ! theChar )
						theChar = DecodeTblOptDvorak[ negKeyCode-77 ];
				}
			}
		} else {
			theChar = HandleDvorakControl( negKeyCode, mod );
		}
	}


GotChar:
	if( theChar )
	{
		DoKeyClick();

		// If caps lock is down, convert lowercase to uppercase
		if( mod&CapsMask && IsLower( theChar ) )
			theChar += 'A'-'a';

		// If the apple key is down, convert it to a menu-key
		if( mod&AppMask )
			EvtEnqueueKey( CommandStrokeChar, 0, 0 );
		else
			SetLastChar( theChar );

		if( HandleShortcuts( theChar ) == false )
		{
			EvtEnqueueKey( theChar, 0, (theChar>=256?8:0) );
		}
	}

}



/***** GetSerPort *****/
// Get the file descriptor of the serial port from the database
UInt GetSerPort( void )
{
	return GetSerPortID();
}



/***** DoIdle *****/
// This is called every kSleepTime ticks. It grabs any new characters
// from the keyboard, and processes them.
void DoIdle( int serialRef )
{
	char buffer[12];
	ULong numBytes;
	int theChar;
	int i;
	int err;


	err = SerReceiveCheck( serialRef, &numBytes );
	if( err == serErrLineErr ) {
		SerClearErr( serialRef );
		numBytes = 0;
	}

	// Handle at most 10 characters at a time (unlikely to have more)
	if( numBytes > 10 ) numBytes = 10;
	if( numBytes == 0 ) return;


	EvtResetAutoOffTimer();

	// Note: the syntax for SerReceive is different than the docs
	err = SerReceive( serialRef, (VoidPtr) buffer, numBytes, 0 );
	if( err ) {
		if( err == serErrLineErr )
			SerClearErr( serialRef );
		// Ignore other errors
		return;
	}
	
	GrfCleanState();
	for( i=0; i<numBytes; i++ ) {
		HandleKeyCode( buffer[i], false );
	}
}



/***** CheckKeyRepeat *****/
// Check if a key has been held down for at least kKeyRptThresh ticks.
// If so, pass the keycode along to HandleKeyCode.
void CheckKeyRepeat( void )
{
	DWord temp=0;
	ULong theTime,curTime;
	signed char theChar;

	curTime = TimGetTicks();

	GetLastKeyDown( &theTime, &theChar );
	if( theChar==0 ) return;
	if( curTime-theTime > kKeyRptThresh )
		HandleKeyCode( theChar, true );
}



/***** EvtGetEventHack *****/
// This is the patched version of EvtGetEvent. We get called by the
// dummy function in "entry.c"
void EvtGetEventHack( EventPtr event, Long realTimeout )
{
	void (*oldtrap)(EventPtr,Long);
	DWord temp;
	int err;
	int serialRef;


	// Get old trap address from HackMaster
	FtrGet( HackCreatorID, Hack1ID, &temp );
	oldtrap = (void (*)(EventPtr,Long)) temp;


	// If the serial port is closed, EvtGetEvent behaves completely
	// normally.
	serialRef = GetSerPort();
	if( serialRef == 0 )
	{
		oldtrap( (EventPtr) event, realTimeout );
		return;
	}

	// But if the port is open, we have to ensure that nullEvents are
	// generated periodically.
	if( realTimeout == -1 )
	{
		DoIdle( serialRef ); 
		CheckKeyRepeat();
		oldtrap( (EventPtr) event, kSleepTime );
	} else {
		DoIdle( serialRef ); 
		CheckKeyRepeat();
		oldtrap( (EventPtr) event, realTimeout );
	}

}
