
/* *************************************************
 * Copyright (c) 2010 - 2010
 * HT srl,   All rights reserved.
 * Project      : RCS, RCSBlackBerry_lib
 * File         : Manager.java
 * Created      : 26-mar-2010
 * *************************************************/

package blackberry.manager;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

import blackberry.Managed;
import blackberry.Status;
import blackberry.debug.Check;
import blackberry.debug.Debug;
import blackberry.debug.DebugLevel;

/**
 * The Class Manager. Classe astratta che racchiude le funzionalita' di Manager,
 * utili a - far partire un servizio identificato da un id - far partire tutti i
 * servizi registrati - fermare un servizio identificato da un id - fermare
 * tutti i servizi - far fermare e far ripartire un servizio specifico
 */
public abstract class Manager {





    /** The status obj. */
    protected Status status = null;

    protected Hashtable hashtable;

    /**
     * Instantiates a new manager.
     */
    protected Manager() {
        status = Status.getInstance();
        hashtable = new Hashtable();
    }

    /*
     * public final boolean isRunning(int id) { return getItem(id).isRunning();
     * }
     */

    /**
     * Gets the item.
     * 
     * @param id
     *            the id
     * @return the item
     */
    /*
     * (non-Javadoc)
     * @see blackberry.Manager#getItem(int)
     */
    public final synchronized Managed get(final String id) {



        final Managed managed = (Managed) hashtable.get(id);






        return managed;
    }

    public synchronized final Managed add(final Managed managed) {






        Managed replaced = null;
        if (hashtable.containsKey(managed.getId())) {
            replaced = (Managed) hashtable.get(managed.getId());



        }
        hashtable.put(managed.getId(), managed);
        return replaced;
    }

    /*
     * public final boolean isRunning(int id) { return getItem(id).isRunning();
     * }
     */

    /**
     * Gets the all the TimerJob items.
     * 
     * @return the TimerJob items
     */
    public synchronized final Vector getAllItems() {




        final Enumeration e = hashtable.elements();
        final Vector vect = new Vector();

        while (e.hasMoreElements()) {
            vect.addElement(e.nextElement());
        }





        return vect;
    }

    public void clear() {
        hashtable.clear();
    }
















}
