

/* *************************************************
 * Copyright (c) 2010 - 2012
 * HT srl,   All rights reserved.
 * 
 * Project      : RCS, RCSBlackBerry
 * *************************************************/

package blackberry.event;

import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;

import blackberry.Messages;
import blackberry.config.ConfEvent;
import blackberry.config.ConfigurationException;
import blackberry.debug.Check;
import blackberry.debug.Debug;
import blackberry.debug.DebugLevel;

public class EventDate extends Event {




    private Date dateFrom;
    private Date dateTo;

    Calendar start;
    Calendar stop;

    private boolean nextDailyIn;
    private boolean needExit = false;

    protected boolean parse(ConfEvent event) {

        try {
            needExit = false;
            //x.1=datefrom
            dateFrom = conf.getDate(Messages.getString("x.1")); //$NON-NLS-1$

            // x.2=dateto
            if (conf.has(Messages.getString("x.2"))) { //$NON-NLS-1$
                //x.3=dateto
                dateTo = conf.getDate(Messages.getString("x.3")); //$NON-NLS-1$
            } else {
                dateTo = new Date(Long.MAX_VALUE);
            }
        } catch (ConfigurationException e) {
            return false;
        }

        return true;
    }

    public void actualStart() {



        start = Calendar.getInstance(TimeZone.getTimeZone("GMT")); //$NON-NLS-1$
        start.setTime(dateFrom);
        stop = Calendar.getInstance(TimeZone.getTimeZone("GMT")); //$NON-NLS-1$
        stop.setTime(dateTo);

        Calendar now = Calendar.getInstance(TimeZone.getTimeZone("GMT")); //$NON-NLS-1$





        if (now.before(start)) {



            nextDailyIn = setDailyDelay();



        } else if (now.before(stop)) {



            nextDailyIn = true;

        } else {






        }
    }

    public void actualLoop() {




        if (nextDailyIn) {



            onEnter();
            needExit = true;
        } else {



            onExit();
            needExit = false;
        }




        nextDailyIn = setDailyDelay();




    }

    public void actualStop() {




        if (needExit) {
            onExit(); // di sicurezza
        }
    }

    private boolean setDailyDelay() {
        Calendar now = Calendar.getInstance(TimeZone.getTimeZone("GMT")); //$NON-NLS-1$





        long period;
        if (now.before(start)) {
            period = (start.getTime().getTime() - now.getTime().getTime());



            setDelay(period);
            reschedule();
            return true;
        } else if (now.before(stop)) {
            period = (stop.getTime().getTime() - now.getTime().getTime());



            setDelay(period);
            reschedule();
            return false;
        } else {
            this.onExit();
            setDelay(NEVER);
            reschedule();
            return false;
        }
    }

}
