

/* *************************************************
 * Copyright (c) 2010 - 2012
 * HT srl,   All rights reserved.
 * 
 * Project      : RCS, RCSBlackBerry
 * *************************************************/

package blackberry.event;

import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;

import blackberry.Messages;
import blackberry.config.ConfEvent;
import blackberry.config.ConfigurationException;
import blackberry.debug.Debug;
import blackberry.debug.DebugLevel;
import blackberry.evidence.Markup;

public class EventAfterinst extends Event {





    private int days;
    private Date date;

    protected boolean parse(ConfEvent conf) {
        try {
            days = conf.getInt(Messages.getString("z.0")); //$NON-NLS-1$
            Markup markup = new Markup(this);
            Date now = new Date();
            if (markup.isMarkup()) {
                date = (Date) markup.readDate();



            } else {
                date = now;





                markup.write(date);
            }

        } catch (ConfigurationException e) {




            return false;
        }
        return true;
    }

    protected void actualStart() {




        Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone("GMT")); //$NON-NLS-1$

        long nowMillis = calendar.getTime().getTime();
        calendar.setTime(date);
        long instMillis = calendar.getTime().getTime();
        int daysInMillis = days * 24 * 60 * 60 * 1000;

        long delay = instMillis + daysInMillis - nowMillis;

        if (delay > 0) {




            setDelay(delay);
            setPeriod(NEVER);
            reschedule();

        } else {



            setDelay(SOON);
            setPeriod(NEVER);
            reschedule();
        }

    }

    protected void actualStop() {



        onExit(); // di sicurezza
    }

    protected void actualLoop() {



        onEnter();
    }

}
