/*
 * Decompiled with CFR 0.152.
 */
package de.pleumann.antenna;

import de.pleumann.antenna.post.PostProcessor;
import java.io.File;
import java.io.IOException;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;

public class WtkRapc
extends PostProcessor {
    private static final String BB_BUILD_TOOLS_HOME = "bb.buildjars.home";
    private static final String RAPC_EXE = "/rapc.exe";
    private Project project = this.getProject();
    private File jadfile;
    private File source;
    private String codename;
    private String importlibs;
    private boolean quietMode;
    private boolean midletMode;
    private File destDir;

    public void setJadfile(File jadfile) {
        this.jadfile = jadfile;
    }

    public void setSource(File source) {
        this.source = source;
    }

    public void setCodename(String codename) {
        this.codename = codename;
    }

    public void setImport(String importlibs) {
        this.importlibs = importlibs;
    }

    public void setQuiet(boolean b) {
        this.quietMode = b;
    }

    public void setMidlet(boolean b) {
        this.midletMode = b;
    }

    public void setDestdir(File destDir) {
        this.destDir = destDir;
    }

    public void execute() throws BuildException {
        this.project = this.getProject();
        if (this.jadfile == null || this.source == null) {
            throw new BuildException("RAPC needs a JAD and source files");
        }
        String bbjdebuildJars = this.getProject().getProperty(BB_BUILD_TOOLS_HOME);
        if (bbjdebuildJars == null) {
            throw new BuildException("RAPC needs BlackBerry JAR location property defined");
        }
        String rapc = this.getUtility().getQuotedName(new File(bbjdebuildJars + RAPC_EXE));
        String jad = this.getUtility().getQuotedName(this.jadfile);
        String src = this.getUtility().getQuotedName(this.source);
        String arguments = "import=" + this.getUtility().getOutsideQuotedPath(this.importlibs) + " codename=" + this.codename + " " + jad + " " + src;
        String execCmd = rapc + (this.quietMode ? " -quiet " : " ") + (this.midletMode ? " -midlet " : " ") + arguments;
        try {
            StringBuffer t0 = new StringBuffer("RAPC Ant Task v0.1 initialized for project \"" + this.getProject().getName() + "\"");
            while (t0.length() < 58) {
                t0.append(' ');
            }
            StringBuffer t1 = new StringBuffer("Ant task by C. Enrique Ortiz, eortiz@j2medeveloper.com");
            while (t1.length() < 58) {
                t1.append(' ');
            }
            StringBuffer t2 = new StringBuffer("For JDE 3.7 (" + bbjdebuildJars + ")");
            while (t2.length() < 58) {
                t2.append(' ');
            }
            this.log("**************************************************************");
            this.log("* " + t0 + " *");
            this.log("* " + t1 + " *");
            this.log("* " + t2 + " *");
            this.log("**************************************************************");
            this.log("Codename   : " + this.codename);
            this.log("JAD        : " + this.jadfile);
            this.log("Source(s)  : " + this.source);
            this.log("Imports    : " + this.importlibs);
            this.log("MIDlet mode: " + this.midletMode);
            this.log("Quiet mode : " + this.quietMode);
            this.log("DestDir    : " + this.destDir);
            this.log("Compiling now...");
            this.log("");
            Process proc = Runtime.getRuntime().exec(execCmd, null);
            this.getUtility().printProcessOutput(proc);
            int rc = proc.exitValue();
            if (rc != 0) {
                throw new BuildException("Failed (result=" + rc + ")");
            }
            this.project.log("");
            if (this.destDir != null) {
                File srcfile = this.jadfile;
                File destfile = new File(this.destDir + "/" + this.codename + ".jad");
                this.log("Copying file " + srcfile + " To " + destfile);
                this.getUtility().copy(srcfile, destfile);
                srcfile = new File(this.project.getBaseDir() + "/" + this.codename + ".cod");
                destfile = new File(this.destDir + "/" + this.codename + ".cod");
                this.log("Copying file " + srcfile + " To " + destfile);
                this.getUtility().copy(srcfile, destfile);
                srcfile = new File(this.project.getBaseDir() + "/" + this.codename + ".alx");
                destfile = new File(this.destDir + "/" + this.codename + ".alx");
                this.log("Copying file " + srcfile + " To " + destfile);
                this.getUtility().copy(srcfile, destfile);
            }
        }
        catch (IOException ex) {
            this.log("IOException: " + ex);
            throw new BuildException((Throwable)ex);
        }
        catch (Exception e) {
            this.log("Exception: " + e);
            throw new BuildException((Throwable)e);
        }
        finally {
            this.log("Done");
        }
    }
}

