/*
 * Decompiled with CFR 0.152.
 */
package de.pleumann.antenna.misc;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.util.Vector;

public class Strings {
    private Vector strings = new Vector();

    public int add(String s) {
        int result = this.size();
        this.insert(result, s);
        return result;
    }

    public void addStrings(Strings s) {
        for (int i = 0; i < s.size(); ++i) {
            this.add(s.get(i));
        }
    }

    public void assign(Strings s) {
        this.clear();
        this.addStrings(s);
    }

    public void clear() {
        this.strings.clear();
    }

    public void delete(int index) {
        this.strings.remove(index);
    }

    public boolean equals(Object o) {
        if (!(o instanceof Strings)) {
            return false;
        }
        Strings s = (Strings)o;
        if (s.size() != this.size()) {
            return false;
        }
        for (int i = 0; i < s.size(); ++i) {
            if (s.get(i).equals(this.get(i))) continue;
            return false;
        }
        return true;
    }

    public void exchange(int index1, int index2) {
        this.exchangeItem(index1, index2);
    }

    private void exchangeItem(int i, int j) {
        Object s = this.strings.get(i);
        this.strings.set(i, this.strings.get(j));
        this.strings.set(j, s);
    }

    public String get(int index) {
        return (String)this.strings.get(index);
    }

    public int indexOf(String s) {
        for (int i = 0; i < this.size(); ++i) {
            if (!this.get(i).equals(s)) continue;
            return i;
        }
        return -1;
    }

    public void insert(int index, String s) {
        this.strings.insertElementAt(s, index);
    }

    public void move(int oldIndex, int newIndex) {
        String s = this.get(oldIndex);
        this.delete(oldIndex);
        this.insert(newIndex, s);
    }

    public void loadFromFile(String filename) throws IOException {
        this.loadFromFile(new File(filename));
    }

    public void loadFromFile(File filename) throws IOException {
        this.loadFromStream(new FileInputStream(filename));
    }

    public void loadFromFile(File filename, String encoding) throws IOException, UnsupportedEncodingException {
        this.loadFromStream(new FileInputStream(filename), encoding);
    }

    public void loadFromStream(InputStream stream) throws IOException {
        this.clear();
        BufferedReader reader = new BufferedReader(new InputStreamReader(stream));
        int i = 0;
        String s = reader.readLine();
        while (s != null) {
            this.insert(i, s);
            ++i;
            s = reader.readLine();
        }
        reader.close();
    }

    public void loadFromStream(InputStream stream, String encoding) throws IOException, UnsupportedEncodingException {
        this.clear();
        BufferedReader reader = new BufferedReader(new InputStreamReader(stream, encoding));
        int i = 0;
        String s = reader.readLine();
        while (s != null) {
            this.insert(i, s);
            ++i;
            s = reader.readLine();
        }
        reader.close();
    }

    public void saveToFile(String filename) throws IOException {
        this.saveToStream(new FileOutputStream(filename));
    }

    public void saveToFile(String filename, String encoding) throws IOException, UnsupportedEncodingException {
        this.saveToStream(new FileOutputStream(filename), encoding);
    }

    public void saveToStream(OutputStream stream) throws IOException {
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(stream));
        for (int i = 0; i < this.size(); ++i) {
            writer.write(this.get(i));
            writer.newLine();
        }
        writer.close();
    }

    public void saveToStream(OutputStream stream, String encoding) throws IOException, UnsupportedEncodingException {
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(stream, encoding));
        for (int i = 0; i < this.size(); ++i) {
            writer.write(this.get(i));
            writer.newLine();
        }
        writer.close();
    }

    public void set(int index, String s) {
        this.strings.set(index, s);
    }

    public int size() {
        return this.strings.size();
    }

    public String getName(int i) {
        String result = this.get(i);
        int p = result.indexOf(58);
        result = p != -1 ? result.substring(0, p) : null;
        return result;
    }

    public String getValue(String name) {
        int i = this.indexOfName(name);
        if (i != -1) {
            String result = this.get(i);
            i = result.indexOf(58);
            result = result.substring(i + 1);
            return result.trim();
        }
        return null;
    }

    public int indexOfName(String name) {
        String s = name.toLowerCase() + ':';
        for (int i = 0; i < this.size(); ++i) {
            if (!this.get(i).toLowerCase().startsWith(s)) continue;
            return i;
        }
        return -1;
    }

    public void setValue(String name, String value) {
        int i = this.indexOfName(name);
        if (i == -1) {
            if (value != null && !value.equals("")) {
                this.add(name + ": " + value);
            }
        } else if (value != null && !value.equals("")) {
            this.set(i, name + ": " + value);
        } else {
            this.delete(i);
        }
    }

    public Vector getVector() {
        return this.strings;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < this.strings.size(); ++i) {
            sb.append(this.strings.get(i)).append("\n");
        }
        return sb.toString();
    }
}

