/*
 * Decompiled with CFR 0.152.
 */
package ca.slashdev.bb.tasks;

import ca.slashdev.bb.tasks.BaseTask;
import java.io.File;
import java.io.IOException;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.taskdefs.Java;
import org.apache.tools.ant.types.Resource;
import org.apache.tools.ant.types.ResourceCollection;
import org.apache.tools.ant.types.resources.FileResource;
import org.apache.tools.ant.types.resources.Union;

public class SigtoolTask
extends BaseTask {
    private File sigtoolJar;
    private boolean forceClose = false;
    private boolean close = true;
    private boolean request = true;
    private String password;
    private File codFile;
    private Union codFiles = new Union();

    public void setJdeHome(File jdeHome) {
        super.setJdeHome(jdeHome);
        File bin = new File(jdeHome, "bin");
        if (!bin.isDirectory()) {
            throw new BuildException("jde home missing \"bin\" directory");
        }
        this.sigtoolJar = new File(bin, "SignatureTool.jar");
    }

    public void setForceClose(boolean forceClose) {
        this.forceClose = forceClose;
    }

    public void setClose(boolean close) {
        this.close = close;
    }

    public void setRequest(boolean request) {
        this.request = request;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setCodFile(File codFile) {
        this.codFile = codFile;
    }

    public void add(ResourceCollection rc) {
        this.codFiles.add(rc);
    }

    public void execute() throws BuildException {
        super.execute();
        if (this.jdeHome == null) {
            throw new BuildException("jdehome not set");
        }
        if (this.codFiles.size() == 0 && this.codFile == null) {
            throw new BuildException("codfile attribute or nested resource collection element required");
        }
        if (this.codFile != null && this.codFiles.size() > 0) {
            throw new BuildException("codfile attribute cant be used in conjunction with nested elements");
        }
        if (this.codFile != null) {
            this.codFiles.add((ResourceCollection)new FileResource(this.codFile));
        }
        boolean upToDate = true;
        for (Resource r : this.codFiles.listResources()) {
            File touchFile = new File(r.toString().replace(".cod", ".signed"));
            if (r.getLastModified() < touchFile.lastModified()) continue;
            upToDate = false;
            break;
        }
        if (upToDate) {
            this.log("cod files do not appear to be modified since last signature", 1);
        } else {
            this.executeSigtool();
        }
    }

    private void executeSigtool() {
        Java java = (Java)this.getProject().createTask("java");
        java.setTaskName(this.getTaskName());
        java.setFailonerror(true);
        java.setFork(true);
        java.setJar(this.sigtoolJar);
        if (this.password != null) {
            this.close = true;
            this.request = true;
            java.createArg().setValue("-p");
            java.createArg().setValue(this.password);
        }
        if (this.forceClose) {
            java.createArg().setValue("-C");
        }
        if (this.close) {
            java.createArg().setValue("-c");
        }
        if (this.request) {
            java.createArg().setValue("-a");
        }
        for (String file : this.codFiles.list()) {
            java.createArg().setFile(new File(file));
        }
        if (java.executeJava() == 0) {
            for (String file : this.codFiles.list()) {
                this.touch(file);
            }
        }
    }

    private void touch(String codFilePath) {
        try {
            File file = new File(codFilePath.replace(".cod", ".signed"));
            if (!file.exists()) {
                file.createNewFile();
            }
            file.setLastModified(System.currentTimeMillis());
        }
        catch (IOException e) {
            throw new BuildException("error touching file", (Throwable)e);
        }
    }
}

