/*
 * Decompiled with CFR 0.152.
 */
package com.example.ant;

import com.example.ant.SimpleRandomOrgLib;
import java.security.SecureRandom;
import java.util.ArrayList;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

public class RandomString
extends Task {
    private String len;
    private String property;
    SecureRandom random;

    public void execute() throws BuildException {
        if (this.len == null || this.len.equals("")) {
            throw new BuildException("Min property not specified");
        }
        int lenInt = Integer.parseInt(this.len);
        long seed = this.getRandomLong();
        String result = "";
        try {
            this.random = SecureRandom.getInstance("SHA1PRNG");
            this.random.setSeed(seed);
            byte[] bytes = new byte[lenInt];
            this.random.nextBytes(bytes);
            result = RandomString.byteArrayToHexString(bytes);
            this.logInfo("result: " + result);
        }
        catch (Exception ex) {
            this.logInfo(ex.toString());
            result = "S" + seed;
        }
        this.getProject().setNewProperty(this.property, result);
    }

    long getRandomLong() {
        long seed = System.currentTimeMillis();
        try {
            SimpleRandomOrgLib randomorg = new SimpleRandomOrgLib();
            ArrayList<Integer> list = randomorg.randomNumberBaseTenInt(4, 0, 65535);
            int i = 0;
            for (Integer elem : list) {
                this.logInfo(i + " " + elem);
                seed ^= (long)(elem.shortValue() << i * 16);
                ++i;
            }
        }
        catch (Exception ex) {
            this.logInfo(ex.toString());
        }
        this.logInfo("final seed: " + seed);
        return seed;
    }

    public static String byteArrayToHexString(byte[] b) {
        StringBuffer sb = new StringBuffer(b.length * 2);
        for (byte element : b) {
            int v = element & 0xFF;
            if (v < 16) {
                sb.append('0');
            }
            sb.append(Integer.toHexString(v));
        }
        return sb.toString().toUpperCase();
    }

    public void setLen(String len) {
        this.len = len;
    }

    public void setProperty(String property) {
        this.property = property;
    }

    private void logInfo(String message) {
        if (this.getProject() != null) {
            this.log(message, 2);
        } else {
            System.out.println(message);
        }
    }
}

